/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Gary Wang <gary.wang@canonical.com>
 */

#ifndef MCLOUD_API_OUTLINK_H_
#define MCLOUD_API_OUTLINK_H_

#include <mcloud/api/visibility.h>

#include <memory>
#include <string>

namespace tinyxml2 {
    class XMLElement;
}

namespace mcloud {
namespace api {

/*!
    \class Outlink
    \brief Outlink is a cloud extranet link that contains extranet link which can be share by user to others.
 */

class MCLOUD_API_DLL_PUBLIC Outlink {
public:
    typedef std::shared_ptr<Outlink>  Ptr;

    virtual ~Outlink() = default;

    /*!
     * \brief Returns a unique id of extranet object assigned by mcloud.
     */
    const std::string &id() const;

    /*!
     * \brief Returns a unique id of extranet link assigned by mcloud.
     */
    const std::string &link() const;

private:
    Outlink(const tinyxml2::XMLElement *root);

    friend class ClientPriv;

    class Priv;
    std::shared_ptr<Priv> p_;
};

}
}

#endif // MCLOUD_API_OUTLINK_H_
