.TH MAYAVI2 1
.SH NAME
mayavi2 \- A scientific visualization package for 2-D and 3-D data
.SH SYNOPSIS
.B mayavi2 [options]  [args]

Where arg1, arg2 etc\&. are optional file names that correspond to saved
MayaVi2 visualizations (filename\&.mv2) or MayaVi2 scripts
(filename\&.py)\&.

.SH "DESCRIPTION"

.PP
MayaVi2 is a tool for 2-D and 3-D scientific visualization\&. Features
of MayaVi2 include:

.PP
.IP *
Visualization of scalar and vector data in 2 and 3 dimensions
.IP *
Easy scriptability using Python
.IP *
Easy extendability via sources, components, modules, and data filters
.IP *
Reading several file formats: VTK (legacy and XML), PLOT3D, etc\&.
.IP *
Saving of visualizations
.IP *
Saving rendered visualization in a variety of image formats\&.


.SH "OPTIONS"
.PP
.B -h

This prints all the available command line options and exits\&.  Also
available through \fB\-\-help\fP\&.

.PP
.B -V

This prints the MayaVi version on the command line and exits\&.  Also
available through \fB\-\-version\fP\&.

.PP
.B -z filename\&.mv2

This loads a previously saved MayaVi2 visualization\&.  Also available
through \fB\-\-viz\fP filename\&.mv2 or \fB\-\-visualization\fP
filename\&.mv2\&.

.PP
.B -d
vtk_file\&.vt*

Opens a (legacy or XML) VTK file passed as the argument\&.  Also
available through \fB\-\-vtk\fP\&.

.PP
.B -p
plot3d_xyz_file

This opens a PLOT3D co-ordinate file passed as the argument\&.  The
plot3d-xyz-file must be a PLOT3D single block co-ordinate file\&. Also
available through \fB\-\-plot3d\-xyz\fP\&.

.PP
.B -q
plot3d_q_file

This opens a PLOT3D (single block) solution file passed as the
argument\&. Please note that this option must always follow a \fB\-q\fP or
\fB\-\-plot3d-xyz\fP option\&.  Also available through \fB\-\-plot3d\-q\fP\&.

.PP
.B -w
vrml-file

Imports a VRML2 scene given an appropriate file\&.  Also available
through \fB\-\-vrml\fP\&.

.PP
.B -3
3DStudio-file

Imports a 3D Studio scene given an appropriate file\&.  Also available
through \fB\-\-3ds\fP\&.

.PP
.B -m
module-name

A module is an object that actually visualizes the data\&.  The given
module-name is loaded in the current ModuleManager\&.  The module name
must be a valid one if not you will get an error message\&.

If a module is specified as 'package\&.sub\&.module\&.SomeModule' then the
module (SomeModule) is imported from 'package\&.sub\&.module'\&.  Standard
modules provided with mayavi2 do not need the full path
specification\&.  For example:
.PP
.RS
\f(CWmayavi2 \-d data\&.vtk \-m Outline \-m m2_user_modules\&.TestModule\fP
.RE

In this example 'Outline' is a standard module 
and 'm2_user_modules\&.TestModule' is some user defined module\&.  See
.B MAYAVI2 MODULES
section below for an exhaustive list of available modules\&.  Also
available through \fB\-\-module\fP\&.

.PP
.B -f
filter-name

A filter is an object that filters out the data in some way or the
other\&.  The given filter-name is loaded with respect to the current
source/filter object\&.  The filter name must be a valid one if not you
will get an error message\&.

If the filter is specified as 'package\&.sub\&.filter\&.SomeFilter' then the
filter (`SomeFilter`) is imported from 'package\&.sub\&.filter'\&.  Standard
modules provided with mayavi2 do not need the full path
specification\&.  For example:
.PP
.RS
\f(CWmayavi2 \-d data\&.vtk \-f ExtractVectorNorm \-f m2_user_filters\&.TestFilter\fP
.RE

In this example 'ExtractVectorNorm' is a standard filter 
and 'm2_user_filters\&.TestFilter' is some user defined filter\&.

See
.B MAYAVI2 FILTERS
section below for an exhaustive list of available filters\&. Also
available through \fB\-\-filter\fP\&.

.PP
.B -M

Starts up a new module manager on the MayaVi pipeline\&. Also available
through \fB\-\-module\-mgr\fP\&.

.PP
.B -n

Creates a new window/scene\&. Any options passed after this will apply
to this newly created scene\&.  Also available through \fB\-\-new\-window\fP\&.

.PP
.B -x
script-file

This executes the given script in a namespace where we guarantee that
the name 'mayavi' is MayaVi's script instance -- just like in the
embedded Python interpreter\&.  Also available through \fB\-\-exec\fP

.B WARNING:
Note that this uses `execfile`, so please note that
this can be dangerous if the script does something nasty!


.SH "MAYAVI2 MODULES"

.TP
.B Axes
Draws simple axes\&.

.TP
.B ContourGridPlane
A contour grid plane module\&. This module lets one take a slice of
input grid data and view contours of the data\&.

.TP
.B CustomGridPlane
A custom grid plane with a lot more flexibility than GridPlane module\&.

.TP
.B Glyph
Displays different types of glyphs oriented and colored as per scalar
or vector data at the input points\&.

.TP
.B GridPlane
A simple grid plane module\&.

.TP
.B ImagePlaneWidget
A simple module to view image data\&.

.TP
.B IsoSurface
A module that allows the user to make contours of input point data\&.

.TP
.B OrientationAxes
Creates a small axes on the side that indicates the position of the
co-ordinate axes and thereby marks the orientation of the
scene\&. Requires VTK-4\&.5 and above\&.

.TP
.B Outline
A module that draws an outline for the given data\&.

.TP
.B ScalarCutPlane
Takes a cut plane of any input data set using an implicit plane and
plots the data with optional contouring and scalar warping\&.

.TP
.B SliceUnstructuredGrid
This module takes a slice of the unstructured grid data and shows the
cells that intersect or touch the slice\&.

.TP
.B Streamline
Allows the user to draw streamlines for given vector data\&. This
supports various types of seed objects (line, sphere, plane and point
seeds)\&. It also allows the user to draw ribbons or tubes and further
supports different types of interactive modes of calculating the
streamlines\&.

.TP
.B StructuredGridOutline
Draws a grid-conforming outline for structured grids\&.

.TP
.B Surface
Draws a surface for any input dataset with optional contouring\&.

.TP
.B Text
This module allows the user to place text on the screen\&.

.TP
.B VectorCutPlane
Takes an arbitrary slice of the input data using an implicit cut plane
and places glyphs according to the vector field data\&. The glyphs may
be colored using either the vector magnitude or the scalar attributes\&.

.TP
.B Vectors
Displays different types of glyphs oriented and colored as per vector
data at the input points\&. This is merely a convenience module that is
entirely based on the Glyph module\&.

.TP
.B Volume
The Volume module visualizes scalar fields using volumetric
visualization techniques\&.

.TP
.B WarpVectorCutPlane
Takes an arbitrary slice of the input data using an implicit cut plane
and warps it according to the vector field data\&. The scalars are
displayed on the warped surface as colors\&.


.SH "MAYAVI2 FILTERS"

.TP
.B CellToPointData
Transforms cell attribute data to point data by averaging the cell
data from the cells at the point\&.

.TP
.B Delaunay2D
Performs a 2D Delaunay triangulation\&.

.TP
.B Delaunay3D
Performs a 3D Delaunay triangulation\&.

.TP
.B ExtractGrid
Allows a user to select a part of a structured grid\&.

.TP
.B ExtractUnstructuredGrid
Allows a user to select a part of an unstructured grid\&.

.TP
.B ExtractVectorNorm
Computes the norm (Eucliedean) of the input vector data (with optional
scaling between [0, 1])\&. This is useful when the input data has vector
input but no scalar data for the magnitude of the vectors\&.

.TP
.B MaskPoints
Selectively passes the input points downstream\&. This can be used to
subsample the input points. Note that this does not pass geometry
data, this means all grid information is lost\&.

.TP
.B PointToCellData
Does the inverse of the CellToPointData filter\&.

.TP
.B PolyDataNormals
Computes normals from input data\&. This gives meshes a smoother
appearance\&. This should work for any input dataset\&. Note: this filter
is called "Compute Normals" in MayaVi2 GUI (Visualize/Filters/Compute
Normals)\&.

.TP
.B Threshold
A simple filter that thresholds on input data\&.

.TP
.B TransformData
Performs a linear transformation to input data\&.

.TP
.B WarpScalar
Warps the input data along a particular direction (either the normals
or a specified direction) with a scale specified by the local scalar
value\&. Useful for making carpet plots\&.

.TP
.B WarpVector
Warps the input data along a the point vector attribute scaled as per
a scale factor\&.  Useful for showing flow profiles or displacements\&.

.SH "EXAMPLES"

.PP
.RS
\f(CWmayavi2 \-d heart\&.vtk \-m Axes \-m Outline \-m GridPlane \-m ContourGridPlane \-m IsoSurface\fP
.br
\f(CWmayavi2 \-d fire_ug\&.vtu \-m Axes \-m Outline \-m VectorCutPlane \-f MaskPoints \-m Glyph\fP
.br
.RE

.PP
In the above examples, heart\&.vti and fire_ug\&.vtu VTK files can be
found in /usr/share/doc/mayavi2/examples/data\&. The examples directory
(/usr/share/doc/mayavi2/examples/ on Debian) provides several useful
examples\&.

.SH "AUTHOR"

.PP 
MayaVi was originally developed by Prabhu Ramachandran.  Many people
have later contributed to it.
.PP
More information on MayaVi2 can be obtained from
http://code\&.enthought\&.com/mayavi2
