""" Base class for all function actions. """


# Enthought library imports.
from enthought.traits.api import Str

# Local imports.
from workbench_action import WorkbenchAction


class FunctionAction(WorkbenchAction):
    """ Base class for all workbench actions. """

    #### 'FunctionAction' interface ##########################################

    # The symbol name of the function.
    function_name = Str

    ###########################################################################
    # 'Action' interface.
    ###########################################################################

    def perform(self, event):
        """ Performs the action. """                

        function = event.application.import_symbol(self.function_name)
        function()

        mod = '.'.join(self.function_name.split('.')[:-1])
        func = self.function_name.split('.')[-1]

        #s1 = 'from %s import %s\n' % (mod, func)
        #s2 = '%s()\n' % func
        
        #event.window.add_to_macro(s1)
        #event.window.add_to_macro(s2)
        
        return
    
#### EOF ######################################################################
