#-----------------------------------------------------------------------------
#
#  Copyright (c) 2006 by Enthought, Inc.
#  All rights reserved.
#
#-----------------------------------------------------------------------------

""" Preference page for default path for a project
"""

# Enthought library imports
from enthought.envisage import get_application
from enthought.envisage.workbench.preference import WorkbenchPreferencePage
from enthought.traits.api import Directory, Str
from enthought.traits.ui.api import View, Item

# Global assignment of ID
ID = 'enthought.envisage.single_project'

#-------------------------------------------------------------------------------
#   DefaultPathPreferencePage Class
#-------------------------------------------------------------------------------

class DefaultPathPreferencePage(WorkbenchPreferencePage):
    """ Preference page for default path for a plugin.
    """

    # Choose the unit system that needs to be used for the project
    preferred_path = Directory('')

    # Set the traits view
    traits_view = View(Item('preferred_path',
                    tooltip='Path that will be used for storing projects'))

    #---------------------------------------------------------------------------
    #   Workbench interface
    #---------------------------------------------------------------------------

    ### protected methods ------------------------------------------------------
    def _get_preferences(self):
        """ Returns the preferences that this page is editing.
        """

        return get_application().get_preferences(ID)


### EOF ------------------------------------------------------------------------
