#------------------------------------------------------------------------------
# Copyright (c) 2005, Enthought, Inc.
# All rights reserved.
# 
# This software is provided without warranty under the terms of the BSD
# license included in enthought/LICENSE.txt and may be redistributed only
# under the conditions described in the aforementioned license.  The license
# is also available online at http://www.enthought.com/licenses/BSD.txt
# Thanks for using Enthought open source!
# 
# Author: Enthought, Inc.
# Description: <Enthought library component>
#------------------------------------------------------------------------------

from os.path import join
from glob import glob
from scipy_distutils.core      import setup
from scipy_distutils.misc_util import get_subpackages, dict_append, get_path
from scipy_distutils.misc_util import merge_config_dicts, default_config_dict

def configuration(parent_package='',parent_path=None):
    package_name = 'envisage'
    local_path = get_path(__name__,parent_path)
    
    config = default_config_dict(package_name, parent_package)

    install_path = join(*config['name'].split('.'))

    config['data_files'].extend([
        (join(install_path,'examples','Simple UI','action','images'),
         glob(join(local_path,'examples','Simple UI','action','images','*.bmp'))),
        (join(install_path,'project','images'),
         glob(join(local_path,'project','images','*.png'))),
        (join(install_path,'project','action','images'),
         glob(join(local_path,'project','action','images','*.png'))),
        (join(install_path,'project','view','images'),
         glob(join(local_path,'project','view','images','*.png'))),
        (join(install_path,'project','wizard','images'),
         glob(join(local_path,'project','wizard','images','*.png'))),
        (join(install_path, 'resource','images'),
         glob(join(local_path,'resource','images','*.png'))),
        (join(install_path, 'repository','images'),
         glob(join(local_path,'repository','images','*.png'))),
        (join(install_path,'ui','images'),
         glob(join(local_path,'ui','images','*.bmp'))),         
        (join(install_path,'single_project','images'),
         glob(join(local_path,'single_project','images','*.png'))),         
        (join(install_path,'examples', 'plugin', 'simple_ui', 'action','images'),
         glob(join(local_path,'examples', 'plugin', 'simple_ui', 'action','*.bmp'))),         
        ])

    config_list = [config]
    config_list += get_subpackages(local_path,
                                   parent=config['name'],
                                   parent_path=parent_path,
                                   recursive=1,
                                   )
    config_dict = merge_config_dicts(config_list)
    
    return config_dict

if __name__ == '__main__':
    setup(**configuration(parent_path=''))
