""" The model for a resource tree. """


# Enthought library imports.
from enthought.envisage.resource import ResourceManager
from enthought.naming.ui.api import NamingTreeModel
from enthought.traits.api import Instance

# Local imports.
from resource_tree_node_manager import ResourceTreeNodeManager


class ResourceTreeModel(NamingTreeModel):
    """ The model for a resource tree. """

    #### 'ResourceTreeModel' interface ########################################

    # The resource manager.
    resource_manager = Instance(ResourceManager)

    ###########################################################################
    # 'Private' interface
    ###########################################################################

    def _resource_manager_changed(self, old, new):
        """ Called when the resource manager is changed. """

        self.node_manager = ResourceTreeNodeManager(resource_manager=new)

        return
    
#### EOF ######################################################################
