""" Some common sorters for use with a resource tree. """


# Enthought library imports.
from enthought.naming.api import Context
from enthought.pyface.api import Sorter


class FoldersBeforeFiles(Sorter):
    """ A sorter that arranges folders before files. """
    
    def category(self, widget, parent, node):
        """ Returns the category (an integer) for an node.

        'widget' is the widget that we are sorting nodes for.
        'parent' is the parent node.
        'nodes'  is the node to return the category for.

        Categories are used to sort nodes into bins.  The bins are arranged in
        ascending numeric order.  The nodes within a bin are arranged as
        dictated by the sorter's 'compare' method.

        """
        
        if isinstance(node.obj, Context):
            category = 0

        else:
            category = 1

        return category

#### EOF ######################################################################
