""" The base class for all resource serializers. """


# Enthought library imports.
from enthought.naming.api import ObjectSerializer
from enthought.traits.api import Instance


class ResourceSerializer(ObjectSerializer):
    """ The base class for all resource serializers. """

    #### 'ResourceSerializer' interface #######################################
    
    # The resource type that we are the serializer type for.
    resource_type = Instance('enthought.envisage.resource.ResourceType')
    
    ###########################################################################
    # 'ObjectSerializer' interface.
    ###########################################################################
    
    def can_save(self, obj):
        """ Returns True if the serializer can save an object. """

        return self.resource_type.is_type_for(obj)

### EOF #######################################################################
