""" The node type for Python objects. """


# Enthought library imports.
from enthought.naming.api import NameNotFoundError
from enthought.pyface.api import ImageResource

# Local imports.
from resource_node_type import ResourceNodeType


class ObjectNodeType(ResourceNodeType):
    """ The node type for Python objects. """

    #### 'NodeType' interface #################################################

    # The image used to represent nodes of this type.
    image = ImageResource('object')

    ###########################################################################
    # 'NodeType' interface.
    ###########################################################################

    def set_text(self, node, text):
        """ Sets the label text for a node. """

        # Making sure text is not an empty string

        if text is not None and len(text) > 0:
            # Rename the object.
            self.resource_type.set_name(node.obj, text)

            # Do the rename in the naming system.
            #
            # If the node is monitored then the rename will have already been done.
            try:
                node.context.lookup(text)

            except NameNotFoundError:
                node.context.rename(node.name, text)

            # Update the binding (the naming system knows nothing about this
            # binding, so it is up to us to keep it up to date).
            node.name = text
        else:
            # Make no changes
            pass

        return

#### EOF ######################################################################
