#-----------------------------------------------------------------------------
#
# Copyright (c) 2006 by Enthought, Inc.
# All rights reserved.
#
# This software is provided without warranty under the terms of the BSD
# license included in enthought/LICENSE.txt and may be redistributed only
# under the conditions described in the aforementioned license.  The license
# is also available online at http://www.enthought.com/licenses/BSD.txt
# Thanks for using Enthought open source!
#
# Author: Dave Peterson <dpeterson@enthought.com>
#
#-----------------------------------------------------------------------------

"""
A node type for action resources.

"""

# Local imports.
from object_node_type import ObjectNodeType


class ActionResourceNodeType(ObjectNodeType):
    """
    A node type for action resources.

    """


    ###########################################################################
    # 'NodeType' interface.
    ###########################################################################

    #### public interface ####################################################

    def allows_children(self, node):
        """
        Does the node allow children (ie. a folder vs a file).

        """

        return False


    def can_copy(self, node):
        """
        Can a node be copied?

        Overridden to prevent copying of action resources.

        """

        return False


    def can_set_text(self, node, text):
        """
        Return True if the node's label can be set.

        Overridden to prevent setting of the node's label.

        """

        return False


    def get_context_menu(self, node):
        """
        Return the context menu for the specified node.

        Overridden to query the node for its context menu.

        """

        return node.obj.get_context_menu()


    def get_default_action(self, node):
        """
        Return the default action for a node.

        Overridden to use the default action specified on the node.

        """

        return node.obj.get_default_action()


    def get_image(self, node, selected, expanded):
        """
        Return the label image for a node.

        Overridden to return the image associated with the action resource.

        """

        return node.obj.image


    def is_collapsible(self, node):
        """
        Return True if the node is collapsible, otherwise False.

        Overridden to indicate action resources can not be collapsed.

        """

        return False


    def is_draggable(self, node):
        """
        Return True if the node is draggablee, otherwise False.

        Overridden to indicate action resources can not be dragged.

        """

        return False


    def is_editable(self, node):
        """
        Return True if the node is editable, otherwise False.

        Overridden to prevent editing of action resources.

        """

        return False


    def is_expandable(self, node):
        """
        Return True if the node is expandanble, otherwise False.

        Overridden to indicate action resources can not be expanded.

        """

        return False


#### EOF ######################################################################

