""" The project plugin. """


# Enthought library imports.
from enthought.envisage import ExtensionItem, ExtensionPoint, PluginDefinition
from enthought.traits.api import List, Str

# Plugin definition imports.
from enthought.envisage.core.core_plugin_definition \
     import Preferences

from enthought.envisage.ui.ui_plugin_definition \
     import Action, EnabledWhen, Group, Menu, UIActions, UIViews, View

from enthought.envisage.resource.resource_plugin_definition \
    import ResourceType, ResourceManager

from enthought.envisage.resource.resource_ui_plugin_definition \
    import ResourceWizard, ResourceWizards
    
from enthought.envisage.resource.resource_ui_plugin_definition \
     import CookieImplementation, CookieImplementations

from enthought.envisage.resource.resource_ui_plugin_definition \
    import ResourceAction, ResourceActions, ResourceMenu

from enthought.envisage.resource.resource_plugin_definition \
    import FILE_RESOURCE_TYPE

# The plugin's globally unique identifier (also used as the prefix for all
# identifiers defined in this module).
ID = "enthought.envisage.project"

#### Resource types ###########################################################
# Resource types specific to this plugin.
PROJECT_RESOURCE_TYPE   = ID + '.project_resource_type.ProjectResourceType'
WORKSPACE_RESOURCE_TYPE = ID + '.workspace_resource_type.WorkspaceResourceType'

resource_types = ResourceManager(
    resource_types = [
        ResourceType(
            class_name = PROJECT_RESOURCE_TYPE,
            precedes   = [WORKSPACE_RESOURCE_TYPE]
        ),

        ResourceType(
            class_name = WORKSPACE_RESOURCE_TYPE,
            precedes   = [FILE_RESOURCE_TYPE]
        ),
    ]
)

#### Resource actions #########################################################

resource_actions = ResourceActions(
    menus = [
        ResourceMenu(
            id            = "NewMenu",
            name          = "New",

            resource_type = "",
            path          = "system_top",
            
            groups = [
                Group(id = "ProjectGroup"),
                Group(id = "FolderGroup"),
                Group(id = "OtherGroup"),
                Group(id = "RecentGroup"),
            ]
        )
    ],
    
    actions = [
        ResourceAction(
            id            = ID + ".action.new_project_action.NewProjectAction",
            class_name    = ID + ".action.new_project_action.NewProjectAction",
            name          = "Project...",
            image         = "action/images/new_project",
            description   = "Create a new project",
            tooltip       = "Create a new project",
            style         = "push",

            resource_type = "",
            path          = "NewMenu/ProjectGroup",
        ),

        ResourceAction(
            id            = ID + ".action.new_folder_action.NewFolderAction",
            class_name    = ID + ".action.new_folder_action.NewFolderAction",
            name          = "Folder...",
            image         = "action/images/new_folder",
            description   = "Create a new folder",
            tooltip       = "Create a new folder",
            style         = "push",

            resource_type = "",
            path          = "NewMenu/FolderGroup",
        ),

        ResourceAction(
            id            = ID + ".action.new_file_action.NewFileAction",
            class_name    = ID + ".action.new_file_action.NewFileAction",
            name          = "File...",
            image         = "action/images/new_file",
            description   = "Create a new file",
            tooltip       = "Create a new file",
            style         = "push",
            
            resource_type = "",
            path          = "NewMenu/FolderGroup",
        ),

        ResourceAction(
            id            = ID + ".action.new_other_action.NewOtherAction",
            class_name    = ID + ".action.new_other_action.NewOtherAction",
            name          = "&Other...",
            image         = "action/images/new_other",
            description   = "Create a new resource",
            tooltip       = "Create a new resource",
            style         = "push",

            resource_type = "",
            path          = "NewMenu/OtherGroup",
        )
    ]
)

#### Preferences ##############################################################

preferences = Preferences(
    defaults = {
        # The location of the workspace.
        'workspace_location' : None,

        # If this is False then user gets a chance to select the workspace
        # location EVERY time the application starts up.
        'use_as_default' : False,
        
        # The names of the projects that were open last time.
        'open_projects' : [],
    }
)

#### Menus/Actions ############################################################

ui_actions = UIActions(
    menus = [
        Menu( 
            id     = "NewMenu",
            name   = "New",
            path   = "FileMenu/Start",
            
            groups = [
                Group(id = "ProjectGroup"),
                Group(id = "FolderGroup"),
                Group(id = "OtherGroup"),
            ]
        )
    ],
    
    actions = [
        Action(
            id      = ID + ".action.save_workspace_action.SaveWorkspaceAction",
            class_name=ID+".action.save_workspace_action.SaveWorkspaceAction",
            name          = "S&ave Workspace...",
            image         = "action/images/save_workspace",
            description   = "Save all projects in the workspace",
            tooltip       = "Save all projects in the workspace",
            menu_bar_path = "FileMenu/Start",
            tool_bar_path = "additions",
            style         = "push",
            accelerator   = "Ctrl+Shift+S"
        ),
    
        Action(
            id            = ID + ".action.new_project_action.NewProjectAction",
            class_name    = ID + ".action.new_project_action.NewProjectAction",
            name          = "P&roject...",
            image         = "action/images/new_project",
            description   = "Create a new project",
            tooltip       = "Create a new project",
            menu_bar_path = "FileMenu/NewMenu/ProjectGroup",
            tool_bar_path = "additions",
            style         = "push",
        ),

        Action(
            id            = ID + ".action.new_folder_action.NewFolderAction",
            class_name    = ID + ".action.new_folder_action.NewFolderAction",
            name          = "Folder...",
            image         = "action/images/new_folder",
            description   = "Create a new folder",
            tooltip       = "Create a new folder",
            menu_bar_path = "FileMenu/NewMenu/FolderGroup",
            tool_bar_path = "",
            style         = "push",
        ),

        Action(
            id            = ID + ".action.new_file_action.NewFileAction",
            class_name    = ID + ".action.new_file_action.NewFileAction",
            name          = "File...",
            image         = "action/images/new_file",
            description   = "Create a new file",
            tooltip       = "Create a new file",
            menu_bar_path = "FileMenu/NewMenu/FolderGroup",
            tool_bar_path = "",
            style         = "push",
        ),

        Action(
            id            = ID + ".action.new_other_action.NewOtherAction",
            class_name    = ID + ".action.new_other_action.NewOtherAction",
            name          = "&Other...",
            image         = "action/images/new_other",
            description   = "Create a new resource",
            tooltip       = "Create a new resource",
            menu_bar_path = "FileMenu/NewMenu/OtherGroup",
            tool_bar_path = "",
            style         = "push",
            accelerator   = "Ctrl+N"
        )
    ]
)

#### Views ####################################################################

ui_views = UIViews(
    views = [
        View(
            id         = ID + ".view.NavigatorView",
            class_name = ID + ".view.NavigatorView",
            image      = "images/navigator_view.png",
            name       = "Navigator",
        )
    ]
)

###############################################################################
# The plugin definition.
###############################################################################

PluginDefinition(
    # The plugin's globally unique identifier.
    id = ID,

    # The name of the class that implements the plugin.
    class_name = ID + ".project_plugin.ProjectPlugin",

    # General information about the plugin.
    name          = "Project Plugin",
    version       = "1.0.0",
    provider_name = "Enthought Inc",
    provider_url  = "www.enthought.com",
    enabled       = True,
    autostart     = False,
    
    # The Id's of the plugins that this plugin requires.
    requires = [
        "enthought.envisage.core",
        "enthought.envisage.ui",
        "enthought.envisage.resource",
        "enthought.envisage.resource_ui"
    ],

    # The contributions that this plugin makes to extension points offered by
    # either itself or other plugins.
    extensions = [
        preferences,
        ui_actions, ui_views,
        resource_types, resource_actions,
    ]
)

#### EOF ######################################################################
