""" A project. """


# Enthought library imports.
from enthought.envisage.resource import ResourceContext
from enthought.traits.api import Instance

# Local imports.
from folder import Folder
from workspace_project import WorkspaceProject


class Project(ResourceContext, WorkspaceProject):#Folder):
    """ A project. """

    # The workspace that the project belongs to.
    workspace =  Instance('enthought.envisage.project.Workspace')
    
    ###########################################################################
    # 'Project' interface.
    ###########################################################################

    def create_folder(self, name):
        """ Creates a folder with the specified name. """

        folder = self.create_subcontext(name)

        return folder

    ###########################################################################
    # Protected 'Context' interface.
    ###########################################################################

    def _context_factory(self, name, path=None):
        """ Create a sub-context. """

        if path is None:
            path = os.path.join(self.path, name)

        return Folder(path=path, project=self, environment=self.environment)
    
##### EOF #####################################################################
