""" The resource type for plugin files. """


# Enthought library imports.
from enthought.envisage.resource import ObjectResourceType
from enthought.io import File
from enthought.traits.api import Instance

class PluginResourceType(ObjectResourceType):
    """ The resource type for plugin files. """

    #### 'ResourceType' interface #############################################

    # A trait that describes the kind of domain object that the resource type
    # represents.
    type = Instance(File)

    #### Methods ##############################################################

    def is_type_for(self, obj):
        """ Returns True if the resource type recognizes an object. """

        result = super(PluginResourceType, self).is_type_for(obj)

        # we look for .zip or .plugin endings
        if result and (obj.ext == '.zip' or obj.ext == '.plugin'):
            result = True
        else:
            result = False
            
        return result
    
##### EOF #####################################################################
