/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#ifndef __UPDATEDIALOG_H__
#define __UPDATEDIALOG_H__
//-----------------------------------------------------------------------------------------------------------------------
#include <kprocess.h>
#include <qstring.h>
#include <qurloperator.h>
#include "wupdatedialog.h"
//-----------------------------------------------------------------------------------------------------------------------
class UpdateDialog : public UpdateDlg
{
	Q_OBJECT
public:
	UpdateDialog(bool autoClose, bool isShown, QString curVer, QString command);
	~UpdateDialog();

public slots:
	virtual void receivedStdout(KProcess*, char *buffer, int buflen);
	virtual void receivedStderr(KProcess*, char *buffer, int buflen);
	virtual void processExited(KProcess*);
	virtual void checkVersionClicked();
	void cancelClicked();
	void dataReceived(const QByteArray &data, QNetworkOperation*);
	void netOperationFinished(QNetworkOperation *nop);

private:
	KProcess *m_proc;
	QUrlOperator *m_uop;
	bool m_autoClose;
	QString m_curVer;
	QByteArray m_data;

};
//-----------------------------------------------------------------------------------------------------------------------
#endif
//-----------------------------------------------------------------------------------------------------------------------
