/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#include <kiconloader.h>
#include <kpopupmenu.h>
#include <klocale.h>
#include <qtooltip.h>
#include "trayicon.h"
#include "mainwidget.h"
//-----------------------------------------------------------------------------------------------------------------------
TrayIcon::TrayIcon(QWidget *parent, MainWidget *widget, const char *name) : KSystemTray(parent, name)
{
	QToolTip::add(this, "Maxemum TV-Guide");
	setPixmap(loadIcon("maxemumtvguide"));
	contextMenu()->changeTitle(-2, SmallIcon("maxemumtvguide"), "Maxemum TV-Guide");
	contextMenu()->insertSeparator();
	contextMenu()->insertItem(i18n("&About"), widget, SLOT(aboutClicked()));
	connect(this, SIGNAL(quitSelected()), widget, SLOT(shuttingDown()));
	show();
}
//-----------------------------------------------------------------------------------------------------------------------
