/*!***************************************************************************

  module      : IspcIdl2Code.h

  -------------------------------------------------------------------------

  responsible : FerdiF

  special area: IDL to Code Generator   
  description : Main prgram for code generation out of a XML File
				
  
  last changed: 2000-03-08  11:22
  see also    : 

  -------------------------------------------------------------------------

  copyright:    Copyright by SAP AG, 2000



    ========== licence begin LGPL
    Copyright (C) 2000 SAP AG

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ========== licence end

*****************************************************************************/

#ifndef ISPCIDL2CODE_H
#define ISPCIDL2CODE_H

typedef enum { dbo_method_ispc, dbo_proc_ispc } DboType_Enum_ispc;

typedef enum { attName_ispc, attString_ispc, attNumber_ispc, attChar_ispc, 
    attPack_ispc, attUuid_ispc, attType_ispc, attDimension_ispc, 
    attDirection_ispc, attExpression_ispc, attUnknown_ispc
} XmlAttributeType_Enum_ispc;

typedef enum { elemLibrary_ispc, elemCpp_ispc, elemPragma_ispc, elemImport_ispc, elemConst_ispc,
    elemTypedef_ispc, elemStruct_ispc, elemMember_ispc, elemEnum_ispc, elemInclude_ispc,
    elemInterface_ispc, elemIdl_ispc, elemCoClass_ispc, elemParam_ispc, elemIdl2Xml_ispc, 
    elemExpr_ispc, elemSub_ispc, elemAdd_ispc, elemFloat_ispc, elemFixed_ispc, elemMul_ispc,
    elemDiv_ispc, elemMod_ispc, elemIdent_ispc, elemUnknown_ispc 
} XmlElementType_Enum_ispc;

XmlAttributeType_Enum_ispc ispc_getAttributeType(const char* attribute);
XmlElementType_Enum_ispc   ispc_getElementType(const char* element);

int ispc_getWarnLevel();    /* PTS 1109175 */

int ispc_getMultiOffsets(); /* PTS 1115374 */

#endif

