/*!***************************************************************************

  module      : IspcCGenHFile.cpp

  -------------------------------------------------------------------------

  responsible : FerdiF

  special area: IDL to Code Generator   
  description : Generate header file out of generated XML file
				
  
  last changed: 2000-03-08  11:22
  see also    : 

  -------------------------------------------------------------------------

  copyright:    Copyright by SAP AG, 2000



    ========== licence begin LGPL
    Copyright (C) 2000 SAP AG

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ========== licence end

*****************************************************************************/

#include <ctype.h>
#include <fstream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <iostream.h>

#include "idl/xml2ispc/IspcCGenHFile.h"
#ifndef ISPCIDL2CODE_H
#include "idl/xml2ispc/IspcIdl2Code.h"
#endif

/*----------------------------------------------------------------------*/
/* class IspcCGenHFile                                                  */
/*----------------------------------------------------------------------*/

IspcCGenHFile::IspcCGenHFile() {
  m_is_within_import  = '\0';
  m_is_within_include = '\0';
  m_is_within_struct  = 0;
};

/*----------------------------------------------------------------------*/

IspcCGenHFile::~IspcCGenHFile() {
  m_out_h << endl; /* PTS 1110140 */
  m_out_h.close();
  m_out_c << endl; /* PTS 1110140 */
  m_out_c.close();
};

/*----------------------------------------------------------------------*/

int IspcCGenHFile::Init(char*  cFilename) {
  m_is_within_import  = '\0';
  m_is_within_include = '\0';
  m_is_within_struct  = 0;
  strcpy(&m_filename[0], cFilename);
  char* pc = strrchr(&m_filename[0],'.');
  if ( pc ) {
    *pc = '\0';
  }
#if defined(_WIN32)
  pc = strrchr(m_filename,'\\'); 
#else
  pc = strrchr(m_filename,'/'); 
#endif
  if ( pc )
    strcpy(m_name, pc + 1);
  else
    strcpy(m_name,&m_filename[0]);


  m_out_h.open(strcat(&m_filename[0],".h"));
  if ( m_out_h.fail() )
    return 0;
  strcpy(&m_filename[0],m_name);
  m_out_c.open(strcat(&m_filename[0],"_i.c"));
  if ( m_out_c.fail() )
    return 0;

  m_out_h << "#ifndef __" << &m_name[0] << "_h__"          << endl;
  m_out_h << "#define __" << &m_name[0] << "_h__"          << endl;
  m_out_h                                                  << endl;
  m_out_h << "#include \"oaidl.h\" /* no check */"         << endl; /* PTS 1112974 */
  m_out_h                                                  << endl;
  m_out_h << "#ifndef __I" << &m_name[0] << "_FWD_DEFINED__"                   << endl;
  m_out_h << "#define __I" << &m_name[0] << "_FWD_DEFINED__"                   << endl;
  m_out_h << "typedef struct I" << &m_name[0] << " I" << &m_name[0] << ";"  << endl; /* PTS XXXXXX */
  m_out_h << "#endif  /* __I" << &m_name[0] << "_FWD_DEFINED__ */"             << endl;
  m_out_h                                                                      << endl;
  m_out_h << "#ifndef __" << &m_name[0] << "_FWD_DEFINED__"                    << endl;
  m_out_h << "#define __" << &m_name[0] << "_FWD_DEFINED__"                    << endl;
  m_out_h                                                  << endl;
  m_out_h << "#ifdef __cplusplus"                          << endl;
  m_out_h << "typedef class " << &m_name[0] << " " << &m_name[0] << ";"  << endl;
  m_out_h << "#else"                                       << endl;
  m_out_h << "typedef struct " << &m_name[0] << " " << &m_name[0] << ";" << endl;
  m_out_h << "#endif   /* __cplusplus */"                  << endl;
  m_out_h                                                  << endl;
  m_out_h << "#endif /* __" << &m_name[0] << "_FWD_DEFINED__ */" << endl;

  m_out_c << "#ifdef __cplusplus" << endl;
  m_out_c << "extern \"C\"{" << endl;
  m_out_c << "#endif" << endl << endl;

  m_out_c << "#ifndef __IID_DEFINED__" << endl;
  m_out_c << "#define __IID_DEFINED__" << endl;
  m_out_c << "typedef struct _IID" << endl;
  m_out_c << "{" << endl;
  m_out_c << "    unsigned long x;" << endl;
  m_out_c << "    unsigned short s1;" << endl;
  m_out_c << "    unsigned short s2;" << endl;
  m_out_c << "    unsigned char  c[8];" << endl;
  m_out_c << "} IID;" << endl;
  m_out_c << "#endif // __IID_DEFINED__" << endl << endl;

  m_out_c << "#ifndef CLSID_DEFINED" << endl;
  m_out_c << "#define CLSID_DEFINED" << endl;
  m_out_c << "typedef IID CLSID;" << endl;
  m_out_c << "#endif // CLSID_DEFINED" << endl << endl;

  return 1;
};

/*----------------------------------------------------------------------*/

void IspcCGenHFile::startElement(const char *name, const char **atts) {
  char lbuf[256];
  char lbuf2[256];
  if ( !m_is_within_import || ( elemImport_ispc == ispc_getElementType(name) ) ) {
    switch (ispc_getElementType(name)) {
    case elemLibrary_ispc:
      if ( attName_ispc == ispc_getAttributeType(atts[0]) ) {
        strcpy(&m_libname[0],atts[1]);
        m_out_h                                                  << endl;
        m_out_h  << "#ifndef __" << &m_libname[0] << "_LIBRARY_DEFINED__" << endl;
        m_out_h  << "#define __" << &m_libname[0] << "_LIBRARY_DEFINED__" << endl;
      }
      break;
    case elemCpp_ispc:
      if ( attString_ispc == ispc_getAttributeType(atts[0]) ) {
        /* +++++ PTS 1109570 +++++ */
        const char* pc1 = atts[1];
        char* pc2 = (char*)strchr( pc1, '\\' );
        
        lbuf[0] = '\0';
        while ( pc2 )
        {
          pc2++;
          if ( *pc2 == '\\' ) {
            *pc2 = '\0';
            strcat( lbuf, pc1 );
            pc1 = ++pc2;
          }
          pc2 = (char*)strchr( pc2, '\\' );
        }
        strcat( lbuf, pc1 );
        /* ----- PTS 1109570 ----- */
        /* strcat( lbuf, atts[1] );  PTS 1109570 */
        m_out_h  << lbuf << endl;
      }
      break;
    case elemPragma_ispc:
      if ( attPack_ispc == ispc_getAttributeType(atts[0])) {
        strcpy(lbuf,atts[1]);
        m_out_h  << endl << "#pragma pack(" << lbuf << ")" << endl;
      }
      break;
    case elemImport_ispc:
      if ( 0 == m_is_within_import ) {
        strcpy(lbuf,atts[1]);
        char* pc = strrchr(lbuf,'.');
        if ( pc ) {
          *pc = '\0';
          strcat(lbuf,".h");
        }
        m_out_h  << endl << "#include \"" << lbuf << "\"  /* no check */" << endl; /* PTS 1112974 */
      }
      m_is_within_import++;
      break;
    case elemConst_ispc:
      if ( attName_ispc == ispc_getAttributeType(atts[0]) ) {
        strcpy(lbuf,atts[1]);

        /* +++++ PTS 1109570 +++++ */
        const char* pc1 = atts[1];
        char* pc2 = (char*)strchr( pc1, '\\' );
        pc1 = atts[5];
        pc2 = (char*)strchr( pc1, '\"' );        
        lbuf2[0] = '\0';
        while ( pc2 && *(pc2+1) )
        {
          *pc2 = '\0';
          strcat( lbuf2, pc1 );
          strcat( lbuf2, "\\\"" );
          pc2++;
          pc1 = pc2;
          pc2 = (char*)strchr( pc1, '\"' );
        }
        strcat( lbuf2, pc1 );
        /* ----- PTS 1109570 ----- */
        /*strcpy(lbuf2,atts[5]); PTS 1109570 */
        if ( attString_ispc == ispc_getAttributeType(atts[4]))
          m_out_h << endl << "#define " << lbuf << " ( \"" << lbuf2 << "\" )" << endl;
        else
          m_out_h << endl << "#define " << lbuf << " ( " << lbuf2 << " )" << endl;
      }
      break;
    case elemTypedef_ispc:
      {
        const char *name_idx = "";
        const char *type_idx = "";
        const char *dim_idx  = "";
        
        for ( int i = 0; atts[i]; i=i+2) {
          XmlAttributeType_Enum_ispc attrtype = ispc_getAttributeType(atts[i]);
          switch ( attrtype ) {
          case attName_ispc: 
            name_idx = atts[i+1]; break;
          case attType_ispc:
            type_idx = atts[i+1]; break;
          case attDimension_ispc:
            dim_idx  = atts[i+1]; break;
          case attUuid_ispc:
          case attString_ispc:
          case attNumber_ispc:
          case attChar_ispc:
          case attPack_ispc:
          case attDirection_ispc:
          case attUnknown_ispc:
          default:
            break;
          }
        }            
        m_out_h << endl << "typedef " << type_idx << " " << name_idx;
        if ( strlen(dim_idx) > 0 )
          m_out_h << "[ " << dim_idx << " ]";
        m_out_h << ";" << endl;
      }
      break;
    case elemStruct_ispc:
      m_is_within_struct++;
      if ( attName_ispc == ispc_getAttributeType(atts[0]) ) {
        strcpy(&m_structname[0],atts[1]);
        m_out_h << endl << "typedef struct " << &m_structname[0] << " { " << endl;
      }
      break;
    case elemMember_ispc:
      if ( m_is_within_struct ){
        if ( attType_ispc == ispc_getAttributeType(atts[2])) {
          strcpy(lbuf,atts[3]);
          strcpy(lbuf2,atts[1]);
          m_out_h  << "   " << lbuf << " " << lbuf2;
          if ( atts[4] && ( attDimension_ispc == ispc_getAttributeType(atts[4]))) {
            strcpy(lbuf,atts[5]);
            m_out_h  << "[ " << lbuf << " ]";
          }
          m_out_h  << ";" << endl;
        }
      };
      
      break;
    case elemEnum_ispc:
      break;
    case elemInclude_ispc:
      m_is_within_include++;
      break;
    case elemInterface_ispc:
      if ( attName_ispc == ispc_getAttributeType(atts[0]) ) {
        strcpy(&m_interfacename[0],atts[1]);
        
        const char *pc = atts[3];
        int i = 0;
        for ( ; *pc != '\0'; pc++ ) {
          if ( *pc != ' ' ) {
            m_iid[i] = *pc;
            i++;
          }
        }
        m_iid[i] = 0;

        //strcpy(&m_iid[0],atts[3]);
        m_out_h  << endl << "#ifndef __" << &m_interfacename[0] << "_INTERFACE_DEFINED__" << endl;
        m_out_h  << "#define __" << &m_interfacename[0] << "_INTERFACE_DEFINED__" << endl;
        m_out_h  << endl << "EXTERN_C const IID IID_" << &m_interfacename[0] << ";" << endl;
        m_out_h  << endl << "MIDL_INTERFACE(\"" << &m_iid[0] << "\")" << endl;
        m_out_h  << &m_interfacename[0] << " : public IUnknown {" << endl;
        m_out_h  << "public:" << endl << endl;
        m_out_c << "const IID IID_" << &m_interfacename[0] << " = {0x";

        for ( i=0; i < 8; i++ )  
          m_out_c  << m_iid[i];
        m_out_c  << ", 0x";
        for ( i=9; i < 13; i++ )  
          m_out_c  << m_iid[i];
        m_out_c  << ", 0x";
        for ( i=14; i < 18; i++ )  
          m_out_c  << m_iid[i];
        m_out_c  << ", {";
        for ( i=19; i < 23; i=i+2 )  
          m_out_c  << "0x" << m_iid[i] << m_iid[i+1] << ", ";
        for ( i=24; i < 34; i=i+2 )  
          m_out_c  << "0x" << m_iid[i] << m_iid[i+1] << ", ";
        m_out_c  << "0x" << m_iid[34] << m_iid[35] << "}};" << endl << endl;

      }
      break;
    case elemIdl_ispc:
      m_methode_param = 0;
      if ( attName_ispc == ispc_getAttributeType(atts[0]) ) {
        strcpy(lbuf,atts[1]);
        m_out_h  << endl << "    virtual HRESULT STDMETHODCALLTYPE " << lbuf << "(";
        break;
    case elemParam_ispc:
      {
        const char * name_idx = "";
        const char * type_idx = "";
        const char * direction_idx = "";
        unsigned int i;

        for ( i = 0; atts[i]; i=i+2) {
          XmlAttributeType_Enum_ispc attrtype = ispc_getAttributeType(atts[i]);
          switch ( attrtype ) {
          case attName_ispc: 
            name_idx = atts[i+1]; break;
          case attType_ispc:
            type_idx = atts[i+1]; break;
          case attDimension_ispc:
          case attString_ispc:
          case attNumber_ispc:
          case attChar_ispc:
          case attPack_ispc:
          case attDirection_ispc:
            direction_idx = atts[i+1]; break;
          case attUnknown_ispc:
          default:
            break;
          }
        }      
        
        if ( m_methode_param ) m_out_h << ",";
        m_methode_param++;
        m_out_h  << endl;
        strcpy(lbuf,type_idx);
        if ( !strcmp("bool",lbuf) ||
          !strcmp("bool*",lbuf)) {
          for (i = 0; i < strlen(lbuf); i++) lbuf[i] = toupper( lbuf[i] );         
        }

        if ( !strcmp("char",lbuf) ||
          !strcmp("char*",lbuf)) {
#if defined(_WIN32)
          m_out_h  << "      /* " << direction_idx << " */ unsigned " << lbuf  << " " << name_idx ;
#else
          m_out_h  << "      /* " << direction_idx << " */ signed " << lbuf  << " " << name_idx ;
#endif
        }
        else
          m_out_h  << "      /* " << direction_idx << " */ " << lbuf  << " " << name_idx ;
      }
      break;
    case elemCoClass_ispc:
      int i;
      m_out_h  << "};" << endl;
      m_out_h  << "#endif /* __" << &m_interfacename[0] << "_INTERFACE_DEFINED__ */" << endl;

      if ( attName_ispc == ispc_getAttributeType(atts[0]) ) {
        strcpy(lbuf,atts[1]);
      };
      if (attUuid_ispc == ispc_getAttributeType(atts[2])) {
        const char *pcAtts = atts[3];
        i = 0;
        for ( ; *pcAtts != '\0'; pcAtts++ ) {
          if ( *pcAtts != ' ' ) {
            lbuf2[i] = *pcAtts;
            i++;
          }
        }
        lbuf2[i] = 0;
      };
      m_out_h  << endl << "EXTERN_C const CLSID CLSID_" << lbuf << ";" << endl;
      m_out_h  << "class DECLSPEC_UUID(\"" << lbuf2 << "\") " << lbuf << ";" << endl;
      
      m_out_c << "const CLSID CLSID_" << lbuf << " = {0x";
      for ( i=0; i < 8; i++ )  
        m_out_c  << lbuf2[i];
      m_out_c  << ", 0x";
      for ( i=9; i < 13; i++ )  
        m_out_c  << lbuf2[i];
      m_out_c  << ", 0x";
      for ( i=14; i < 18; i++ )  
        m_out_c  << lbuf2[i];
      m_out_c  << ", {";
      for ( i=19; i < 23; i=i+2 )  
        m_out_c  << "0x" << lbuf2[i] << lbuf2[i+1] << ", ";
      for ( i=24; i < 34; i=i+2 )  
        m_out_c  << "0x" << lbuf2[i] << lbuf2[i+1] << ", ";
      m_out_c  << "0x" << lbuf2[34] << lbuf2[35] << "}};" << endl << endl;

      break;
    case elemUnknown_ispc:
      break;
    default:
      break;
      }
    }
  }
};

/*----------------------------------------------------------------------*/

void IspcCGenHFile::endElement(const char *name) {
  if ( m_is_within_import ) {
    switch (ispc_getElementType(name)) {
    case elemImport_ispc:
      m_is_within_import--;
      break;
    default:
      break;
    }
  }
  else
  {
    switch (ispc_getElementType(name)) {
    case elemIdl2Xml_ispc:
      m_out_h  << "#endif" << endl;
      m_out_c << "#ifdef __cplusplus" << endl;
      m_out_c << "}" << endl;
      m_out_c << "#endif" << endl;
      break;
    case elemLibrary_ispc:
      m_out_h  << endl << "#endif /* __" << &m_libname[0] << "_LIBRARY_DEFINED__ */" << endl;
      break;
    case elemCpp_ispc:
      break;
    case elemPragma_ispc:
      break;
    case elemInclude_ispc:
      m_is_within_include--;
      break;
    case elemConst_ispc:
      break;
    case elemTypedef_ispc:
      break;
    case elemStruct_ispc:
      m_is_within_struct--;
      m_out_h << "} " << &m_structname[0] << ";" << endl;
      break;
    case elemMember_ispc:
      break;
    case elemEnum_ispc:
      break;
    case elemInterface_ispc:
      break;
    case elemIdl_ispc:
       m_out_h  << "   ) = 0;" << endl;
       break;
    case elemCoClass_ispc:
      break;
    case elemUnknown_ispc:
      break;
    default:
      break;
    }
  }
}
