#!/usr/bin/perl

# 2002-10-31: Version 0.1 by d038447
# (c) SAP AG

#####################################################################
# use-Area
#####################################################################
BEGIN {
	push(@INC, "/devtool/local/bin");
	push(@INC, "/devtool/TOOL/tool/bin");
}
use Sys::Hostname;
use Net::SMTP;
#####################################################################

$ENV{'P4PORT'}	= 'perforce3006:3006';
$ENV{'PATH'}	= $ENV{'PATH'} . ":/usr/local/bin";

$hostname = hostname();
$mailtext = "";
$highPri  = 0;
if ($hostname eq "us0062") {
	$ENV{'P4CLIENT'} = 'WDFTEST';
}
elsif ($hostname eq "ds0116") {
	$ENV{'P4CLIENT'} = 'WDFTEST-DS0116';
}
elsif ($hostname eq "is0025") {
	$ENV{'P4CLIENT'} = 'WDFTEST-IS0025';
} 
elsif ($hostname eq "is0026") {
	$ENV{'P4CLIENT'} = 'WDFTEST-IS0026';
}
elsif ($hostname eq "hs0102") {
	$ENV{'P4CLIENT'} = 'WDFTEST-HS0102';
}
else {
	print "The host $conf{'hostname'} ist not known in the configuration\n(See sub getdep!)\n";
	exit(1);
}

&doCmd("p4 sync //sapdb/TOOLSRC/develop/sys/src/QATools/tests/* ");
&doCmd("rm -f /SAP_DB/TESTDB/testdb.p?");
&doCmd("rm -f /SAP_DB/TESTDB/tp2.pl");
&doCmd("cp /SAP_DB/TESTDB/tests/testdb.p? /SAP_DB/TESTDB/tests/tp2.pl /SAP_DB/TESTDB");
&doCmd("perl -c /SAP_DB/TESTDB/testdb.pl");
&doCmd("perl -c /SAP_DB/TESTDB/testdb.pm");
&doCmd("perl -c /SAP_DB/TESTDB/tp2.pl");

$smtp = Net::SMTP->new("mail.sap-ag.de");

$smtp->mail("remuser\@${hostname}.wdf.sap-ag.de");
$smtp->to("falko.flessner\@sap.com");
$smtp->data();
$smtp->datasend("To: falko.flessner\@sap.com\n");
$smtp->datasend("Subject: getCtrl-Run on ${hostname} \n");
if ($highPri == 1) {
	$smtp->datasend("Priority: Urgent\nX-Priority: 1 (Highest)\n");
}
$smtp->datasend("\n");
$smtp->datasend($mailtext);
$smtp->dataend();
$smtp->quit;

sub doCmd {
	$cmd = pop (@_);
	open (CMDOUT, "$cmd |");

	@cmdoutput = <CMDOUT>;
	close (CMDOUT);
	
	$retval = ($? >> 8);
	
	if ($retval != 0) {
		$highPri = 1;
	}
	
	$mailtext .= "########################################\n$cmd \n";
	$mailtext .= "Return-Value = $retval \n";
	foreach $x (@cmdoutput) {
		chomp $x;
		$mailtext .= ($x . "\n");
	}
}



