
# updSniffProjects.py
#
#    ========== licence begin LGPL
#    Copyright (C) 2001 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#

import os

import perforce.perforceLib
import perforce.ChangeList
import sniff.ProjectTree

def getChangeListComment ():
    mainComment = 'updated Sniff projects'
    try:
        relver = os.environ ['RELVER']
        if relver [0] == 'R':
            relver = 'V' + relver [1:]
        result = relver + ': ' + mainComment
    except KeyError:
        result = mainComment
    return result


def updateSniffProjects (options, args):
    #
    # create changelist
    #
    p4options = options2p4 (options)
    if options.changelist:
        changeList = perforce.ChangeList.ChangeList (options.changelist, p4options)
    else:
        description = getChangeListComment ()
        changeList = perforce.ChangeList.newChangeList (description, p4options)
    p4exec = changeList.session.execute
    #
    # sync and open for edit
    #
    pathArgs = ' '
    for arg in args:
        pathArgs = pathArgs + (arg + '/....proj ')
    p4exec ('revert ' + pathArgs)
    p4exec ('sync ' + pathArgs)
    p4exec ('edit -c %s %s' % (changeList.id, pathArgs))
    #
    # run update
    #
    projectTree = sniff.ProjectTree.SniffProjectTree ()
    projectTree.updateTree (args, options)
    changeList.session.executeFileList ('add -c %s '% changeList.id,
        projectTree.filesAdded)
    changeList.session.executeFileList ('revert ',
        projectTree.filesUnchanged)
    #
    # revert unchanged files
    #
    pass # not implemented
    #
    # auto submit
    #
    pass # not implemented
    #
    #
    #
    return changeList.id

def options2p4 (options):
    return perforce.perforceLib.ConnectOptions (
        options.client,
        options.host,
        options.port,
        options.password,
        options.user)


def main (options, args):
    """updates Sniff projects in directory tree

    Projects are updated by adding all files in a directory
    to the projects FileSet

    """
    if len (args) == 0:
        doc  = os.environ ['OWN'] + '/sys/doc'
        src  = os.environ ['SRC']
        desc = os.environ ['DESC'] 
        for dir in [desc, doc, src]:
            if os.path.isdir (dir):
                args.append (dir)
    id = updateSniffProjects (options, args)
    print 'Changelist id:', id

def _options ():
    return [
        # (optstring, varname, typechar, default, help)
        ('forceNew', None, '', 1, 'overwrite projects with current template'),
        ('v', 'verbose', '', None, 'verbose output'),
        ('changelist', None, ':', None, 'use specific change list'),
        ('c', 'client', ':', None, 'p4 client name'),
        ('H', 'host', ':', None, 'p4 host name'),
        ('p', 'port', ':', None, 'p4 port'),
        ('P', 'password', ':', None, 'p4 password'),
        ('u', 'user', ':', None, 'p4 user'),
        ]

if __name__ == '__main__':
    import optlib
    optlib.optMain2 (main, _options ())
