#! /usr/bin/perl
#
# $Header: //sapdb/TOOLSRC/develop/sys/src/BuildPackage/Hosts.pm#6 $
# $DateTime: 2002/10/22 12:11:30 $
# $Change: 29346 $
#
# Desc:	- define vars for plattform specific vars
#		
#
#
#    ========== licence begin LGPL
#    Copyright (C) 2002 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#
 
		
package BuildPackage::Hosts;

use Exporter;
use BuildPackage::Vars;

@ISA = ('Exporter');

@EXPORT = ('$CUR_OS','%HOSTS','%OSS');

$CUR_OS;

if($OS eq 'win'){
	$CUR_OS = ($ARCH eq 'ia64' ? 'WIN64' : 'WIN32');
}
elsif($OS eq 'linux'){
	$CUR_OS = ($ARCH eq 'ia64' ? 'LINUX64' : 'LINUX32');
}
elsif($OS eq 'tru64'){
	$CUR_OS = 'DEC64';
}
elsif($OS eq 'hpux'){
	if($ARCH eq 'ia64'){
		$CUR_OS = 'HPIA64';
	}
	else{
		$CUR_OS = (exists $ENV{'BIT64'} ? 'HP64' : 'HP32');
	}
}
elsif($OS eq 'sun'){
	$CUR_OS = (exists $ENV{'BIT64'} ? 'SUN64' : 'SUN32');
}
elsif($OS eq 'aix'){
	$CUR_OS = (exists $ENV{'BIT64'} ? 'AIX64' : 'AIX32');
}
elsif($OS eq 'aix5'){
	$CUR_OS = 'AIX564';
}
elsif($OS eq 'reliant'){
	$CUR_OS = (exists $ENV{'BIT64'} ? 'RELIANT64' : 'RELIANT32');
}
else{
	print STDERR "unknown os\n";
	exit -1;
}


%OSS = (
	'WIN32' => {'name' => 'win','arch' => 'i386','bit' => '32'},
	'WIN64' => {'name' => 'win','arch' => 'ia64','bit' => '64'},				
	'AIX32' => {'name' => 'aix','arch' => 'ppc','bit' => '32'},
	'AIX64' => {'name' => 'aix','arch' => 'ppc','bit' => '64'},
	'AIX564' => {'name' => 'aix5','arch' => 'ppc','bit' => '64'},
	'DEC64' => {'name' => 'tru64','arch' => 'alpha','bit' => '64'},
	'HP32' => {'name' => 'hpux','arch' => 'hppa','bit' => '32'},
	'HP64' => {'name' => 'hpux','arch' => 'hppa','bit' => '64'},
	'HPIA64' => {'name' => 'hpux','arch' => 'ia64','bit' => '64'},
	'SUN32' => {'name' => 'sun','arch' => 'sparc','bit' => '32'},
	'SUN64' => {'name' => 'sun','arch' => 'sparc','bit' => '64'},
	'LINUX32' => {'name' => 'linux','arch' => 'i386','bit' => '32'},
	'LINUX64' => {'name' => 'linux','arch' => 'ia64','bit' => '64'}		

);


%HOSTS = (
	'7402' => {
					'WIN32' => {'name' => 'ls8801.bea.sap.corp'},
					'WIN64' => {'name' => 'ls8801.bea.sap.corp'},				
					'AIX32' => {'name' => 'is0134.wdf.sap.corp'},
					'AIX64' => {'name' => 'is0134.wdf.sap.corp'},
					'AIX564' => {'name' => 'is0135.wdf.sap.corp'},
					'DEC64' => {'name' => 'ds0117.wdf.sap.corp'},
					'HP32' => {'name' => 'hs0109.wdf.sap.corp'},
					'HP64' => {'name' => 'hs0109.wdf.sap.corp'},
					'SUN32' => {'name' => 'us0103.wdf.sap.corp'},
					'SUN64' => {'name' => 'us0103.wdf.sap.corp'},
					'LINUX32' => {'name' => 'ls0106.wdf.sap.corp'}
						
				},
	'7403' => {
					'WIN32' => {'name' => 'ls8801.bea.sap.corp'},
					'WIN64' => {'name' => 'ls8801.bea.sap.corp'},				
					'AIX32' => {'name' => 'is0136.wdf.sap.corp'},
					'AIX564' => {'name' => 'is0136.wdf.sap.corp'},
					'DEC64' => {'name' => 'ds0123.wdf.sap.corp'},
					'HP32' => {'name' => 'hs0113.wdf.sap.corp'},
					'HP64' => {'name' => 'hs0113.wdf.sap.corp'},
					'HPIA64' => {'name' => 'hs0115.wdf.sap.corp'},
					'SUN32' => {'name' => 'us0104.wdf.sap.corp'},
					'SUN64' => {'name' => 'us0104.wdf.sap.corp'},
					'LINUX32' => {'name' => 'ls0106.wdf.sap.corp'},
					'LINUX64' => {'name' => 'ls0109.wdf.sap.corp'}
	},
	'7404' => {
					'WIN32' => {'name' => 'ls8801.bea.sap.corp'},
					'WIN64' => {'name' => 'ls8801.bea.sap.corp'},				
					'AIX32' => {'name' => 'is0138.wdf.sap.corp'},
					'AIX564' => {'name' => 'is0138.wdf.sap.corp'},
					'DEC64' => {'name' => 'ds0123.wdf.sap.corp'},
					'HP32' => {'name' => 'hs0113.wdf.sap.corp'},
					'HP64' => {'name' => 'hs0113.wdf.sap.corp'},
					'HPIA64' => {'name' => 'hs0115.wdf.sap.corp'},
					'SUN32' => {'name' => 'us0106.wdf.sap.corp'},
					'SUN64' => {'name' => 'us0106.wdf.sap.corp'},
					'LINUX32' => {'name' => 'ls0106.wdf.sap.corp'},
					'LINUX64' => {'name' => 'ls0109.wdf.sap.corp'}	
	},
	'7500' => {
					'WIN32' => {'name' => 'ls8801.bea.sap.corp'},
					'WIN64' => {'name' => 'ls8801.bea.sap.corp'},				
					'AIX32' => {'name' => 'is0138.wdf.sap.corp'},
					'AIX564' => {'name' => 'is0138.wdf.sap.corp'},
					'DEC64' => {'name' => 'ds0123.wdf.sap.corp'},
					'HP32' => {'name' => 'hs0113.wdf.sap.corp'},
					'HP64' => {'name' => 'hs0113.wdf.sap.corp'},
					'HPIA64' => {'name' => 'hs0115.wdf.sap.corp'},
					'SUN32' => {'name' => 'us0106.wdf.sap.corp'},
					'SUN64' => {'name' => 'us0106.wdf.sap.corp'},
					'LINUX32' => {'name' => 'ls0106.wdf.sap.corp'},
					'LINUX64' => {'name' => 'ls0109.wdf.sap.corp'}	
	},
	'7600' => {
					'WIN32' => {'name' => 'ls8801.bea.sap.corp'},
					'WIN64' => {'name' => 'ls8801.bea.sap.corp'},				
					'AIX32' => {'name' => 'is0138.wdf.sap.corp'},
					'AIX564' => {'name' => 'is0138.wdf.sap.corp'},
					'DEC64' => {'name' => 'ds0123.wdf.sap.corp'},
					'HP32' => {'name' => 'hs0113.wdf.sap.corp'},
					'HP64' => {'name' => 'hs0113.wdf.sap.corp'},
					'HPIA64' => {'name' => 'hs0115.wdf.sap.corp'},
					'SUN32' => {'name' => 'us0106.wdf.sap.corp'},
					'SUN64' => {'name' => 'us0106.wdf.sap.corp'},
					'LINUX32' => {'name' => 'ls0106.wdf.sap.corp'},
					'LINUX64' => {'name' => 'ls0109.wdf.sap.corp'}	
	}

);




1;

