/* module:        hcn80.h
 * ==================================================================
 *
 * responsible:   Martin Reinecke (D024853 - Martin.Reinecke@SAP-AG.de)
 *
 * created:       1998-03-19 by Martin Reinecke
 *
 * release :      6.2.8
 *
 * purpose:       utility connect/execute/release
 *
 * copyright:     (c) 1998-2004 SAP AG
 *
 * last changed:  1998-03-20  - Martin Reinecke
 *                              Utility Connect/Execute/Release
 *                1998-04-21  - Bernd Vorsprach 
 *                              SQLConnect/Execute/Info/Fetch/Release
 * ==================================================================

    ========== licence begin  GPL
    Copyright (c) 1998-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



 * ==================================================================
 */

#ifndef _HCN80_H_
#define _HCN80_H_

/* IMPORT
 * ------------------------------------------------------------------
 */
#include "gcn00.h"
#include "hcn50.h"
#include "hin29.h"


/* SPECIFICATION PUBLIC MACROS
 * ------------------------------------------------------------------
 */

// important utility commands
#define DB_DISABLE_LOG_CN80      "SET LOG WRITER OFF"
#define DB_ENABLE_LOG_CN80       "SET LOG WRITER ON"
#define DB_MIGRATE_CATALOG_CN80  "MIGRATE TO UNICODE"
#define DB_INIT_CN80             "INIT CONFIG"
#define DB_CREATE_CN80           "CREATE INSTANCE SYSDBA %s PASSWORD %s"
 
/* SPECIFICATION PUBLIC FUNCTIONS
 * ------------------------------------------------------------------
 */
tcn00_Error cn80UtilConnect (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

tcn00_Error cn80UtilExecute (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

tcn00_Error cn80UtilGetPage (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

tcn00_Error cn80UtilPutPage (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

tcn00_Error cn80UtilRelease (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

tcn00_Error cn80DBActivate (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

tcn00_Error cn80DBActivateRequest (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

tcn00_Error cn80ServiceConnect (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

tcn00_Error cn80ServiceRelease (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

tcn00_Error cn80SQLUserConnect (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

tcn00_Error cn80SQLUserExecute (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

tcn00_Error cn80SQLUserInfo (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

tcn00_Error cn80SQLUserFetch (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

tcn00_Error cn80SQLUserRelease (
      VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax );

/* SPECIFICATION INTERNAL FUNCTIONS
 * ------------------------------------------------------------------
 */
tcn00_Error cn80UtilSession (
      VControlDataT     *  vcontrol,
      char              *  replyData,
      int               *  replyLen,
      tin01_sql_session ** pUtilSession );

tcn00_Error cn80ServiceSession (
      VControlDataT     *  vcontrol,
      char              *  replyData,
      int               *  replyLen,
      tin01_sql_session ** pSQLUserSession );

tcn00_Error cn80SQLUserSession (
      VControlDataT     *  vcontrol,
      char              *  replyData,
      int               *  replyLen,
      tin01_sql_session ** pSQLUserSession );

void cn80FreeUtilSession(
      VControlDataT     * vcontrol);

void cn80FreeServiceSession(
      VControlDataT     * vcontrol);

void cn80FreeSQLUserSession(
      VControlDataT     * vcontrol);


tcn00_Error cn80ExecuteSQL  ( const tsp00_DbNamec   szDBName,
                              const _TCHAR        * szStatement);
tcn00_Error cn80ExecuteSQL  ( const tsp00_DbNamec   szDBName,
                              const _TCHAR        * szStatement,
                              _TCHAR              * replyData,
                              int                   replyLenMax,
                              int                 & replyLen );
tcn00_Error cn80ExecuteSQL  ( const cn50DBMUser   & aUser,
                              const _TCHAR        * szStatement);
tcn00_Error cn80ExecuteSQL  ( const cn50DBMUser   & aUser,
                              const _TCHAR        * szStatement,
                              _TCHAR              * replyData,
                              int                   replyLenMax,
                              int                 & replyLen );
tcn00_Error cn80ExecuteSQL  ( tin01_sql_session   * pSQLSession,
                              const _TCHAR        * szStatement,
                              _TCHAR              * replyData,
                              int                   replyLenMax,
                              int                 & replyLen );
tcn00_Error cn80ConnectSQL  ( const tsp00_DbNamec   szDBName,
                              tin01_sql_session   * pUtilSession,
                              _TCHAR              * replyData       = NULL,
                              int                 * replyLen        = NULL,
                              int                   nUserType       = FIRSTDBM_CN50);
tcn00_Error cn80ConnectSQL  ( const cn50DBMUser   & aUser,
                              tin01_sql_session   * pUtilSession,
                              _TCHAR              * replyData       = NULL,
                              int                 * replyLen        = NULL );
tcn00_Error cn80ConnectSQL  ( const tsp00_DbNamec   szDBName,
                              const cn50DBMUser   & aUser,
                              tin01_sql_session   * pUtilSession,
                              _TCHAR              * replyData       = NULL,
                              int                 * replyLen        = NULL );
tcn00_Error cn80ConnectSQL(
                const char        * dbName,
                const char        * userName,
                const char        * userPassword,
                tin01_sql_session * sqlSession);

void        cn80ReleaseSQL  ( tin01_sql_session   * pSQLSession,
                              bool                  bWithCommit     = true);

tcn00_Error cn80ExecuteUtil ( const tsp00_DbNamec   szDBName,
                              const _TCHAR        * szStatement,
                              _TCHAR              * replyData       = NULL,
                              int                 * replyLen        = NULL );

tcn00_Error cn80ExecuteUtil ( tin01_sql_session   * pUtilSession,
                              const _TCHAR        * szStatement,
                              _TCHAR              * replyData       = NULL,
                              int                 * replyLen        = NULL );

tcn00_Error cn80ConnectUtil ( const tsp00_DbNamec   szDBName,
                              tin01_sql_session   * pUtilSession,
                              _TCHAR              * replyData       = NULL,
                              int                 * replyLen        = NULL );

void        cn80ReleaseUtil ( tin01_sql_session   * pUtilSession,
                              bool                  bWithCommit     = true);

/* PUBLIC FUNCTION cn80_CheckVerify
 * ------------------------------------------------------------------
 * purpose: check for VERIFY
 *
 */
bool cn80CheckVerify (
      const char * szStatement, const char * & pAction);


#endif /* _HCN80_H_ */

