/****************************************************************************

  module      : WDVHandler_Explorer.c

  -------------------------------------------------------------------------

  responsible : Daniel Kirmse

  special area:
  description :


  last changed: 2001-02-28  10:41
  see also    :

  -------------------------------------------------------------------------


    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*****************************************************************************/

	#include "SAPDB/WebDAV/Handler/WDVHandler_Explorer.h"
	#include "hwd21req.h"
	#include "SAPDBCommon/SAPDB_string.h"

	#define  WDVH_DELETED_ITEMS_FOLDER		"/Deleted Items"
	#define  WDVH_DELETED_ITEMS_FOLDER_ESC	"/Deleted%20Items"

	/*------------------------------------------------------------------------
		Function: doServiceExplorer
	--------------------------------------------------------------------------*/
	void doServiceExplorer(sapdbwa_Handle wa, sapdbwa_HttpRequestP req, sapdbwa_HttpReplyP rep,WDVCAPI_WDV pCapiHandle, WDVH_Handle wdvhHandle, XMLIMAPI_Handle xmlHandle)
	{
		WDVH_Char				requestURI[WDVH_MAX_URI_LEN+1];
		WDVH_Int2				statuscode;
		WDVCAPI_PropfindHandle  propfind=NULL;
		WDVH_Char				*host;
		WDVH_Char				*port;
		WDVH_Char				*server;
		WDVH_Char				__command[100];
		WDVH_Char				__location[WDVH_MAX_URI_LEN+1];
		WDVH_Char				__resource[WDVH_MAX_URI_LEN+1];
		WDVH_Char				__destination[WDVH_MAX_URI_LEN+1];
		WDVH_Char				__docclass[129];
		WDVH_Char				*__pDocClass;
		WDVH_Char				__docclassold[129];
		WDVCAPI_Overwrite		__overwrite;
		WDVH_Char				__reindex[3];
		WDVCAPI_ErrorItem		__errorItem;
		WDVCAPI_ErrorType		__errorType;
		WDVCAPI_ErrorCode		__errorCode;
		WDVCAPI_ErrorText		__errorMsg;
		WDVH_Error				__error;
		WDVH_Char				__errorText[1000];
		WDVH_Char				__locktoken[100];
		WDVCAPI_LockHandle		__lock;
		WDVH_CapiUserData		__capiUserData;
		WDVCAPI_LockIdList		__lockTokenList;
        WDVCAPI_LockId          nullLockId;

        WDVCAPI_IdInitValue(nullLockId);

		getParameterValue("cmd",req,__command);
		getParameterValue("location",req,__location);
		WDVH_UnEscapeUri(__location);
		getParameterValue("res",req,__resource);
		WDVH_UnEscapeUri(__resource);
		getRequestUriFromString(wa,req,__resource);
		if (strcmp(__command,"Del")==0) {
			/* extract Parameters (Host, RequestURI)*/
			getFirstHeaderLine(wa,req,&host,&port,requestURI);
			/* delete the given resource */
			statuscode = deleteCallCapiFunc(wa,pCapiHandle,req,__resource,nullLockId,WDVH_True);
			if (statuscode==204) {
				/* just show the "new" collection */
				statuscode = getCallCapiFunc(wa,req,pCapiHandle,__location,"",-1,-1);
				getBuildReply(wa,statuscode,req,rep,pCapiHandle,wdvhHandle,host,port,__location,-1,-1);
			} else {
				deleteBuildReply(statuscode, rep);
			}
		} else if (strcmp(__command,"Discard")==0) {
			/* extract Parameters (Host, RequestURI)*/
			getFirstHeaderLine(wa,req,&host,&port,requestURI);
			/* delete the given resource */
			statuscode = deleteCallCapiFunc(wa,pCapiHandle,req,__resource,nullLockId,WDVH_False);
			if (statuscode==204) {
				/* just show the "new" collection */
				statuscode = getCallCapiFunc(wa,req,pCapiHandle,__location,"",-1,-1);
				getBuildReply(wa,statuscode,req,rep,pCapiHandle,wdvhHandle,host,port,__location,-1,-1);
			} else {
				deleteBuildReply(statuscode, rep);
			}
		} else if (strcmp(__command,"RestoreScreen")==0) {
			/* extract Parameters (Host, RequestURI)*/
			getFirstHeaderLine(wa,req,&host,&port,requestURI);
			/* build Reply */
			restoreScreen(wa,req,rep,__resource,__location,pCapiHandle,WDVH_False,"");
		} else if (strcmp(__command,"Restore")==0) {
			/* extract Parameters (Host, RequestURI)*/
			getFirstHeaderLine(wa,req,&host,&port,requestURI);
			if (getParameterValue("Overwrite",req,__destination))
				__overwrite = WDVCAPI_DELETE_BEFORE_OVERWRITE;	/* no merge!!! */
			else
				__overwrite = WDVCAPI_NO_OVERWRITE;
			getParameterValue("DestinationURI",req,__destination);
			/* get server string for error messages */
			buildServerString(req,&server);
			/* -If header (lock tokens) */
			if (!WDVCAPI_LockCreateIdList(pCapiHandle,&__lockTokenList)) {
				__lockTokenList = NULL;
			}
			/* - CapiUserData for call back */
			createCapiUserData(&__capiUserData);
			__capiUserData->reply = rep;
			__capiUserData->server = server;
			/* call CAPI function*/
			statuscode = moveCallCapiFunc(wa,req,pCapiHandle,__resource,__destination,WDVCAPI_DEPTH_INFINITE,__overwrite,__capiUserData,__lockTokenList);
			/* build Reply */
			if (statuscode==201 || statuscode==204) {
				/* o.k. */
				statuscode = getCallCapiFunc(wa,req,pCapiHandle,__location,"",-1,-1);
				getBuildReply(wa,statuscode,req,rep,pCapiHandle,wdvhHandle,host,port,__location,-1,-1);
			} else {
				WDVCAPI_GetLastError(pCapiHandle,&__errorItem);
				WDVCAPI_GetErrorType(__errorItem,&__errorType);
				switch (__errorType) {
					case WDVCAPI_ERR_TYPE_UNDEFINED:
					case WDVCAPI_ERR_TYPE_SQL:
						{
							/* internal server error */
							WDVCAPI_GetErrorText(__errorItem,&__errorMsg);
							sp77sprintf(__errorText,1000,ERROR_MOVE_500,__errorMsg);
							break;
						}
					case WDVCAPI_ERR_TYPE_CAPI:
						{
							WDVCAPI_GetErrorCode(__errorItem,&__errorCode);
							switch(__errorCode) {
								/* WDVCAPI_ERR_CODE_EQUAL_RESOURCE_AND_DESTINATION
								= Resource Uri and Destination Uri MUST NOT be equal */
								case WDVCAPI_ERR_CODE_EQUAL_RESOURCE_AND_DESTINATION:
									{
										WDVCAPI_GetErrorText(__errorItem,&__errorMsg);
										sp77sprintf(__errorText,1000,"ERROR: 403 (Forbidden). Restore location is the same as the current location.");
										break;
									}
								case WDVCAPI_ERR_CODE_RESOURCE_OR_COLLECTION_DOESNT_EXIST:
									{
										WDVCAPI_GetErrorText(__errorItem,&__errorMsg);
										sp77sprintf(__errorText,1000,"ERROR: 404 (Not Found). Resource to restore does not exist.");
										break;
									}
									/* WDVCAPI_ERR_CODE_DESTINATION_URI_DOESNT_EXIST
										= the destination Uri contains at least one collection
										that does not exist rigth now */
								case WDVCAPI_ERR_CODE_DESTINATION_URI_DOESNT_EXIST:
									{
										WDVCAPI_GetErrorText(__errorItem,&__errorMsg);
										sp77sprintf(__errorText,1000,"ERROR: 409 (Conflict). Destination does not exist. At least one part of the destination path is not valid.");
										break;
									}
									/*     WDVCAPI_ERR_CODE_DESTINATION_IS_CHILD_OF_SOURCE
										= the destination Uri is child of the source uri ->
										recursion occurs */
								case WDVCAPI_ERR_CODE_DESTINATION_IS_CHILD_OF_SOURCE:
									{
										WDVCAPI_GetErrorText(__errorItem,&__errorMsg);
										sp77sprintf(__errorText,1000,"ERROR: 409 (Conflict). Destination is child of Source.");
										break;
									}
								/* WDVCAPI_ERR_CODE_OVERWRITE_CONFLICT
									= overwrite was verbidden and destination allready exists */
								/*case WDVCAPI_ERR_CODE_OVERWRITE_CONFLICT:*/
								case WDVCAPI_ERR_CODE_RESOURCE_OR_COLLECTION_ALREADY_EXIST:
									{
										WDVCAPI_GetErrorText(__errorItem,&__errorMsg);
										sp77sprintf(__errorText,1000,"ERROR: 412 (Precondition Failed). Resource at destination already exists and overwriting was not allowed.");
										break;
									}
								case WDVCAPI_ERR_CODE_LOCK_EXISTS:
									{
										WDVCAPI_GetErrorText(__errorItem,&__errorMsg);
										sp77sprintf(__errorText,1000,"ERROR: 423 (Locked). Resource at destination is locked.");
										break;
									}
								/* WDVCAPI_ERR_CODE_NO_MEMORY
								= lack of memory */
								case WDVCAPI_ERR_CODE_NO_MEMORY:
									{
										WDVCAPI_GetErrorText(__errorItem,&__errorMsg);
										sp77sprintf(__errorText,1000,ERROR_MOVE_STORAGE_507,server,__resource,__destination);
										sapdbwa_WriteLogMsg(wa, __errorText);
										sp77sprintf(__errorText,1000,ERROR_MOVE_MESSAGE,__errorMsg);
										sapdbwa_WriteLogMsg(wa, __errorText);
										break;
									}
								default:
									{
										WDVCAPI_GetErrorText(__errorItem,&__errorMsg);
										sp77sprintf(__errorText,1000,ERROR_MOVE_URI,server,__resource,__destination);
										sapdbwa_WriteLogMsg(wa, __errorText);
										sp77sprintf(__errorText,1000,ERROR_MOVE_500,__errorMsg);
										sapdbwa_WriteLogMsg(wa, __errorText);
										break;
									}
							}
							break;
						}
					default:
						{
							WDVCAPI_GetErrorText(__errorItem,&__errorMsg);
							sp77sprintf(__errorText,1000,ERROR_MOVE_URI,server,__resource,__destination);
							sapdbwa_WriteLogMsg(wa, __errorText);
							sp77sprintf(__errorText,1000,ERROR_MOVE_500,__errorMsg);
							sapdbwa_WriteLogMsg(wa, __errorText);
							break;
						}
				}
				restoreScreen(wa,req,rep,__resource,__location,pCapiHandle,WDVH_True,__errorText);
			}
		} else if (strcmp(__command,"ShowProps")==0) {
			/* show properties of the given resource */
			/* extract Parameters (Host, RequestURI)*/
			getFirstHeaderLine(wa,req,&host,&port,requestURI);
			/* create Propfind handle */
			WDVCAPI_PropfindCreate(pCapiHandle,__resource,WDVCAPI_DEPTH_0,WDVCAPI_PROPFIND_TYPE_PROPFIND_ALL,&propfind);
			/* call CAPI function*/
			statuscode = propfindCallCapiFunc(pCapiHandle,wa,req,propfind);
			if (statuscode==207) {
				/* build Reply */
				propfindBuildExplorerReply(wa,req,rep,__resource,__location,pCapiHandle,propfind);
			}
			/* Clean Up */
			/* - handles */
			if (propfind) {
				WDVCAPI_PropfindDestroy(pCapiHandle,propfind);
			}
		} else if (strcmp(__command,"ShowColProps")==0) {
			/* extract Parameters (Host, RequestURI)*/
			getFirstHeaderLine(wa,req,&host,&port,requestURI);
			/* create Propfind handle */
			WDVCAPI_PropfindCreate(pCapiHandle,__resource,WDVCAPI_DEPTH_0,WDVCAPI_PROPFIND_TYPE_PROPFIND_ALL,&propfind);
			/* call CAPI function*/
			statuscode = propfindCallCapiFunc(pCapiHandle,wa,req,propfind);
			if (statuscode==207) {
				/* build Reply */
				collectionLockProps(wa,__resource,__location,pCapiHandle,propfind,__locktoken,&__lock);
			}
			/* Clean Up */
			/* - handles */
			if (propfind) {
				WDVCAPI_PropfindDestroy(pCapiHandle,propfind);
			}
			/* call CAPI function*/
			statuscode = getCallCapiFunc(wa,req,pCapiHandle,__resource,"",-1,-1);
			if (statuscode==200) {
				/* build Reply */
				getBuildExplorerReply(wa,req,rep,pCapiHandle,wdvhHandle,__resource,__location,__locktoken,__lock);
			}
		} else if (strcmp(__command,"ShowXmlProps")==0) {
			/* show properties of the given resource */
			/* extract Parameters (Host, RequestURI)*/
			getFirstHeaderLine(wa,req,&host,&port,requestURI);
			/* build Reply */
			showXmlProperties(wa,req,rep,__resource,__location,pCapiHandle,xmlHandle,WDVH_False,"");
		} else if (strcmp(__command,"SetXmlProps")==0) {
			/* change xml properties of the given resource */
			/* get needed parameters from request */
			getParameterValue("DocClass",req,__docclass);
			getParameterValue("DocClassOld",req,__docclassold);
			getParameterValue("ReIndex",req,__reindex);
			/* extract Parameters (Host, RequestURI)*/
			getFirstHeaderLine(wa,req,&host,&port,requestURI);
			/* perform the change */
			if (strcmp(__docclass,__docclassold)!=0 || getParameterValue("ReIndex",req,__reindex)) {
				/* docclass changed */
				if (strcmp(__docclass,"")!=0)
					__pDocClass = __docclass;
				else
					__pDocClass = NULL;
				if (!WDVCAPI_ProppatchSetDocClass(pCapiHandle,__resource,__pDocClass)) {
					/* get server string for error messages */
					buildServerString(req,&server);
					/* something went wrong */
					WDVCAPI_GetLastError(pCapiHandle,&__errorItem);
					WDVCAPI_GetErrorType(__errorItem,&__errorType);
					switch (__errorType) {
						case WDVCAPI_ERR_TYPE_UNDEFINED:
						case WDVCAPI_ERR_TYPE_SQL:
							{
								/* internal server error */
								WDVCAPI_GetErrorText(__errorItem,&__errorMsg);
								__error = ERROR_500;
								sp77sprintf(__errorText,1000,ERROR_PROPPATCH_URI,server,__resource);
								sapdbwa_WriteLogMsg(wa, __errorText);
								sp77sprintf(__errorText,1000,ERROR_PROPPATCH_500,__errorMsg);
								sapdbwa_WriteLogMsg(wa, __errorText);
								break;
							}
						case WDVCAPI_ERR_TYPE_CAPI:
							{
								WDVCAPI_GetErrorCode(__errorItem,&__errorCode);
								WDVCAPI_GetErrorText(__errorItem,&__errorMsg);
								switch(__errorCode) {
									case WDVCAPI_ERR_CODE_LOCK_EXISTS:
											__error = ERROR_423;
											sp77sprintf(__errorText,1000,"423 Resource %s locked. Change of properties forbidden.",__resource);
											sapdbwa_WriteLogMsg(wa, __errorText);
											break;
									default:
										{
											__error = ERROR_500;
											sp77sprintf(__errorText,1000,ERROR_PROPPATCH_URI,server,__resource);
											sapdbwa_WriteLogMsg(wa, __errorText);
											sp77sprintf(__errorText,1000,ERROR_PROPPATCH_500,__errorMsg);
											sapdbwa_WriteLogMsg(wa, __errorText);
											break;
										}
								}
								break;
							}
						default:
							{
								WDVCAPI_GetErrorText(__errorItem,&__errorMsg);
								__error = ERROR_500;
								sp77sprintf(__errorText,1000,ERROR_PROPPATCH_URI,server,__resource);
								sapdbwa_WriteLogMsg(wa, __errorText);
								sp77sprintf(__errorText,1000,ERROR_PROPPATCH_500,__errorMsg);
								sapdbwa_WriteLogMsg(wa, __errorText);
								break;
							}
					}
					if (server) {
						WDVHandler_Free((sapdbwa_UInt1*) server);
					}
					showXmlProperties(wa,req,rep,__resource,__location,pCapiHandle,xmlHandle,WDVH_True,__errorText);
				} else {
					/* success */
					/* call CAPI function*/
					statuscode = getCallCapiFunc(wa,req,pCapiHandle,__location,"",-1,-1);
					if (statuscode==200)
						getBuildReply(wa,statuscode,req,rep,pCapiHandle,wdvhHandle,host,port,__location,-1,-1);
				}
			} else {
				/* nothing to do -> go back to list */
				/* call CAPI function*/
				statuscode = getCallCapiFunc(wa,req,pCapiHandle,__location,"",-1,-1);
				if (statuscode==200)
					getBuildReply(wa,statuscode,req,rep,pCapiHandle,wdvhHandle,host,port,__location,-1,-1);
			}
		} else {
			/* unknown command -> just show the collection */
			/* extract Parameters (Host, RequestURI)*/
			getFirstHeaderLine(wa,req,&host,&port,requestURI);
			/* call CAPI function*/
			statuscode = getCallCapiFunc(wa,req,pCapiHandle,__location,"",-1,-1);
			if (statuscode==200)
				getBuildReply(wa,statuscode,req,rep,pCapiHandle,wdvhHandle,host,port,__location,-1,-1);
		}
	}

	void showCollection(sapdbwa_Handle		wa,
						sapdbwa_HttpRequestP request,
						sapdbwa_HttpReplyP	reply,
						WDVCAPI_WDV			pCapiHandle,
						WDVH_Handle			wdvhHandle,
						WDVH_Char			*host,
						WDVH_Char			*port,
						WDVCAPI_URI			resourceURI)
	{
		/* build a page with links to the collection members */
		WDVH_Char					prefix[WDVH_MAX_URI_LEN+1];
		WDVCAPI_URIString			childResource;
		WDVH_Bool					childFound;
		WDVH_Char					temp[WDVH_MAX_URI_LEN+1];
		WDVH_Char					url[WDVH_MAX_URI_LEN+1];
		WDVH_Char					urlenc[WDVH_MAX_URI_LEN+1];
		WDVH_Char					url_up[WDVH_MAX_URI_LEN+1];
		WDVH_Char					resourceURIenc[WDVH_MAX_URI_LEN+1];
		WDVH_Char					href[WDVH_MAX_URI_LEN+1];
		WDVH_Char					uri[WDVH_MAX_URI_LEN+1];
		WDVH_Char					garbage[WDVH_MAX_URI_LEN+1];
		WDVH_Int2					toggle = 1;
        WDVCAPI_PropertyShortValueBuffer  resourceType;
        WDVCAPI_PropertyShortValueBuffer  filesize;
        WDVCAPI_PropertyShortValueBuffer  lastModified;
		WDVH_Char							size[50];
		WDVH_Char							*server;

		/* set server prefix */
		getWebDAVPrefix(wa,prefix);
		buildServerStringLong(wa,request,&server);

		strcpy(url,"");
		sp77sprintf(url,WDVH_MAX_URI_LEN,"http://%s:%s%s%s",host,port,prefix,resourceURI);
		WDVH_EscapeQuotes(url, strlen(url), urlenc,WDVH_MAX_URI_LEN);
		strcpy(temp,"");
		sp77sprintf(temp,WDVH_MAX_URI_LEN,"http://%s:%s%s%s",host,port,prefix,resourceURI);
		WDVH_EscapeQuotes(temp, strlen(temp), url_up,WDVH_MAX_URI_LEN);
		WDVH_EscapeQuotes(resourceURI, strlen(resourceURI), resourceURIenc,WDVH_MAX_URI_LEN);
		strcpy(temp,"");
		sp77sprintf(temp,WDVH_MAX_URI_LEN,"http://%s:%s%s%s",host,port,prefix,WDVH_DELETED_ITEMS_FOLDER_ESC);
		WDVH_EscapeQuotes(temp, strlen(temp), garbage,WDVH_MAX_URI_LEN);

		WDVH_sendBodyChunk(reply,
							"<html><head>\
							<meta http-equiv=\"expires\" content=\"Sat, 01 Dec 2001 00:00:00 GMT\">\
							<link rel='stylesheet' href='/WARoot/Styles/WDVHandler_Stylesheet.css' type='text/css'>\
							<script>\
							function Del(file) \
							{\
								question = \"Do you really want to delete \"+file+\" ?\";\
								agree = confirm(question);\
								if (agree) {\
									document.explorer.res.value=\"");
		WDVH_sendBodyChunk(reply,server);
		WDVH_sendBodyChunk(reply,
									"\"+escape(file);\
									document.explorer.action = \"");
		WDVH_sendBodyChunk(reply,
							sapdbwa_GetServiceName(wa));
		WDVH_sendBodyChunk(reply,
						"?explorer=0&cmd=Del\";\
									if (top.frames[\"Client\"]) {\
										document.explorer.target = \"Client\";\
									}\
									document.explorer.submit();\
								}\
							}");
		WDVH_sendBodyChunk(reply,
						 "function Discard(file) \
							{\
								if (file == '/Deleted Items')\
									question = \"Do you really want to discard all deleted items?\";\
								else \
									question = \"Do you really want to discard \" + file + \" ?\";\
								agree = confirm(question);\
								if (agree) {\
									document.explorer.res.value=\"");
		WDVH_sendBodyChunk(reply,server);
		WDVH_sendBodyChunk(reply,
									"\"+escape(file);\
									document.explorer.action = \"");
		WDVH_sendBodyChunk(reply,
							sapdbwa_GetServiceName(wa));
		WDVH_sendBodyChunk(reply,
						"?explorer=0&cmd=Discard\";\
									if (top.frames[\"Client\"]) {\
										document.explorer.target = \"Client\";\
									}\
									document.explorer.submit();\
								}\
							}");
		WDVH_sendBodyChunk(reply,
						 "function Restore(file) \
							{\
								document.explorer.res.value=\"");
		WDVH_sendBodyChunk(reply,server);
		WDVH_sendBodyChunk(reply,
								"\"+escape(file);\
								document.explorer.action = \"");
		WDVH_sendBodyChunk(reply,
							sapdbwa_GetServiceName(wa));
		WDVH_sendBodyChunk(reply,
						"?explorer=0&cmd=RestoreScreen\";\
									if (top.frames[\"Client\"]) {\
										document.explorer.target = \"Client\";\
									}\
									document.explorer.submit();\
							}");
		WDVH_sendBodyChunk(reply,
						"function showProps(file) {\
							document.explorer.res.value=\"");
		WDVH_sendBodyChunk(reply,server);
		WDVH_sendBodyChunk(reply,
						"\"+escape(file);\
							document.explorer.action = \"");
		WDVH_sendBodyChunk(reply,
							sapdbwa_GetServiceName(wa));
		WDVH_sendBodyChunk(reply,
						"?explorer=0&cmd=ShowProps\";\
									if (top.frames[\"Client\"]) {\
										document.explorer.target = \"Client\";\
									}\
									document.explorer.submit();\
							}");
		WDVH_sendBodyChunk(reply,
						"function showColProps(file) {\
							document.explorer.res.value=\"");
		WDVH_sendBodyChunk(reply,server);
		WDVH_sendBodyChunk(reply,
						"\"+escape(file);\
							document.explorer.action = \"");
		WDVH_sendBodyChunk(reply,
							sapdbwa_GetServiceName(wa));
		WDVH_sendBodyChunk(reply,
						"?explorer=0&cmd=ShowColProps\";\
									if (top.frames[\"Client\"]) {\
										document.explorer.target = \"Client\";\
									}\
									document.explorer.submit();\
							}");
		WDVH_sendBodyChunk(reply,
						"function showXmlProps(file) {\
							document.explorer.res.value=\"");
		WDVH_sendBodyChunk(reply,server);
		WDVH_sendBodyChunk(reply,
						"\"+escape(file);\
							document.explorer.action = \"");
		WDVH_sendBodyChunk(reply,
							sapdbwa_GetServiceName(wa));
		WDVH_sendBodyChunk(reply,
						"?explorer=0&cmd=ShowXmlProps\";\
									if (top.frames[\"Client\"]) {\
										document.explorer.target = \"Client\";\
									}\
									document.explorer.submit();\
							}");
		WDVH_sendBodyChunk(reply,
						"</script>\
						</head>\
						<body>\
						<form action=\"\" method=\"post\" name=\"explorer\">\
						<input type='hidden' name='location' value='");
		WDVH_sendBodyChunk(reply,
							resourceURIenc);
		WDVH_sendBodyChunk(reply,
						"'><input type='hidden' name='res' value=''>");
		WDVH_sendBodyChunk(reply,
						"<table border=\"0\" width=\"100%\"><tr><td width=1%></td><td valign=center class='tableheader' colspan=7>&nbsp;Content of&nbsp;");

		WDVH_sendBodyChunk(reply,
							url);

		WDVH_sendBodyChunk(reply,
							"</td><td width=1%></td></tr>");

		/* table header */
		WDVH_sendBodyChunk(reply,
							"<tr><td width=1%></td><td class='tablecolheader'>&nbsp;</td><td class='tablecolheader'width=\"100%\">&nbsp;Name&nbsp;</td>");
		WDVH_sendBodyChunk(reply,
						"<td class='tablecolheader' nowrap>&nbsp;Size&nbsp;</td>");
		WDVH_sendBodyChunk(reply,
						"<td class='tablecolheader' nowrap>&nbsp;Last&nbsp;Modified&nbsp;</td>");
		WDVH_sendBodyChunk(reply,
						"<td class='tablecolheader'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>");
		WDVH_sendBodyChunk(reply,
						"<td class='tablecolheader'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>");
		WDVH_sendBodyChunk(reply,
						"<td class='tablecolheader'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td><td width=1%></td></tr>");
		/* this folder "." */
		WDVH_sendBodyChunk(reply,
						"<tr><td width=1%></td><td class='tableline'><a href=\"");
		getUpHref(urlenc,url_up);
		WDVH_sendBodyChunk(reply,
						urlenc);
		WDVH_sendBodyChunk(reply,
							"\"><img src='/WARoot/Images/xml_folder_refresh.gif' valign=absmiddle border=0></a></td><td class='tableline'width=\"100%\"><a class='linkhoverti' href=\"");
		WDVH_sendBodyChunk(reply,
							urlenc);
		WDVH_sendBodyChunk(reply,
						"\">&nbsp;");
		WDVH_sendBodyChunk(reply,
							"<font class='text'><b>.</b></font>");
		WDVH_sendBodyChunk(reply,
						"</a></td>");
		WDVH_sendBodyChunk(reply,
						"<td class='tableline'>&nbsp;</td>");
		WDVH_sendBodyChunk(reply,
						"<td class='tableline'>&nbsp;</td>");
		WDVH_sendBodyChunk(reply,
						"<td class='tableline'>&nbsp;</td>");
		WDVH_sendBodyChunk(reply,
						"<td class='tableline'>&nbsp;</td>");
		WDVH_sendBodyChunk(reply,
						"<td class='tableline'>&nbsp;</td><td width=1%></td></tr>");
		toggle = toggle * (-1);

		if (strcmp(resourceURI,"/")!=0) {
			/* this folder ".." */
			WDVH_sendBodyChunk(reply,
								"<tr><td width=1%></td><td class='tableline2'><a href=\"");
			getUpHref(urlenc,url_up);
			WDVH_sendBodyChunk(reply,
								url_up);
			WDVH_sendBodyChunk(reply,
								"\"><img src='/WARoot/Images/xml_folder_up.gif' valign=absmiddle border=0></a></td><td class='tableline2'width=\"100%\"><a class='linkhoverti' href=\"");
			getUpHref(urlenc,url_up);
			WDVH_sendBodyChunk(reply,
								url_up);
			WDVH_sendBodyChunk(reply,
							"\">&nbsp;");
			WDVH_sendBodyChunk(reply,
								"<font class='text'><b>..</b></font>");
			WDVH_sendBodyChunk(reply,
							"</a></td>");
			WDVH_sendBodyChunk(reply,
							"<td class='tableline2' nowrap>&nbsp;</td>");
			WDVH_sendBodyChunk(reply,
							"<td class='tableline2' nowrap>&nbsp;</td>");
			WDVH_sendBodyChunk(reply,
							"<td class='tableline2'>&nbsp;</td>");
			WDVH_sendBodyChunk(reply,
							"<td class='tableline2'>&nbsp;</td>");
			WDVH_sendBodyChunk(reply,
							"<td class='tableline2'>&nbsp;</td><td width=1%></td></tr>");
			toggle = toggle * (-1);
		}
		if (strcmp(resourceURI,"/")==0) {
			/* this folder "Deleted Items" */
			if (toggle == 1) {
				WDVH_sendBodyChunk(reply,
									"<tr><td width=1%></td><td class='tableline'><a href=\"");
				WDVH_sendBodyChunk(reply,
								garbage);
				WDVH_sendBodyChunk(reply,
								"\"><img src='/WARoot/Images/xml_folder_trash.gif' valign=absmiddle border=0></a></td><td class='tableline'width=\"100%\"><a class='linkhoverti' href=\"");
				WDVH_sendBodyChunk(reply,
								garbage);
				WDVH_sendBodyChunk(reply,
								"\">&nbsp;");
				WDVH_sendBodyChunk(reply,
									"<font class='text'>Deleted Items</font>");
				WDVH_sendBodyChunk(reply,
								"</a></td>");
				WDVH_sendBodyChunk(reply,
								"<td class='tableline' align=right nowrap><font class='text'>&nbsp;&nbsp;&nbsp;</font></td>");
				WDVH_sendBodyChunk(reply,
								"<td class='tableline' nowrap><font class='text'>&nbsp;&nbsp;</font></td>");
				WDVH_sendBodyChunk(reply,
								"<td class='tableline'><a title='Show Properties' href=javascript:showColProps(\"");
				WDVH_sendBodyChunk(reply,
								WDVH_DELETED_ITEMS_FOLDER_ESC);
				WDVH_sendBodyChunk(reply,
								"\")><img src='/WARoot/Images/xml_props.gif' border=0 valign=absmiddle></a></td>");
				WDVH_sendBodyChunk(reply,
								"<td class='tableline' align=right nowrap><font class='text'>&nbsp;</font></td>");
				WDVH_sendBodyChunk(reply,
								"<td class='tableline'><a title='Empty Deleted Items Folder' href=javascript:Discard(\"");
				WDVH_sendBodyChunk(reply,
								WDVH_DELETED_ITEMS_FOLDER_ESC);
				WDVH_sendBodyChunk(reply,
								"\")><img src='/WARoot/Images/xml_trash_empty.gif' border=0 valign=absmiddle></a></td><td width=1%></td></tr>");
			} else {
				WDVH_sendBodyChunk(reply,
									"<tr><td width=1%></td><td class='tableline2'><a href=\"");
				WDVH_sendBodyChunk(reply,
								garbage);
				WDVH_sendBodyChunk(reply,
								"\"><img src='/WARoot/Images/xml_folder_trash.gif' valign=absmiddle border=0></a></td><td class='tableline2'width=\"100%\"><a class='linkhoverti' href=\"");
				WDVH_sendBodyChunk(reply,
								garbage);
				WDVH_sendBodyChunk(reply,
								"\">&nbsp;");
				WDVH_sendBodyChunk(reply,
									"<font class='text'>Deleted Items</font>");
				WDVH_sendBodyChunk(reply,
								"</a></td>");
				WDVH_sendBodyChunk(reply,
								"<td class='tableline2' align=right nowrap><font class='text'>&nbsp;&nbsp;&nbsp;</font></td>");
				WDVH_sendBodyChunk(reply,
								"<td class='tableline2' nowrap><font class='text'>&nbsp;&nbsp;</font></td>");
				WDVH_sendBodyChunk(reply,
								"<td class='tableline2'><a title='Show Properties' href=javascript:showColProps(\"");
				WDVH_sendBodyChunk(reply,
								WDVH_DELETED_ITEMS_FOLDER_ESC);
				WDVH_sendBodyChunk(reply,
								"\")><img src='/WARoot/Images/xml_props.gif' border=0 valign=absmiddle></a></td>");
				WDVH_sendBodyChunk(reply,
								"<td class='tableline2' align=right nowrap><font class='text'>&nbsp;</font></td>");
				WDVH_sendBodyChunk(reply,
								"<td class='tableline2'><a title='Empty Deleted Items Folder' href=javascript:Discard(\"");
				WDVH_sendBodyChunk(reply,
								WDVH_DELETED_ITEMS_FOLDER_ESC);
				WDVH_sendBodyChunk(reply,
								"\")><img src='/WARoot/Images/xml_trash_empty.gif' border=0 valign=absmiddle></a></td><td width=1%></td></tr>");
			}
			toggle = toggle * (-1);
		}

		/* get the child collections */
		WDVCAPI_GetCollection(pCapiHandle,childResource,resourceType,filesize,lastModified,&childFound);
		while(childFound) {
			/* get some properties */
			if (toggle == 1) {
				getResourceHref(urlenc,childResource,temp);
				WDVH_EscapeQuotes(temp, strlen(temp), href, WDVH_MAX_URI_LEN);
				strcpy(uri,temp);
				getRequestUriFromString(wa,request,temp);
				if (strcmp(temp,WDVH_DELETED_ITEMS_FOLDER)!=0) {
					WDVH_EscapeQuotes(temp, strlen(temp), uri, WDVH_MAX_URI_LEN);
					if (strcmp(resourceType,"collection")==0) {
						WDVH_sendBodyChunk(reply,
										"<tr><td width=1%></td><td class='tableline'><a href=\"");
						WDVH_sendBodyChunk(reply,
										href);
						WDVH_sendBodyChunk(reply,
										"\"><img src='/WARoot/Images/xml_folder.gif' valign=absmiddle border=0></a></td><td class='tableline'width=\"100%\"><a class='linkhoverti' href=\"");
					} else {
						WDVH_sendBodyChunk(reply,
										"<tr><td width=1%></td><td class='tableline'><a href=\"");
						WDVH_sendBodyChunk(reply,
										href);
						WDVH_sendBodyChunk(reply,
										"\"><img src='/WARoot/Images/xml_file.gif' valign=absmiddle border=0></a></td><td class='tableline'width=\"100%\"><a class='linkhoverti' target=top href=\"");
					}
					WDVH_sendBodyChunk(reply,
									href);
					WDVH_sendBodyChunk(reply,
									"\">&nbsp;<font class='text'>");
					WDVH_sendBodyChunk(reply,
									childResource);
					WDVH_sendBodyChunk(reply,
									"</font></a></td>");
					if (strcmp(resourceType,"collection")!=0) {
						WDVH_sendBodyChunk(reply,
										"<td class='tableline' align=right nowrap><font class='text'>&nbsp;");
						transformFileSize(filesize,size,WDVH_False);
						WDVH_sendBodyChunk(reply,
										size);
						WDVH_sendBodyChunk(reply,
										"&nbsp;&nbsp;</font></td>");
						WDVH_sendBodyChunk(reply,
										"<td class='tableline' nowrap><font class='text'>&nbsp;");
						WDVH_sendBodyChunk(reply,
										lastModified);
						WDVH_sendBodyChunk(reply,
										"&nbsp;</font></td>");
						WDVH_sendBodyChunk(reply,
										"<td class='tableline'><a title='Show Properties' href=javascript:showProps(\"");
						WDVH_sendBodyChunk(reply,
										uri);
						WDVH_sendBodyChunk(reply,
										"\")><img src='/WARoot/Images/xml_props.gif' border=0 valign=absmiddle></a></td>");
/*						WDVH_sendBodyChunk(reply,
										"<td class='tableline'><a title='Show XML Indexing Properties' href=javascript:showXmlProps('");
						WDVH_sendBodyChunk(reply,
										uri);
						WDVH_sendBodyChunk(reply,
										"')><img src='/WARoot/Images/xml_xml.gif' border=0 valign=absmiddle></a></td>");
*/						if (strncmp(resourceURI,WDVH_DELETED_ITEMS_FOLDER,strlen(WDVH_DELETED_ITEMS_FOLDER))!=0) {
							WDVH_sendBodyChunk(reply,
											"<td class='tableline'><a title='Show XML Indexing Properties' href=javascript:showXmlProps('");
							WDVH_sendBodyChunk(reply,
											uri);
							WDVH_sendBodyChunk(reply,
											"')><img src='/WARoot/Images/xml_xml.gif' border=0 valign=absmiddle></a></td>");
						} else {
							WDVH_sendBodyChunk(reply,
											"<td class='tableline'><a title='Restore' href=javascript:Restore('");
							WDVH_sendBodyChunk(reply,
											uri);
							WDVH_sendBodyChunk(reply,
											"')><img src='/WARoot/Images/xml_trash_recycle.gif' border=0 valign=absmiddle></a></td>");
						}
					} else {
						WDVH_sendBodyChunk(reply,
										"<td class='tableline' align=right nowrap><font class='text'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</font></td>");
						WDVH_sendBodyChunk(reply,
										"<td class='tableline' nowrap><font class='text'>&nbsp;");
						WDVH_sendBodyChunk(reply,
										lastModified);
						WDVH_sendBodyChunk(reply,
										"&nbsp;</font></td>");
						WDVH_sendBodyChunk(reply,
										"<td class='tableline'><a title='Show Properties' href=javascript:showColProps('");
						WDVH_sendBodyChunk(reply,
										uri);
						WDVH_sendBodyChunk(reply,
										"')><img src='/WARoot/Images/xml_props.gif' border=0 valign=absmiddle></a></td>");
/*						WDVH_sendBodyChunk(reply,
										"<td class='tableline' align=right nowrap><font class='text'>&nbsp;&nbsp;&nbsp;</font></td>");
*/						if (strncmp(resourceURI,WDVH_DELETED_ITEMS_FOLDER,strlen(WDVH_DELETED_ITEMS_FOLDER))!=0) {
							WDVH_sendBodyChunk(reply,
											"<td class='tableline' align=right nowrap><font class='text'>&nbsp;&nbsp;&nbsp;</font></td>");
						} else {
							WDVH_sendBodyChunk(reply,
											"<td class='tableline'><a title='Restore' href=javascript:Restore('");
							WDVH_sendBodyChunk(reply,
											uri);
							WDVH_sendBodyChunk(reply,
											"')><img src='/WARoot/Images/xml_trash_recycle.gif' border=0 valign=absmiddle></a></td>");
						}
					}
/*					WDVH_sendBodyChunk(reply,
									"<td class='tableline'><a title='Delete' href=javascript:Del(\"");
					WDVH_sendBodyChunk(reply,
									uri);
					WDVH_sendBodyChunk(reply,
									"\")><img src='/WARoot/Images/xml_trash.gif' border=0 valign=absmiddle></a></td><td width=1%></td></tr>");
*/					if (strncmp(resourceURI,WDVH_DELETED_ITEMS_FOLDER,strlen(WDVH_DELETED_ITEMS_FOLDER))!=0) {
						WDVH_sendBodyChunk(reply,
										"<td class='tableline'><a title='Delete' href=javascript:Del(\"");
						WDVH_sendBodyChunk(reply,
										uri);
						WDVH_sendBodyChunk(reply,
										"\")><img src='/WARoot/Images/xml_trash.gif' border=0 valign=absmiddle></a></td><td width=1%></td></tr>");
					} else {
						WDVH_sendBodyChunk(reply,
										"<td class='tableline'><a title='Discard' href=javascript:Discard(\"");
						WDVH_sendBodyChunk(reply,
										uri);
						WDVH_sendBodyChunk(reply,
										"\")><img src='/WARoot/Images/xml_trash_empty.gif' border=0 valign=absmiddle></a></td><td width=1%></td></tr>");
					}
				}
			} else {
				getResourceHref(urlenc,childResource,temp);
				WDVH_EscapeQuotes(temp, strlen(temp), href, WDVH_MAX_URI_LEN);
				strcpy(uri,temp);
				getRequestUriFromString(wa,request,temp);
				if (strcmp(temp,WDVH_DELETED_ITEMS_FOLDER)!=0) {
					WDVH_EscapeQuotes(temp, strlen(temp), uri, WDVH_MAX_URI_LEN);
					if (strcmp(resourceType,"collection")==0) {
						WDVH_sendBodyChunk(reply,
										"<tr><td width=1%></td><td class='tableline2'><a href=\"");
						WDVH_sendBodyChunk(reply,
										href);
						WDVH_sendBodyChunk(reply,
										"\"><img src='/WARoot/Images/xml_folder.gif' valign=absmiddle border=0></a></td><td class='tableline2'width=\"100%\"><a class='linkhoverti' href=\"");
					} else {
						WDVH_sendBodyChunk(reply,
										"<tr><td width=1%></td><td class='tableline2'><a href=\"");
						WDVH_sendBodyChunk(reply,
										href);
						WDVH_sendBodyChunk(reply,
										"\"><img src='/WARoot/Images/xml_file.gif' valign=absmiddle border=0></a></td><td class='tableline2'width=\"100%\"><a class='linkhoverti' target=top href=\"");
					}
					WDVH_sendBodyChunk(reply,
									href);
					WDVH_sendBodyChunk(reply,
									"\">&nbsp;");
					WDVH_sendBodyChunk(reply,
									childResource);
					WDVH_sendBodyChunk(reply,
									"</a></td>");
					if (strcmp(resourceType,"collection")!=0) {
						WDVH_sendBodyChunk(reply,
										"<td class='tableline2' align=right nowrap><font class='text'>&nbsp;");
						transformFileSize(filesize,size,WDVH_False);
						WDVH_sendBodyChunk(reply,
										size);
						WDVH_sendBodyChunk(reply,
										"&nbsp;&nbsp;</font></td>");
						WDVH_sendBodyChunk(reply,
										"<td class='tableline2' nowrap><font class='text'>&nbsp;");
						WDVH_sendBodyChunk(reply,
										lastModified);
						WDVH_sendBodyChunk(reply,
										"&nbsp;</font></td>");
						WDVH_sendBodyChunk(reply,
										"<td class='tableline2'><a title='Show Properties' href=javascript:showProps(\"");
						WDVH_sendBodyChunk(reply,
										uri);
						WDVH_sendBodyChunk(reply,
										"\")><img src='/WARoot/Images/xml_props.gif' border=0 valign=absmiddle></a></td>");
/*						WDVH_sendBodyChunk(reply,
										"<td class='tableline2'><a title='Show XML Indexing Properties' href=javascript:showXmlProps('");
						WDVH_sendBodyChunk(reply,
										uri);
						WDVH_sendBodyChunk(reply,
										"')><img src='/WARoot/Images/xml_xml.gif' border=0 valign=absmiddle></a></td>");
*/						if (strncmp(resourceURI,WDVH_DELETED_ITEMS_FOLDER,strlen(WDVH_DELETED_ITEMS_FOLDER))!=0) {
							WDVH_sendBodyChunk(reply,
											"<td class='tableline2'><a title='Show XML Indexing Properties' href=javascript:showXmlProps('");
							WDVH_sendBodyChunk(reply,
											uri);
							WDVH_sendBodyChunk(reply,
											"')><img src='/WARoot/Images/xml_xml.gif' border=0 valign=absmiddle></a></td>");
						} else {
							WDVH_sendBodyChunk(reply,
											"<td class='tableline2'><a title='Restore' href=javascript:Restore('");
							WDVH_sendBodyChunk(reply,
											uri);
							WDVH_sendBodyChunk(reply,
											"')><img src='/WARoot/Images/xml_trash_recycle.gif' border=0 valign=absmiddle></a></td>");
						}
					} else {
						WDVH_sendBodyChunk(reply,
										"<td class='tableline2' align=right nowrap><font class='text'>&nbsp;&nbsp;&nbsp;</font></td>");
						WDVH_sendBodyChunk(reply,
										"<td class='tableline2' nowrap><font class='text'>&nbsp;");
						WDVH_sendBodyChunk(reply,
										lastModified);
						WDVH_sendBodyChunk(reply,
										"&nbsp;</font></td>");
						WDVH_sendBodyChunk(reply,
										"<td class='tableline2'><a title='Show Properties' href=javascript:showColProps('");
						WDVH_sendBodyChunk(reply,
										uri);
						WDVH_sendBodyChunk(reply,
										"')><img src='/WARoot/Images/xml_props.gif' border=0 valign=absmiddle></a></td>");
/*						WDVH_sendBodyChunk(reply,
										"<td class='tableline2' align=right nowrap><font class='text'>&nbsp;&nbsp;&nbsp;</font></td>");
*/						if (strncmp(resourceURI,WDVH_DELETED_ITEMS_FOLDER,strlen(WDVH_DELETED_ITEMS_FOLDER))!=0) {
							WDVH_sendBodyChunk(reply,
											"<td class='tableline2' align=right nowrap><font class='text'>&nbsp;&nbsp;&nbsp;</font></td>");
						} else {
							WDVH_sendBodyChunk(reply,
											"<td class='tableline2'><a title='Restore' href=javascript:Restore('");
							WDVH_sendBodyChunk(reply,
											uri);
							WDVH_sendBodyChunk(reply,
											"')><img src='/WARoot/Images/xml_trash_recycle.gif' border=0 valign=absmiddle></a></td>");
						}
					}
/*					WDVH_sendBodyChunk(reply,
									"<td class='tableline2'><a title='Delete' href=javascript:Del(\"");
					WDVH_sendBodyChunk(reply,
									uri);
					WDVH_sendBodyChunk(reply,
									"\")><img src='/WARoot/Images/xml_trash.gif' border=0 valign=absmiddle></a></td><td width=1%></td></tr>");
*/					if (strncmp(resourceURI,WDVH_DELETED_ITEMS_FOLDER,strlen(WDVH_DELETED_ITEMS_FOLDER))!=0) {
						WDVH_sendBodyChunk(reply,
										"<td class='tableline2'><a title='Delete' href=javascript:Del(\"");
						WDVH_sendBodyChunk(reply,
										uri);
						WDVH_sendBodyChunk(reply,
										"\")><img src='/WARoot/Images/xml_trash.gif' border=0 valign=absmiddle></a></td><td width=1%></td></tr>");
					} else {
						WDVH_sendBodyChunk(reply,
										"<td class='tableline2'><a title='Discard' href=javascript:Discard(\"");
						WDVH_sendBodyChunk(reply,
										uri);
						WDVH_sendBodyChunk(reply,
										"\")><img src='/WARoot/Images/xml_trash_empty.gif' border=0 valign=absmiddle></a></td><td width=1%></td></tr>");
					}
				}
			}
			toggle = toggle*(-1);
			WDVCAPI_GetNextCollection(pCapiHandle,childResource,resourceType,filesize,lastModified,&childFound);

		}

		WDVH_sendBodyChunk(reply,
							"</table></form></body></html>");
		WDVH_sendBodyChunkEnd(reply);

		if (server) {
			WDVHandler_Free((sapdbwa_UInt1*) server);
		}
	}

	void propfindBuildExplorerReply(sapdbwa_Handle			wa,
									sapdbwa_HttpRequestP	request,
									sapdbwa_HttpReplyP		reply,
									WDVH_Char				*uri,
									WDVH_Char				*location,
									WDVCAPI_WDV				wdv,
									WDVCAPI_PropfindHandle  propfind)
	{
		WDVCAPI_PropfindPropertyName				propertyName;
		WDVCAPI_PropfindPropertyShortValue			propertyShortValue;
		WDVCAPI_PropfindNameSpace					propfindNamespace;
		WDVCAPI_PropfindNameSpaceShortcut			propertyNamespaceShortcut;
		WDVCAPI_PropfindNameSpaceShortcut			davPropertyNamespaceShortcut = NULL;
		WDVH_XmlNamespaceList						namespaceList;
		WDVH_XmlNamespace							ns;
		WDVH_Char									resourcetype[WDV_MAX_PROPERTY_SHORT_VALUE_LEN+1];
		WDVH_Char									getcontenttype[WDV_MAX_PROPERTY_SHORT_VALUE_LEN+1];
		WDVH_Char									getcontentlength[WDV_MAX_PROPERTY_SHORT_VALUE_LEN+1];
		WDVH_Char									getlastmodified[WDV_MAX_PROPERTY_SHORT_VALUE_LEN+1];
		WDVCAPI_LockHandle							lock;
		WDVH_Char									timeout[50];
		WDVH_Char									locktoken[100];
		WDVH_Char									size[50];
		WDVH_Char									prefix[WDVH_MAX_URI_LEN+1];
		WDVH_Char									*server;

		strcpy(locktoken,"");
		strcpy(resourcetype,"");
		strcpy(getcontenttype,"");
		strcpy(getcontentlength,"");
		strcpy(getlastmodified,"");
		strcpy(timeout,"");
		strcpy(size,"");
		strcpy(prefix,"");

		sapdbwa_InitHeader(reply,
						   ERROR_200,
						   "text/html",
						   NULL,
						   NULL,								/* const char    *LastModified,*/
						   NULL,								/* const char    *Expires,*/
						   NULL);								/* const char    *Location );*/
		sapdbwa_SetHeader(reply,
						"Transfer-Encoding",
						"chunked");
		sapdbwa_SendHeader(reply);

		/* get server string for error messages */
		buildServerString(request,&server);
		/* set server prefix */
		getWebDAVPrefix(wa,prefix);

		/* build namespace list */
		if (!xmlParserCreateNamespaceList(NULL, &namespaceList)) {
		}
		if (WDVCAPI_PropfindGetFirstNameSpace(wdv,propfind,&propertyNamespaceShortcut,&propfindNamespace)) {
			do {
                /* Find out wich shortcut belongs to DAV: */
                if (!davPropertyNamespaceShortcut && strcmp(propfindNamespace, "DAV:") == 0) {
                    /* Shortcut found, so we have to memorize shortcut for later use */
                    davPropertyNamespaceShortcut = propertyNamespaceShortcut;
                }
				strcpy(ns.prefix,propertyNamespaceShortcut);
				strcpy(ns.uri,propfindNamespace);
				xmlParserAddNamespaceToList(NULL,ns,namespaceList);
			} while(WDVCAPI_PropfindGetNextNameSpace(wdv,propfind,&propertyNamespaceShortcut,&propfindNamespace));
		} else {
		}

		/* loop at properties */
		if (WDVCAPI_PropfindGetFirstProperty(wdv,propfind)) {
			do {
				if (WDVCAPI_PropfindGetPropertyName(wdv,propfind,&propertyName )) {
					WDVCAPI_PropfindGetPropertyNameSpaceShortcut(wdv,propfind,&propertyNamespaceShortcut);
					WDVCAPI_PropfindGetPropertyShortValue(wdv,propfind,&propertyShortValue);
					if (strcmp(propertyName,"resourcetype")==0 && strcmp(propertyNamespaceShortcut,davPropertyNamespaceShortcut)==0)
						strcpy(resourcetype,propertyShortValue);
					else if (strcmp(propertyName,"getcontenttype")==0 && strcmp(propertyNamespaceShortcut,davPropertyNamespaceShortcut)==0)
						strcpy(getcontenttype,propertyShortValue);
					else if (strcmp(propertyName,"getcontentlength")==0 && strcmp(propertyNamespaceShortcut,davPropertyNamespaceShortcut)==0)
						strcpy(getcontentlength,propertyShortValue);
					else if (strcmp(propertyName,"getlastmodified")==0 && strcmp(propertyNamespaceShortcut,davPropertyNamespaceShortcut)==0)
						strcpy(getlastmodified,propertyShortValue);
					/* property lockdiscovery has to collect additional data */
					else if (strcmp(propertyName,WDVH_XML_LOCKDISCOVERY)==0) {
						if (WDVCAPI_IdStringIsInitialValue(propertyShortValue)) {
							sp77sprintf(locktoken,100,"");
						} else {
							sp77sprintf(locktoken,100,"saplocktoken:%s",propertyShortValue);
							WDVCAPI_PropfindGetLockDescription(wdv,propfind,propertyShortValue,&lock);
						}
					}
				}
			} while(WDVCAPI_PropfindGetNextProperty(wdv,propfind));
		}

		/* send the properties page */
		WDVH_sendBodyChunk(reply,
						"<head><meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1'><link rel='stylesheet' href='/WARoot/Styles/WDVHandler_Stylesheet.css' type='text/css'></head><body topmargin='0' leftmargin='0'><form action='' method='post' name='showXie' ID='Form1'><table border='0' cellpadding='0' cellspacing='0' ID='Table1'><tr><td>&nbsp;&nbsp;&nbsp;</td><td class='text'><h1>Properties of ");
		WDVH_sendBodyChunk(reply,
						 uri);
		WDVH_sendBodyChunk(reply,
						"</h1></td>\
			<tr>\
				<td>&nbsp;&nbsp;&nbsp;</td>\
				<td>\
					<table border='0' cellpadding='0' cellspacing='0' width='10%' ID='Table2'>\
						<tr>\
							<td>\
								<!-- Separator -->\
								<table border='0' cellpadding='0' cellspacing='0' ID='Table7'>\
									<tr>\
										<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
									</tr>\
								</table>\
								<!-- GroupboxTitle -->\
								<table border='0' cellpadding='0' cellspacing='0' bgcolor='#CBD5E1' width='100%' ID='Table3'>\
									<tr>\
										<td class='groupheader'><img src='/WARoot/Images/1x1.gif' height='5' width='500'></td>\
									</tr>\
									<tr>\
										<td nowrap class='groupheader'>&nbsp;&nbsp;WebDAV Properties&nbsp;</td>\
									</tr>\
									<tr>\
										<td class='groupheader'><img src='/WARoot/Images/1x1.gif' height='5' width='500'></td>\
									</tr>\
								</table>");
		WDVH_sendBodyChunk(reply,
						"<!-- Separator -->\
								<table border='0' cellpadding='0' cellspacing='0' ID='Table4'>\
									<tr>\
										<td><img src='/WARoot/Images/1x1.gif' height='1'></td>\
									</tr>\
								</table>\
								<table border='0' cellpadding='0' cellspacing='1' bgcolor='#DCE3EC' ID='Table8'>\
									<tr>\
										<td>\
											<!-- Separator -->\
											<table bgcolor='#ffffff' border='0' cellpadding='0' cellspacing='0' width='100%' ID='Table11'>\
												<tr>\
													<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
												</tr>\
											</table>\
											<table border='0' cellpadding='0' cellspacing='0' bgcolor='#ffffff' ID='Table5'>\
												<tr>\
													<td><img src='/WARoot/Images/1x1.gif' width='20'></td>\
													<td class='text'>\
														<table border='0' cellpadding='0' cellspacing='0' ID='Table6'>\
															<tr><td><img src='/WARoot/Images/1x1.gif' width='150' height='1'></td></tr>");
		WDVH_sendBodyChunk(reply,
						"									<!-- Serer Name -->\
															<tr>\
																<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Content Type</td>\
																<td><img src='/WARoot/Images/1x1.gif' width='10'></td>\
																<td>\
																	<table border='0' cellpadding='0' cellspacing='1' bgcolor='#666666' width='100%' ID='Table13'>\
																		<tr>\
																			<td colspan='6' valign='bottom' height='16' class='inputreadonly' width='480' nowrap>\
																				&nbsp;&nbsp;");
		WDVH_sendBodyChunk(reply,
						 getcontenttype);
		WDVH_sendBodyChunk(reply,
						"&nbsp;&nbsp;\
																			</td>\
																		</tr>\
																	</table>\
																</td>\
																<td><img src='/WARoot/Images/1x1.gif' width='20'></td>\
															</tr>\
															<tr>\
																<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>\
															<!-- Separator -->\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif' height='5'></td>\
															</tr>\
															<!-- Description  -->\
															<tr>\
																<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Size</td>\
																<td><img src='/WARoot/Images/1x1.gif' width='10'></td>\
																<td>\
																	<table border='0' cellpadding='0' cellspacing='1' bgcolor='#666666' width='100%' ID='Table14'>\
																		<tr>\
																			<td colspan='6' valign='bottom' height='16' class='inputreadonly' width='480' nowrap>\
																				&nbsp;&nbsp;");
		transformFileSize(getcontentlength,size,WDVH_True);
		WDVH_sendBodyChunk(reply,
						 size);
		WDVH_sendBodyChunk(reply,
						"&nbsp;&nbsp;\
																			</td>\
																		</tr>\
																	</table>\
																</td>\
															</tr>\
															<tr>\
																<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>\
															<!-- Separator -->\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif' height='5'></td>\
															</tr>\
															<!-- InstRoot  -->\
															<tr>\
																<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Last Modified</td>\
																<td><img src='/WARoot/Images/1x1.gif' width='5'></td>\
																<td>\
																	<table border='0' cellpadding='0' cellspacing='1' bgcolor='#666666' width='100%' ID='Table15'>\
																		<tr>\
																			<td colspan='6' valign='bottom' height='16' class='inputreadonly' width='480' nowrap>\
																				&nbsp;&nbsp;");
		WDVH_sendBodyChunk(reply,
						 getlastmodified);
		WDVH_sendBodyChunk(reply,
						"&nbsp;&nbsp;\
																			</td>\
																		</tr>\
																	</table>\
																</td>\
															</tr>\
															<tr>\
																<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>\
															<!-- Separator -->\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
															</tr>\
														</table>\
													</td>\
												</tr>\
											</table>\
										</td>\
									</tr>\
								</table>\
							</td>\
						</tr>");
		if (strcmp(locktoken,"")!=0) {
			WDVH_sendBodyChunk(reply,
							"<tr>\
								<td>\
									<!-- Separator -->\
									<table border='0' cellpadding='0' cellspacing='0' ID='Table16'>\
										<tr>\
											<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
										</tr>\
									</table>\
									<!-- GroupboxTitle -->\
									<table border='0' cellpadding='0' cellspacing='0' bgcolor='#CBD5E1' width='100%' ID='Table17'>\
										<tr>\
											<td class='groupheader'><img src='/WARoot/Images/1x1.gif' height='5' width='500'></td>\
										</tr>\
										<tr>\
											<td nowrap class='groupheader'>&nbsp;&nbsp;WebDAV Lock Properties&nbsp;</td>\
										</tr>\
										<tr>\
											<td class='groupheader'><img src='/WARoot/Images/1x1.gif' height='5' width='500'></td>\
										</tr>\
									</table>\
									<!-- Separator -->\
									<table border='0' cellpadding='0' cellspacing='0' ID='Table18'>\
										<tr>\
											<td><img src='/WARoot/Images/1x1.gif' height='1'></td>\
										</tr>\
									</table>");
			WDVH_sendBodyChunk(reply,
							"<table border='0' cellpadding='0' cellspacing='1' bgcolor='#DCE3EC' ID='Table19'>\
										<tr>\
											<td>\
												<!-- Separator -->\
												<table bgcolor='#ffffff' border='0' cellpadding='0' cellspacing='0' width='100%' ID='Table20'>\
													<tr>\
														<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
													</tr>\
												</table>\
												<table border='0' cellpadding='0' cellspacing='0' bgcolor='#ffffff' width='100%' ID='Table21'>\
													<tr>\
														<td><img src='/WARoot/Images/1x1.gif' width='20'></td>\
														<td class='text'>\
															<table border='0' cellpadding='0' cellspacing='0' width='100%' ID='Table23'>\
																<tr><td><img src='/WARoot/Images/1x1.gif' width='150' height='1'></td></tr>\
																<tr>\
																	<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Lock Type</td>\
																	<td><img src='/WARoot/Images/1x1.gif' width='10'></td>\
																	<td>\
																		<table border='0' cellpadding='0' cellspacing='1' bgcolor='#666666' width='100%' ID='Table24'>\
																			<tr>\
																				<td colspan='6' valign='bottom' height='16' class='inputreadonly' width='480' nowrap>\
																					&nbsp;&nbsp;");
			if (lock->type == WDVCAPI_LOCK_TYPE_WRITE)
				WDVH_sendBodyChunk(reply,
								"write");
			else
				WDVH_sendBodyChunk(reply,
								" ");
			WDVH_sendBodyChunk(reply,
							"&nbsp;&nbsp;\
																				</td>\
																			</tr>\
																		</table>\
																	</td>\
																	<td><img src='/WARoot/Images/1x1.gif' width='20'></td>\
																</tr>\
																<tr>\
																	<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																<!-- Separator -->\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif' height='5'></td>\
																</tr>\
																<!-- Serer Name -->\
																<tr>\
																	<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Scope</td>\
																	<td><img src='/WARoot/Images/1x1.gif' width='10'></td>\
																	<td>\
																		<table border='0' cellpadding='0' cellspacing='1' bgcolor='#666666' width='100%' ID='Table25'>\
																			<tr>\
																				<td colspan='6' valign='bottom' height='16' class='inputreadonly' width='480' nowrap>\
																					&nbsp;&nbsp;");
			if (lock->scope == WDVCAPI_LOCK_SCOPE_EXCLUSIVE)
				WDVH_sendBodyChunk(reply,
								"exclusive");
			else
				WDVH_sendBodyChunk(reply,
								" ");
			WDVH_sendBodyChunk(reply,
							"&nbsp;&nbsp;\
																				</td>\
																			</tr>\
																		</table>\
																	</td>\
																	<td><img src='/WARoot/Images/1x1.gif' width='20'></td>\
																</tr>\
																<tr>\
																	<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																<!-- Separator -->\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif' height='5'></td>\
																</tr>\
																<!-- Description  -->\
																<tr>\
																	<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Owner</td>\
																	<td><img src='/WARoot/Images/1x1.gif' width='10'></td>\
																	<td>\
																		<table border='0' cellpadding='0' cellspacing='1' bgcolor='#666666' width='100%' ID='Table26'>\
																			<tr>\
																				<td colspan='6' valign='bottom' height='16' class='inputreadonly' width='480' nowrap>\
																					&nbsp;&nbsp;");
			WDVH_sendBodyChunk(reply,
							lock->owner);
			WDVH_sendBodyChunk(reply,
							"&nbsp;&nbsp;\
																				</td>\
																			</tr>\
																		</table>\
																	</td>\
																</tr>\
																<tr>\
																	<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif'></td>\
																<!-- Separator -->\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif' height='5'></td>\
																</tr>\
																<!-- LockDepth  -->\
																<tr>\
																	<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Depth</td>\
																	<td><img src='/WARoot/Images/1x1.gif' width='5'></td>\
																	<td>\
																		<table border='0' cellpadding='0' cellspacing='1' bgcolor='#666666' width='100%' ID='Table29'>\
																			<tr>\
																				<td colspan='6' valign='bottom' height='16' class='inputreadonly' width='480' nowrap>\
																					&nbsp;&nbsp;");
			if (lock->depth == WDVCAPI_DEPTH_0)
				WDVH_sendBodyChunk(reply,
								"0");
			else if (lock->depth == WDVCAPI_DEPTH_1)
				WDVH_sendBodyChunk(reply,
								"1");
			else if (lock->depth == WDVCAPI_DEPTH_INFINITE)
				WDVH_sendBodyChunk(reply,
								"Infinite");
			WDVH_sendBodyChunk(reply,
							"&nbsp;&nbsp;\
																				</td>\
																			</tr>\
																		</table>\
																	</td>\
																</tr>\
																<tr>\
																	<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																</tr>\
																<!-- Separator -->\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif' height='5'></td>\
																</tr>\
																<!-- LockTimeout  -->\
																<tr>\
																	<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Timeout</td>\
																	<td><img src='/WARoot/Images/1x1.gif' width='5'></td>\
																	<td>\
																		<table border='0' cellpadding='0' cellspacing='1' bgcolor='#666666' width='100%' ID='Table27'>\
																			<tr>\
																				<td colspan='6' valign='bottom' height='16' class='inputreadonly' width='480' nowrap>\
																					&nbsp;&nbsp;");
			sp77sprintf(timeout,49,"%l",lock->timeout);
			WDVH_sendBodyChunk(reply,timeout);
			WDVH_sendBodyChunk(reply,
							"&nbsp;&nbsp;\
																				</td>\
																			</tr>\
																		</table>\
																	</td>\
																</tr>\
																<tr>\
																	<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																<!-- Separator -->\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif' height='5'></td>\
																</tr>\
																<!-- LockToken  -->\
																<tr>\
																	<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Lock Token</td>\
																	<td><img src='/WARoot/Images/1x1.gif' width='5'></td>\
																	<td>\
																		<table border='0' cellpadding='0' cellspacing='1' bgcolor='#666666' width='100%' ID='Table28'>\
																			<tr>\
																				<td colspan='6' valign='bottom' height='16' class='inputreadonly' width='480' nowrap>\
																					&nbsp;&nbsp;");
			WDVH_sendBodyChunk(reply,locktoken);
			WDVH_sendBodyChunk(reply,
							"&nbsp;&nbsp;\
																				</td>\
																			</tr>\
																		</table>\
																	</td>\
																</tr>\
																<tr>\
																	<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																<!-- Separator -->\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
																</tr>\
															</table>\
														</td>\
													</tr>\
												</table>\
											</td>\
										</tr>\
									</table>\
								</td>");
		}
		WDVH_sendBodyChunk(reply,
						"</tr>\
						</table>\
						<!-- Separator -->\
						<table bgcolor='#ffffff' border='0' cellpadding='0' cellspacing='0' width='100%' ID='Table20'>\
							<tr>\
								<td><img src='/WARoot/Images/1x1.gif' height='20'></td>\
							</tr>\
						</table>\
					<!-- Toolbar -->\
					<table border='0' cellpadding='0' cellspacing='0' bgcolor='#FFFFFF' width='100%' ID='Table10'>\
						<tr>\
							<td>\
								<table border='0' cellpadding='0' cellspacing='0' bgcolor='#ffffff' ID='Table9'>\
									<tr>\
										<td><img src='/WARoot/Images/1x1.gif' width='1'></td>\
										<td align='right'><img src='/WARoot/Images/xml_btnl1.gif'></td>\
										<td background='/WARoot/Images/xml_btnb1.gif' align='middle' class='button3' nowrap>\
											&nbsp;&nbsp;<a href='");
		WDVH_sendBodyChunk(reply,
						server);
		WDVH_sendBodyChunk(reply,
						prefix);
		WDVH_sendBodyChunk(reply,
						location);
		WDVH_sendBodyChunk(reply,
						"' class='buttonemph'>Back</a>&nbsp;&nbsp;\
										</td>\
										<td><img src='/WARoot/Images/xml_btnr1.gif'></td>\
									</tr>\
								</table>\
							</td>\
						</tr>\
					</table>\
					<!-- Separator -->\
					<table border='0' cellpadding='0' cellspacing='0' bgcolor='#ffffff' width='100%' ID='Table22'>\
						<tr>\
							<td><img src='/WARoot/Images/1x1.gif' height='5'></td>\
						</tr>\
					</table>\
				</td>\
			</tr>\
		</table>\
	</form>\
</body>");

		WDVH_sendBodyChunkEnd(reply);

		if (server) {
			WDVHandler_Free((sapdbwa_UInt1*) server);
		}
	}

	/*------------------------------------------------------------------------
		Function:	GetBuildReply
	--------------------------------------------------------------------------*/
	void getBuildExplorerReply(sapdbwa_Handle wa,
							   sapdbwa_HttpRequestP request,
							   sapdbwa_HttpReplyP reply,
							   WDVCAPI_WDV	pCapiHandle,
							   WDVH_Handle	wdvhHandle,
							   WDVH_Char	*resource,
							   WDVH_Char    *location,
							   WDVH_Char	*locktoken,
							   WDVCAPI_LockHandle lock)
	{

		WDVH_Char					prefix[WDVH_MAX_URI_LEN+1];
		WDVH_Char					*server;
		WDVCAPI_PropertyShortValueBuffer	childcols;
		WDVCAPI_PropertyShortValueBuffer	childres;
		WDVCAPI_PropertyShortValueBuffer	treesize;
		WDVH_Char							size[30];
		WDVH_Char									timeout[50];

		strcpy(timeout,"");
		strcpy(size,"");

		/* get server string for error messages */
		buildServerString(request,&server);
		/* set server prefix */
		getWebDAVPrefix(wa,prefix);

		/* initialize Response Header */
		sapdbwa_InitHeader(reply,
                           ERROR_200,
                           "text/html",
                           NULL,
	                       NULL,								/* const char    *LastModified,*/
                           NULL,								/* const char    *Expires,*/
                           NULL);								/* const char    *Location );*/

		sapdbwa_SetHeader(reply,
						"Transfer-Encoding",
						"chunked");
		sapdbwa_SetHeader ( reply, "Expires", "Sat, 01 Jan 1990 00:00:00 GMT");
		sapdbwa_SendHeader(reply);

		/* build Body */
		WDVCAPI_GetCollectionProperties(pCapiHandle,childcols,childres,treesize);
		if (strcmp(childcols,"")==0)
			strcpy(childcols,"0");
		if (strcmp(childres,"")==0)
			strcpy(childres,"0");
		if (strcmp(treesize,"")==0)
			strcpy(treesize,"0");

		WDVH_sendBodyChunk(reply,
						"<head><meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1'><link rel='stylesheet' href='/WARoot/Styles/WDVHandler_Stylesheet.css' type='text/css'></head><body topmargin='0' leftmargin='0'><form action='' method='post' name='showXie' ID='Form1'><table border='0' cellpadding='0' cellspacing='0' ID='Table1'><tr><td>&nbsp;&nbsp;&nbsp;</td><td class='text'><h1>Properties of ");
		WDVH_sendBodyChunk(reply,
						resource);
		WDVH_sendBodyChunk(reply,
						"</h1></td>		\
			<tr>\
				<td>&nbsp;&nbsp;&nbsp;</td>\
				<td>\
					<table border='0' cellpadding='0' cellspacing='0' width='10%' ID='Table2'>\
						<tr>\
							<td>\
								<!-- Separator -->\
								<table border='0' cellpadding='0' cellspacing='0' ID='Table7'>\
									<tr>\
										<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
									</tr>\
								</table>");
		WDVH_sendBodyChunk(reply,
						"<!-- GroupboxTitle -->\
								<table border='0' cellpadding='0' cellspacing='0' bgcolor='#CBD5E1' width='100%' ID='Table3'>\
									<tr>\
										<td class='groupheader'><img src='/WARoot/Images/1x1.gif' height='5' width='500'></td>\
									</tr>\
									<tr>\
										<td nowrap class='groupheader'>&nbsp;&nbsp;Collection Properties&nbsp;</td>\
									</tr>\
									<tr>\
										<td class='groupheader'><img src='/WARoot/Images/1x1.gif' height='5' width='500'></td>\
									</tr>\
								</table>\
								<!-- Separator -->\
								<table border='0' cellpadding='0' cellspacing='0' ID='Table4'>\
									<tr>\
										<td><img src='/WARoot/Images/1x1.gif' height='1'></td>\
									</tr>\
								</table>");
		WDVH_sendBodyChunk(reply,
						"<table border='0' cellpadding='0' cellspacing='1' bgcolor='#DCE3EC' width='100%' ID='Table8'>\
									<tr>\
										<td>\
											<!-- Separator -->\
											<table bgcolor='#ffffff' border='0' cellpadding='0' cellspacing='0' width='100%' ID='Table11'>\
												<tr>\
													<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
												</tr>\
											</table>\
											<table border='0' cellpadding='0' cellspacing='0' bgcolor='#ffffff' width='100%' ID='Table5'>\
												<tr>\
													<td><img src='/WARoot/Images/1x1.gif' width='20'></td>\
													<td class='text'>\
														<table border='0' cellpadding='0' cellspacing='0' ID='Table6'>\
															<tr><td><img src='/WARoot/Images/1x1.gif' width='150' height='1'></td></tr>\
															<tr>\
																<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Contained Files</td>\
																<td><img src='/WARoot/Images/1x1.gif' width='10'></td>\
																<td>\
																	<table border='0' cellpadding='0' cellspacing='1' bgcolor='#666666' width='100%' ID='Table12'>\
																		<tr>\
																			<td colspan='6' valign='bottom' height='16' class='inputreadonly' width='480' nowrap>\
																				&nbsp;&nbsp;");
		WDVH_sendBodyChunk(reply,
						childres);
		WDVH_sendBodyChunk(reply,
						"&nbsp;&nbsp;\
																			</td>\
																		</tr>\
																	</table>\
																</td>\
																<td><img src='/WARoot/Images/1x1.gif' width='20'></td>\
															</tr>\
															<tr>\
																<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>\
															<!-- Separator -->\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif' height='5'></td>\
															</tr>\
															<!-- Serer Name -->\
															<tr>\
																<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Contained Folders</td>\
																<td><img src='/WARoot/Images/1x1.gif' width='10'></td>\
																<td>\
																	<table border='0' cellpadding='0' cellspacing='1' bgcolor='#666666' width='100%' ID='Table13'>\
																		<tr>\
																			<td colspan='6' valign='bottom' height='16' class='inputreadonly' width='100%' nowrap>\
																				&nbsp;&nbsp;");
		WDVH_sendBodyChunk(reply,
						childcols);
		WDVH_sendBodyChunk(reply,
						"&nbsp;&nbsp;\
																			</td>\
																		</tr>\
																	</table>\
																</td>\
																<td><img src='/WARoot/Images/1x1.gif' width='20'></td>\
															</tr>\
															<tr>\
																<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>\
															<!-- Separator -->\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif' height='5'></td>\
															</tr>\
															<!-- Description  -->\
															<tr>\
																<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Size</td>\
																<td><img src='/WARoot/Images/1x1.gif' width='10'></td>\
																<td>\
																	<table border='0' cellpadding='0' cellspacing='1' bgcolor='#666666' width='100%' ID='Table14'>\
																		<tr>\
																			<td colspan='6' valign='bottom' height='16' class='inputreadonly' width='100%' nowrap>\
																				&nbsp;&nbsp;");
		transformFileSize(treesize,size,WDVH_True);
		WDVH_sendBodyChunk(reply,
						size);
		WDVH_sendBodyChunk(reply,
						"&nbsp;&nbsp;\
																			</td>\
																		</tr>\
																	</table>\
																</td>\
															</tr>\
															<tr>\
																<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>\
															<!-- Separator -->\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
															</tr>\
														</table>\
													</td>\
												</tr>\
											</table>\
										</td>\
									</tr>\
								</table>\
							</td>");
		if (strcmp(locktoken,"")!=0) {
			WDVH_sendBodyChunk(reply,
							"<tr>\
								<td>\
									<!-- Separator -->\
									<table border='0' cellpadding='0' cellspacing='0' ID='Table16'>\
										<tr>\
											<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
										</tr>\
									</table>\
									<!-- GroupboxTitle -->\
									<table border='0' cellpadding='0' cellspacing='0' bgcolor='#CBD5E1' width='100%' ID='Table17'>\
										<tr>\
											<td class='groupheader'><img src='/WARoot/Images/1x1.gif' height='5' width='500'></td>\
										</tr>\
										<tr>\
											<td nowrap class='groupheader'>&nbsp;&nbsp;WebDAV Lock Properties&nbsp;</td>\
										</tr>\
										<tr>\
											<td class='groupheader'><img src='/WARoot/Images/1x1.gif' height='5' width='500'></td>\
										</tr>\
									</table>\
									<!-- Separator -->\
									<table border='0' cellpadding='0' cellspacing='0' ID='Table18'>\
										<tr>\
											<td><img src='/WARoot/Images/1x1.gif' height='1'></td>\
										</tr>\
									</table>");
			WDVH_sendBodyChunk(reply,
							"<table border='0' cellpadding='0' cellspacing='1' bgcolor='#DCE3EC' ID='Table19'>\
										<tr>\
											<td>\
												<!-- Separator -->\
												<table bgcolor='#ffffff' border='0' cellpadding='0' cellspacing='0' width='100%' ID='Table20'>\
													<tr>\
														<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
													</tr>\
												</table>\
												<table border='0' cellpadding='0' cellspacing='0' bgcolor='#ffffff' width='100%' ID='Table21'>\
													<tr>\
														<td><img src='/WARoot/Images/1x1.gif' width='20'></td>\
														<td class='text'>\
															<table border='0' cellpadding='0' cellspacing='0' width='100%' ID='Table23'>\
																<tr><td><img src='/WARoot/Images/1x1.gif' width='150' height='1'></td></tr>\
																<tr>\
																	<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Lock Type</td>\
																	<td><img src='/WARoot/Images/1x1.gif' width='10'></td>\
																	<td>\
																		<table border='0' cellpadding='0' cellspacing='1' bgcolor='#666666' width='100%' ID='Table24'>\
																			<tr>\
																				<td colspan='6' valign='bottom' height='16' class='inputreadonly' width='480' nowrap>\
																					&nbsp;&nbsp;");
			if (lock->type == WDVCAPI_LOCK_TYPE_WRITE)
				WDVH_sendBodyChunk(reply,
								"write");
			else
				WDVH_sendBodyChunk(reply,
								" ");
			WDVH_sendBodyChunk(reply,
							"&nbsp;&nbsp;\
																				</td>\
																			</tr>\
																		</table>\
																	</td>\
																	<td><img src='/WARoot/Images/1x1.gif' width='20'></td>\
																</tr>\
																<tr>\
																	<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																<!-- Separator -->\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif' height='5'></td>\
																</tr>\
																<!-- Serer Name -->\
																<tr>\
																	<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Scope</td>\
																	<td><img src='/WARoot/Images/1x1.gif' width='10'></td>\
																	<td>\
																		<table border='0' cellpadding='0' cellspacing='1' bgcolor='#666666' width='100%' ID='Table25'>\
																			<tr>\
																				<td colspan='6' valign='bottom' height='16' class='inputreadonly' width='480' nowrap>\
																					&nbsp;&nbsp;");
			if (lock->scope == WDVCAPI_LOCK_SCOPE_EXCLUSIVE)
				WDVH_sendBodyChunk(reply,
								"exclusive");
			else
				WDVH_sendBodyChunk(reply,
								" ");
			WDVH_sendBodyChunk(reply,
							"&nbsp;&nbsp;\
																				</td>\
																			</tr>\
																		</table>\
																	</td>\
																	<td><img src='/WARoot/Images/1x1.gif' width='20'></td>\
																</tr>\
																<tr>\
																	<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																<!-- Separator -->\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif' height='5'></td>\
																</tr>\
																<!-- Description  -->\
																<tr>\
																	<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Owner</td>\
																	<td><img src='/WARoot/Images/1x1.gif' width='10'></td>\
																	<td>\
																		<table border='0' cellpadding='0' cellspacing='1' bgcolor='#666666' width='100%' ID='Table26'>\
																			<tr>\
																				<td colspan='6' valign='bottom' height='16' class='inputreadonly' width='480' nowrap>\
																					&nbsp;&nbsp;");
			WDVH_sendBodyChunk(reply,
							lock->owner);
			WDVH_sendBodyChunk(reply,
							"&nbsp;&nbsp;\
																				</td>\
																			</tr>\
																		</table>\
																	</td>\
																</tr>\
																<tr>\
																	<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif'></td>\
																<!-- Separator -->\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif' height='5'></td>\
																</tr>\
																<!-- LockDepth  -->\
																<tr>\
																	<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Depth</td>\
																	<td><img src='/WARoot/Images/1x1.gif' width='5'></td>\
																	<td>\
																		<table border='0' cellpadding='0' cellspacing='1' bgcolor='#666666' width='100%' ID='Table29'>\
																			<tr>\
																				<td colspan='6' valign='bottom' height='16' class='inputreadonly' width='480' nowrap>\
																					&nbsp;&nbsp;");
			if (lock->depth == WDVCAPI_DEPTH_0)
				WDVH_sendBodyChunk(reply,
								"0");
			else if (lock->depth == WDVCAPI_DEPTH_1)
				WDVH_sendBodyChunk(reply,
								"1");
			else if (lock->depth == WDVCAPI_DEPTH_INFINITE)
				WDVH_sendBodyChunk(reply,
								"Infinite");
			WDVH_sendBodyChunk(reply,
							"&nbsp;&nbsp;\
																				</td>\
																			</tr>\
																		</table>\
																	</td>\
																</tr>\
																<tr>\
																	<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																</tr>\
																<!-- Separator -->\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif' height='5'></td>\
																</tr>\
																<!-- LockTimeout  -->\
																<tr>\
																	<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Timeout</td>\
																	<td><img src='/WARoot/Images/1x1.gif' width='5'></td>\
																	<td>\
																		<table border='0' cellpadding='0' cellspacing='1' bgcolor='#666666' width='100%' ID='Table27'>\
																			<tr>\
																				<td colspan='6' valign='bottom' height='16' class='inputreadonly' width='480' nowrap>\
																					&nbsp;&nbsp;");
			sp77sprintf(timeout,49,"%l",lock->timeout);
			WDVH_sendBodyChunk(reply,timeout);
			WDVH_sendBodyChunk(reply,
							"&nbsp;&nbsp;\
																				</td>\
																			</tr>\
																		</table>\
																	</td>\
																</tr>\
																<tr>\
																	<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																<!-- Separator -->\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif' height='5'></td>\
																</tr>\
																<!-- LockToken  -->\
																<tr>\
																	<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Lock Token</td>\
																	<td><img src='/WARoot/Images/1x1.gif' width='5'></td>\
																	<td>\
																		<table border='0' cellpadding='0' cellspacing='1' bgcolor='#666666' width='100%' ID='Table28'>\
																			<tr>\
																				<td colspan='6' valign='bottom' height='16' class='inputreadonly' width='480' nowrap>\
																					&nbsp;&nbsp;");
			WDVH_sendBodyChunk(reply,locktoken);
			WDVH_sendBodyChunk(reply,
							"&nbsp;&nbsp;\
																				</td>\
																			</tr>\
																		</table>\
																	</td>\
																</tr>\
																<tr>\
																	<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif'></td>\
																</tr>\
																<!-- Separator -->\
																<tr>\
																	<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
																</tr>\
															</table>\
														</td>\
													</tr>\
												</table>\
											</td>\
										</tr>\
									</table>\
								</td>");
		}
		WDVH_sendBodyChunk(reply,
						"</tr>\
						</table>");
		WDVH_sendBodyChunk(reply,
						"<!-- Separator -->\
						<table bgcolor='#ffffff' border='0' cellpadding='0' cellspacing='0' width='100%' ID='Table20'>\
							<tr>\
								<td><img src='/WARoot/Images/1x1.gif' height='20'></td>\
							</tr>\
						</table>\
						<!-- Toolbar -->\
					<table border='0' cellpadding='0' cellspacing='0' bgcolor='#FFFFFF' width='100%' ID='Table10'>\
						<tr>\
							<td>\
								<table border='0' cellpadding='0' cellspacing='0' bgcolor='#ffffff' ID='Table9'>\
									<tr>\
										<td><img src='/WARoot/Images/1x1.gif' width='1'></td>\
										<td align='right'><img src='/WARoot/Images/xml_btnl1.gif'></td>\
										<td background='/WARoot/Images/xml_btnb1.gif' align='middle' class='button3' nowrap>\
											&nbsp;&nbsp;<a href='");
		WDVH_sendBodyChunk(reply,
						server);
		WDVH_sendBodyChunk(reply,
						prefix);
		WDVH_sendBodyChunk(reply,
						location);
		WDVH_sendBodyChunk(reply,
						"' class='buttonemph'>Back</a>&nbsp;&nbsp;\
										</td>\
										<td><img src='/WARoot/Images/xml_btnr1.gif'></td>\
									</tr>\
								</table>\
							</td>\
						</tr>\
					</table>\
					<!-- Separator -->\
					<table border='0' cellpadding='0' cellspacing='0' bgcolor='#ffffff' width='100%' ID='Table22'>\
						<tr>\
							<td><img src='/WARoot/Images/1x1.gif' height='5'></td>\
						</tr>\
					</table>\
				</td>\
			</tr>\
		</table>\
	</form>\
</body>");

		WDVH_sendBodyChunkEnd(reply);

		if (server) {
			WDVHandler_Free((sapdbwa_UInt1*) server);
		}
	}

	void showXmlProperties(sapdbwa_Handle			wa,
						   sapdbwa_HttpRequestP		request,
						   sapdbwa_HttpReplyP		reply,
						   WDVH_Char				*uri,
						   WDVH_Char				*location,
						   WDVCAPI_WDV				wdv,
						   XMLIMAPI_Handle			xmlHandle,
						   WDVH_Bool				erroroccured,
						   WDVH_Char				*errormsg)
	{
		WDVCAPI_PropertyShortValueBuffer			docclass;
		WDVCAPI_PropertyShortValueBuffer			indexstate;
		XMLIMAPI_Id									docclassid;
		WDVH_Char									prefix[WDVH_MAX_URI_LEN+1];
		WDVH_Char									*server;
		XMLIMAPI_DocClass							docClass;
		WDVCAPI_ErrorItem							errorItem;
		WDVCAPI_ErrorType							errorType;
		WDVCAPI_ErrorCode							errorCode;
		WDVCAPI_ErrorText							errorMsg;
		WDVH_Error									error;
		WDVH_Char									errorText[1000];

		sapdbwa_InitHeader(reply,
						   ERROR_200,
						   "text/html",
						   NULL,
						   NULL,								/* const char    *LastModified,*/
						   NULL,								/* const char    *Expires,*/
						   NULL);								/* const char    *Location );*/
		sapdbwa_SetHeader(reply,
						"Transfer-Encoding",
						"chunked");
		sapdbwa_SendHeader(reply);

		/* get server string for error messages */
		buildServerString(request,&server);
		/* set server prefix */
		getWebDAVPrefix(wa,prefix);

		strcpy(docclass,"");
		strcpy(indexstate,"");
		strcpy(errorText,"");
		if (erroroccured)
			strcpy(errorText,errormsg);
		/* get Xml Properties */
		if (!WDVCAPI_ProppatchGetDocClassProperties(wdv,uri,docclass,indexstate)) {
			if (!erroroccured) {
				/* something went wrong */
				WDVCAPI_GetLastError(wdv,&errorItem);
				WDVCAPI_GetErrorType(errorItem,&errorType);
				switch (errorType) {
					case WDVCAPI_ERR_TYPE_UNDEFINED:
					case WDVCAPI_ERR_TYPE_SQL:
						{
							erroroccured = WDVH_True;
							/* internal server error */
							WDVCAPI_GetErrorText(errorItem,&errorMsg);
							error = ERROR_500;
							sp77sprintf(errorText,1000,ERROR_PROPFIND_URI,server,(char*)sapdbwa_GetRequestURI(request));
							sapdbwa_WriteLogMsg(wa, errorText);
							sp77sprintf(errorText,1000,ERROR_PROPFIND_500,errorMsg);
							sapdbwa_WriteLogMsg(wa, errorText);
							break;
						}
					case WDVCAPI_ERR_TYPE_CAPI:
						{
							WDVCAPI_GetErrorCode(errorItem,&errorCode);
							WDVCAPI_GetErrorText(errorItem,&errorMsg);
							switch(errorCode) {
								case WDVCAPI_ERR_CODE_NO_DOC_CLASS_PROPERTY:
									strcpy(docclass,"");
									strcpy(indexstate,"");
									break;
								default:
									{
										erroroccured = WDVH_True;
										error = ERROR_500;
										sp77sprintf(errorText,1000,ERROR_PROPFIND_URI,server,(char*)sapdbwa_GetRequestURI(request));
										sapdbwa_WriteLogMsg(wa, errorText);
										sp77sprintf(errorText,1000,ERROR_PROPFIND_500,errorMsg);
										sapdbwa_WriteLogMsg(wa, errorText);
										break;
									}
							}
							break;
						}
					default:
						{
							erroroccured = WDVH_True;
							WDVCAPI_GetErrorText(errorItem,&errorMsg);
							error = ERROR_500;
							sp77sprintf(errorText,1000,ERROR_PROPFIND_URI,server,(char*)sapdbwa_GetRequestURI(request));
							sapdbwa_WriteLogMsg(wa, errorText);
							sp77sprintf(errorText,1000,ERROR_PROPFIND_500,errorMsg);
							sapdbwa_WriteLogMsg(wa, errorText);
							break;
						}
				}
			}
		} else {
			error = ERROR_200;
		}

		/* build reply body */
		WDVH_sendBodyChunk(reply,
						"<head>\
	<meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1'>\
	<link rel='stylesheet' href='/WARoot/Styles/WDVHandler_Stylesheet.css' type='text/css'>\
		<script language='javascript'>\
		function update()\
		{\
			document.showXmlProps.action = '");
		WDVH_sendBodyChunk(reply,prefix);
		WDVH_sendBodyChunk(reply,
						"?explorer=0&cmd=SetXmlProps';\
			document.showXmlProps.target = 'Client';\
			document.showXmlProps.submit();\
		}\
		</script>\
</head>\
<body topmargin='0' leftmargin='0'>\
	<form action='' method='post' name='showXmlProps' ID='Form1'>\
		<input type='hidden' name='DocClassOld' value='");
		WDVH_sendBodyChunk(reply,docclass);
		WDVH_sendBodyChunk(reply,
						"'>\
		<input type='hidden' name='res' value='");
		WDVH_sendBodyChunk(reply,server);
		WDVH_sendBodyChunk(reply,prefix);
		WDVH_sendBodyChunk(reply,uri);
		WDVH_sendBodyChunk(reply,
						"'>\
		<input type='hidden' name='location' value='");
		WDVH_sendBodyChunk(reply,location);
		WDVH_sendBodyChunk(reply,
						"'>\
		<table border='0' cellpadding='0' cellspacing='0' ID='Table1'>\
			<tr>\
				<td>&nbsp;&nbsp;&nbsp;</td>\
				<td class='text'><h1>Properties of ");
		WDVH_sendBodyChunk(reply,
						uri);
		WDVH_sendBodyChunk(reply,
						"</h1>");
		if (strcmp(indexstate,"")==0 || strcmp(indexstate,XMLINDEXING_STATE_NEW_AS_STRING)==0 || strcmp(indexstate,XMLINDEXING_STATE_FINISHED_AS_STRING)==0) {
			WDVH_sendBodyChunk(reply,
							"</td>");
		} else {
			WDVH_sendBodyChunk(reply,
							"<h4><font class='inputlabelreq'>Resource is beeing indexed. No change of Document Class or triggering of re-indexing allowed. Please wait until the resource is unlocked.</font></h4></td>");
		}
		WDVH_sendBodyChunk(reply,
						"<tr>\
					<td>&nbsp;&nbsp;&nbsp;</td>\
					<td>\
						<table border='0' cellpadding='0' cellspacing='0' width='10%' ID='Table2'>\
							<tr>\
								<td>\
									<!-- Separator -->\
									<table border='0' cellpadding='0' cellspacing='0' ID='Table7'>\
										<tr>\
											<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
										</tr>\
									</table>\
									<!-- GroupboxTitle -->\
									<table border='0' cellpadding='0' cellspacing='0' bgcolor='#CBD5E1' width='100%' ID='Table3'>\
										<tr>\
											<td class='groupheader'><img src='/WARoot/Images/1x1.gif' height='5' width='500'></td>\
										</tr>\
										<tr>\
											<td nowrap class='groupheader'>&nbsp;&nbsp;XML Indexing Properties&nbsp;</td>\
										</tr>\
										<tr>\
											<td class='groupheader'><img src='/WARoot/Images/1x1.gif' height='5' width='500'></td>\
										</tr>\
									</table>\
									<!-- Separator -->\
									<table border='0' cellpadding='0' cellspacing='0' ID='Table4'>\
										<tr>\
											<td><img src='/WARoot/Images/1x1.gif' height='1'></td>\
										</tr>\
									</table>");
		WDVH_sendBodyChunk(reply,
						"<table border='0' cellpadding='0' cellspacing='1' bgcolor='#DCE3EC' ID='Table8'>\
									<tr>\
										<td>\
											<!-- Separator -->\
											<table bgcolor='#ffffff' border='0' cellpadding='0' cellspacing='0' width='100%' ID='Table11'>\
												<tr>\
													<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
												</tr>\
											</table>\
											<table border='0' cellpadding='0' cellspacing='0' bgcolor='#ffffff' ID='Table5'>\
												<tr>\
													<td><img src='/WARoot/Images/1x1.gif' width='20'></td>\
													<td class='text'>\
														<table border='0' cellpadding='0' cellspacing='0' ID='Table6'>\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif' width='150' height='1'></td>\
															</tr>\
															<tr>\
																<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Document \
																	Class</td>\
																<td><img src='/WARoot/Images/1x1.gif' width='10'></td>\
																<td>");
		if (strcmp(indexstate,"")==0 || strcmp(indexstate,XMLINDEXING_STATE_NEW_AS_STRING)==0 || strcmp(indexstate,XMLINDEXING_STATE_FINISHED_AS_STRING)==0) {
			WDVH_sendBodyChunk(reply,
							"<select name='DocClass' value='' class='text'>\
																		<option value=''>&lt;No Document \
																			Class assigned&gt;</option>");
			if (XMLIMAPI_DocClassGetFirst(xmlHandle,&docClass)) {
				do {
					WDVH_sendBodyChunk(reply,"<option value='");
					WDVH_sendBodyChunk(reply,docClass.docClassID);
					if (strcmp(docclass,docClass.docClassID)==0) {
						WDVH_sendBodyChunk(reply,"' selected >");
					} else {
						WDVH_sendBodyChunk(reply,"'>");
					}
					WDVH_sendBodyChunk(reply,docClass.docClassName);
					WDVH_sendBodyChunk(reply,"</option>");
				} while (XMLIMAPI_DocClassGetNext(xmlHandle,&docClass));
			}
			WDVH_sendBodyChunk(reply,"</select>");
		} else {
			WDVH_sendBodyChunk(reply,
							"<table border='0' cellpadding='0' cellspacing='1' bgcolor='#666666' width='100%'>\
																		<tr>\
																			<td colspan='6' valign='bottom' height='16' class='inputreadonly' width='450' nowrap>\
																				&nbsp;&nbsp;");
			XMLIMAPI_IdStringAsId(docclass,docclassid);
			XMLIMAPI_DocClassGetName(xmlHandle,docclassid,docclass);
			WDVH_sendBodyChunk(reply,
							docclass);
			WDVH_sendBodyChunk(reply,
							"&nbsp;&nbsp;</td></tr></table>");
		}
		WDVH_sendBodyChunk(reply,
						"</td>\
																<td><img src='/WARoot/Images/1x1.gif' width='20'></td>\
															</tr>\
															<tr>\
																<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>\
															<!-- Separator -->\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif' height='5'></td>\
															</tr>\
															<!-- Serer Name -->\
															<tr>\
																<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Indexing \
																	Status</td>\
																<td><img src='/WARoot/Images/1x1.gif' width='10'></td>\
																<td>\
																	<table border='0' cellpadding='0' cellspacing='1' bgcolor='#666666' width='100%' ID='Table13'>\
																		<tr>\
																			<td colspan='6' valign='bottom' height='16' class='inputreadonly' width='450' nowrap>\
																				&nbsp;&nbsp;");
		WDVH_sendBodyChunk(reply,
						indexstate);
		WDVH_sendBodyChunk(reply,
						"&nbsp;&nbsp;\
																			</td>\
																		</tr>\
																	</table>\
																</td>\
																<td><img src='/WARoot/Images/1x1.gif' width='20'></td>\
															</tr>\
															<tr>\
																<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>");
		if ((strcmp(indexstate,"")==0 || strcmp(indexstate,XMLINDEXING_STATE_NEW_AS_STRING)==0 || strcmp(indexstate,XMLINDEXING_STATE_FINISHED_AS_STRING)==0)&&(strcmp(docclass,"")!=0)) {
			WDVH_sendBodyChunk(reply,
							"<!-- Separator -->\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif' height='5'></td>\
															</tr>\
															<!-- Serer Name -->\
															<tr>\
																<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Trigger \
																	Reindexing</td>\
																<td><img src='/WARoot/Images/1x1.gif' width='10'></td>\
																<td>\
																	<input type='checkbox' name='ReIndex'>\
																</td>\
																<td><img src='/WARoot/Images/1x1.gif' width='20'></td>\
															</tr>\
															<tr>\
																<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>");
		}
		WDVH_sendBodyChunk(reply,
						"<!-- Separator -->\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
															</tr>\
														</table>\
													</td>\
												</tr>\
											</table>\
										</td>\
									</tr>\
								</table>\
							</td>\
						</tr>\
					</table>\
					<!-- Separator -->\
					<table bgcolor='#ffffff' border='0' cellpadding='0' cellspacing='0' width='100%' ID='Table20'>\
						<tr>\
							<td><img src='/WARoot/Images/1x1.gif' height='20'></td>\
						</tr>\
					</table>\
					<!-- Toolbar -->\
					<table border='0' cellpadding='0' cellspacing='0' bgcolor='#FFFFFF' width='100%' ID='Table10'>\
						<tr>\
							<td>\
								<table border='0' cellpadding='0' cellspacing='0' bgcolor='#ffffff' ID='Table9'>\
									<tr><td><img src='/WARoot/Images/1x1.gif' width='1'></td>");
		if (strcmp(indexstate,"")==0 || strcmp(indexstate,XMLINDEXING_STATE_NEW_AS_STRING)==0 || strcmp(indexstate,XMLINDEXING_STATE_FINISHED_AS_STRING)==0) {
			WDVH_sendBodyChunk(reply,
							"<td align='right'><img src='/WARoot/Images/xml_btnl1.gif'></td>\
											<td background='/WARoot/Images/xml_btnb1.gif' align='middle' class='button3' nowrap>\
												&nbsp;&nbsp;<a href='javascript:update()' class='buttonemph'>Update</a>&nbsp;&nbsp;\
											</td>\
											<td><img src='/WARoot/Images/xml_btnr1.gif'></td>\
											<td><img src='/WARoot/Images/1x1.gif' width='10'></td>");
		}
		WDVH_sendBodyChunk(reply,
						"<td align='right'><img src='/WARoot/Images/xml_btnl1.gif'></td>\
										<td background='/WARoot/Images/xml_btnb1.gif' align='middle' class='button3' nowrap>\
											&nbsp;&nbsp;<a href='");
		WDVH_sendBodyChunk(reply,
						server);
		WDVH_sendBodyChunk(reply,
						prefix);
		WDVH_sendBodyChunk(reply,
						location);
		WDVH_sendBodyChunk(reply,
						"' class='buttonemph'>Cancel</a>&nbsp;&nbsp;\
										</td>\
										<td><img src='/WARoot/Images/xml_btnr1.gif'></td>\
									</tr>\
								</table>\
							</td>\
						</tr>\
					</table>");
		if (erroroccured) {
			WDVH_sendBodyChunk(reply,
							"<!-- Separator -->\
					<table border='0' cellpadding='0' cellspacing='0' bgcolor='#ffffff' width='100%'>\
						<tr>\
							<td><img src='/WARoot/Images/1x1.gif' height='25'></td>\
						</tr>\
					</table>\
					<table border='0' cellpadding='0' cellspacing='0' width='10%'>\
						<tr>\
							<td>\
								<!-- Separator -->\
								<table border='0' cellpadding='0' cellspacing='0'>\
									<tr>\
										<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
									</tr>\
								</table>\
								<!-- GroupboxTitle -->\
								<table border='0' cellpadding='0' cellspacing='0' bgcolor='#CBD5E1' width='100%'>\
									<tr>\
										<td class='groupheader'><img src='/WARoot/Images/1x1.gif' height='5' width='660'></td>\
									</tr>\
									<tr>\
										<td nowrap class='groupheader'>&nbsp;&nbsp;Error&nbsp;</td>\
									</tr>\
									<tr>\
										<td class='groupheader'><img src='/WARoot/Images/1x1.gif' height='5' width='660'></td>\
									</tr>\
								</table>");
			WDVH_sendBodyChunk(reply,
							"<!-- Separator -->\
								<table border='0' cellpadding='0' cellspacing='0'>\
									<tr>\
										<td><img src='/WARoot/Images/1x1.gif' height='1'></td>\
									</tr>\
								</table>\
								<table border='0' cellpadding='0' cellspacing='1' bgcolor='#DCE3EC' width='100%'>\
									<tr>\
										<td>\
											<!-- Separator -->\
											<table bgcolor='#ffffff' border='0' cellpadding='0' cellspacing='0' width='100%'>\
												<tr>\
													<td><img src='/WARoot/Images/1x1.gif' height='5'</td>\
												</tr>\
											</table>\
											<table border='0' cellpadding='0' cellspacing='0' bgcolor='#ffffff' width='100%'>\
												<tr>\
													<td class='text'>&nbsp;&nbsp;<img src='/WARoot/Images/xml_msgerrosmall.gif' border='0'>&nbsp;");
			WDVH_sendBodyChunk(reply,
							errorText);
			WDVH_sendBodyChunk(reply,
							"&nbsp;&nbsp;</td>\
												</tr>\
											</table>\
											<!-- Separator -->\
											<table bgcolor='#ffffff' border='0' cellpadding='0' cellspacing='0' width='100%'>\
												<tr>\
													<td><img src='/WARoot/Images/1x1.gif' height='5'</td>\
												</tr>\
											</table>\
										</td>\
									</tr>\
								</table>\
							</td>\
						</tr>\
					</table>");
		}
		WDVH_sendBodyChunk(reply,
					"<!-- Separator -->\
					<table border='0' cellpadding='0' cellspacing='0' bgcolor='#ffffff' width='100%' ID='Table22'>\
						<tr>\
							<td><img src='/WARoot/Images/1x1.gif' height='5'></td>\
						</tr>\
					</table>\
				</td>\
			</tr>\
		</table>\
	</form>\
</body>");

		WDVH_sendBodyChunkEnd(reply);

		if (server) {
			WDVHandler_Free((sapdbwa_UInt1*) server);
		}
	}

	void collectionLockProps(sapdbwa_Handle			wa,
							 WDVH_Char				*uri,
							 WDVH_Char				*location,
							 WDVCAPI_WDV			wdv,
							 WDVCAPI_PropfindHandle propfind,
							 WDVH_Char				*locktoken,
					 		 WDVCAPI_LockHandle		*lock)
	{
		WDVCAPI_PropfindPropertyName				propertyName;
		WDVCAPI_PropfindPropertyShortValue			propertyShortValue;
		WDVCAPI_PropfindNameSpace					propfindNamespace;
		WDVCAPI_PropfindNameSpaceShortcut			propertyNamespaceShortcut;
		WDVCAPI_PropfindNameSpaceShortcut			davPropertyNamespaceShortcut = NULL;
		WDVH_XmlNamespaceList						namespaceList;
		WDVH_XmlNamespace							ns;

		/* build namespace list */
		if (!xmlParserCreateNamespaceList(NULL, &namespaceList)) {
		}
		if (WDVCAPI_PropfindGetFirstNameSpace(wdv,propfind,&propertyNamespaceShortcut,&propfindNamespace)) {
			do {
                /* Find out wich shortcut belongs to DAV: */
                if (!davPropertyNamespaceShortcut && strcmp(propfindNamespace, "DAV:") == 0) {
                    /* Shortcut found, so we have to memorize shortcut for later use */
                    davPropertyNamespaceShortcut = propertyNamespaceShortcut;
                }
				strcpy(ns.prefix,propertyNamespaceShortcut);
				strcpy(ns.uri,propfindNamespace);
				xmlParserAddNamespaceToList(NULL,ns,namespaceList);
			} while(WDVCAPI_PropfindGetNextNameSpace(wdv,propfind,&propertyNamespaceShortcut,&propfindNamespace));
		} else {
		}

		/* loop at properties */
		if (WDVCAPI_PropfindGetFirstProperty(wdv,propfind)) {
			do {
				if (WDVCAPI_PropfindGetPropertyName(wdv,propfind,&propertyName )) {
					WDVCAPI_PropfindGetPropertyNameSpaceShortcut(wdv,propfind,&propertyNamespaceShortcut);
					WDVCAPI_PropfindGetPropertyShortValue(wdv,propfind,&propertyShortValue);
					/* property lockdiscovery has to collect additional data */
					if (strcmp(propertyName,WDVH_XML_LOCKDISCOVERY)==0) {
						if (WDVCAPI_IdStringIsInitialValue(propertyShortValue)) {
							sp77sprintf(locktoken,100,"");
						} else {
							sp77sprintf(locktoken,100,"saplocktoken:%s",propertyShortValue);
							WDVCAPI_PropfindGetLockDescription(wdv,propfind,propertyShortValue,lock);
						}
					}
				}
			} while(WDVCAPI_PropfindGetNextProperty(wdv,propfind));
		}
	}

	void restoreScreen(sapdbwa_Handle			wa,
						   sapdbwa_HttpRequestP		request,
						   sapdbwa_HttpReplyP		reply,
						   WDVH_Char				*uri,
						   WDVH_Char				*location,
						   WDVCAPI_WDV				wdv,
						   WDVH_Bool				erroroccured,
						   WDVH_Char				*errormsg)
	{
		WDVH_Char									prefix[WDVH_MAX_URI_LEN+1];
		WDVH_Char									__destination[WDVH_MAX_URI_LEN+1];
		WDVH_Char									*server;
		WDVH_Char									__temp[WDVH_MAX_URI_LEN+1];
		WDVCAPI_ErrorItem							__errorItem;
		WDVCAPI_ErrorType							__errorType;
		WDVCAPI_ErrorCode							__errorCode;

		sapdbwa_InitHeader(reply,
						   ERROR_200,
						   "text/html",
						   NULL,
						   NULL,								/* const char    *LastModified,*/
						   NULL,								/* const char    *Expires,*/
						   NULL);								/* const char    *Location );*/
		sapdbwa_SetHeader(reply,
						"Transfer-Encoding",
						"chunked");
		sapdbwa_SendHeader(reply);

		/* get server string for error messages */
		buildServerString(request,&server);
		/* set server prefix */
		getWebDAVPrefix(wa,prefix);

		if (!getParameterValue("DestinationURI",request,__destination))
			strcpy(__destination,"");

		/* build reply body */
		WDVH_sendBodyChunk(reply,
						"<head>\
	<meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1'>\
	<link rel='stylesheet' href='/WARoot/Styles/WDVHandler_Stylesheet.css' type='text/css'>\
		<script language='javascript'>\
		function restore()\
		{\
			document.showXmlProps.action = '");
		WDVH_sendBodyChunk(reply,prefix);
		WDVH_sendBodyChunk(reply,
						"?explorer=0&cmd=Restore';\
			document.showXmlProps.target = '_self';\
			document.showXmlProps.submit();\
		}\
		</script>\
</head>\
<body topmargin='0' leftmargin='0'>\
	<form action='' method='post' name='showXmlProps' ID='Form1'>\
		<input type='hidden' name='res' value='");
		WDVH_sendBodyChunk(reply,server);
		WDVH_sendBodyChunk(reply,prefix);
		WDVH_sendBodyChunk(reply,uri);
		WDVH_sendBodyChunk(reply,
						"'>\
		<input type='hidden' name='location' value='");
		WDVH_sendBodyChunk(reply,location);
		WDVH_sendBodyChunk(reply,
						"'>\
		<table border='0' cellpadding='0' cellspacing='0' ID='Table1'>\
			<tr>\
				<td>&nbsp;&nbsp;&nbsp;</td>\
				<td class='text'><h1>Restore ");
		WDVH_sendBodyChunk(reply,
						uri);
		WDVH_sendBodyChunk(reply,
						"</h1>");
		WDVH_sendBodyChunk(reply,
						"<tr>\
					<td>&nbsp;&nbsp;&nbsp;</td>\
					<td>\
						<table border='0' cellpadding='0' cellspacing='0' width='10%' ID='Table2'>\
							<tr>\
								<td>\
									<!-- Separator -->\
									<table border='0' cellpadding='0' cellspacing='0' ID='Table7'>\
										<tr>\
											<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
										</tr>\
									</table>\
									<!-- GroupboxTitle -->\
									<table border='0' cellpadding='0' cellspacing='0' bgcolor='#CBD5E1' width='100%' ID='Table3'>\
										<tr>\
											<td class='groupheader'><img src='/WARoot/Images/1x1.gif' height='5' width='500'></td>\
										</tr>\
										<tr>\
											<td nowrap class='groupheader'>&nbsp;&nbsp;Location&nbsp;</td>\
										</tr>\
										<tr>\
											<td class='groupheader'><img src='/WARoot/Images/1x1.gif' height='5' width='500'></td>\
										</tr>\
									</table>\
									<!-- Separator -->\
									<table border='0' cellpadding='0' cellspacing='0' ID='Table4'>\
										<tr>\
											<td><img src='/WARoot/Images/1x1.gif' height='1'></td>\
										</tr>\
									</table>");
		WDVH_sendBodyChunk(reply,
						"<table border='0' cellpadding='0' cellspacing='1' bgcolor='#DCE3EC' ID='Table8'>\
									<tr>\
										<td>\
											<!-- Separator -->\
											<table bgcolor='#ffffff' border='0' cellpadding='0' cellspacing='0' width='100%' ID='Table11'>\
												<tr>\
													<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
												</tr>\
											</table>\
											<table border='0' cellpadding='0' cellspacing='0' bgcolor='#ffffff' ID='Table5'>\
												<tr>\
													<td><img src='/WARoot/Images/1x1.gif' width='20'></td>\
													<td class='text'>\
														<table border='0' cellpadding='0' cellspacing='0' ID='Table6'>\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif' width='150' height='1'></td>\
															</tr>\
															<tr>\
																<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Restore to</td>\
																<td><img src='/WARoot/Images/1x1.gif' width='10'></td>\
																<td>\
																<input name=\"DestinationURI\" type=\"text\" size=\"75\" maxlength=\"512\" value=\"");
		if (strcmp(__destination,"")==0) {
			/* use the original location */
			if (!WDVCAPI_PropfindOriginalLocation(wdv,uri,__temp)) {
				WDVCAPI_GetLastError(wdv,&__errorItem);
				WDVCAPI_GetErrorType(__errorItem,&__errorType);
				switch (__errorType) {
					case WDVCAPI_ERR_TYPE_UNDEFINED:
					case WDVCAPI_ERR_TYPE_SQL:
					case WDVCAPI_ERR_TYPE_CAPI:
						sp77sprintf(__destination,WDVH_MAX_URI_LEN,"<Enter the path of the location this resource is moved to>");
				}
			} else {
				if (strcmp(__temp,"/")==0)
					sp77sprintf(__destination,WDVH_MAX_URI_LEN,"%s",strrchr(uri,'/'));
				else
					sp77sprintf(__destination,WDVH_MAX_URI_LEN,"%s%s",__temp,strrchr(uri,'/'));
			}
		}
		WDVH_sendBodyChunk(reply,__destination);
		WDVH_sendBodyChunk(reply,
						"\"></td>\
																<td><img src='/WARoot/Images/1x1.gif' width='20'></td>\
															</tr>\
															<tr>\
																<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>");
		WDVH_sendBodyChunk(reply,
						"<!-- Separator -->\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
															</tr>\
														</table>\
													</td>\
												</tr>\
												<tr>\
													<td><img src='/WARoot/Images/1x1.gif' width='20'></td>\
													<td class='text'>\
														<table border='0' cellpadding='0' cellspacing='0' ID='Table6'>\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif' width='150' height='1'></td>\
															</tr>\
															<tr>\
																<td valign='bottom' nowrap height='25' class='inputlabel' align='absmiddle'><img src='/WARoot/Images/xml_labelnotch.gif'>Overwrite</td>\
																<td><img src='/WARoot/Images/1x1.gif' width='10'></td>\
																<td>\
																<input name=\"Overwrite\" type=\"checkbox\">");
		WDVH_sendBodyChunk(reply,
						"</td>\
																<td><img src='/WARoot/Images/1x1.gif' width='20'></td>\
															</tr>\
															<tr>\
																<td colspan='2' bgcolor='#ffffff'><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif'></td>\
															</tr>");
		WDVH_sendBodyChunk(reply,
						"<!-- Separator -->\
															<tr>\
																<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
															</tr>\
														</table>\
													</td>\
												</tr>\
											</table>\
										</td>\
									</tr>\
								</table>\
							</td>\
						</tr>\
					</table>\
					<!-- Separator -->\
					<table bgcolor='#ffffff' border='0' cellpadding='0' cellspacing='0' width='100%' ID='Table20'>\
						<tr>\
							<td><img src='/WARoot/Images/1x1.gif' height='20'></td>\
						</tr>\
					</table>\
					<!-- Toolbar -->\
					<table border='0' cellpadding='0' cellspacing='0' bgcolor='#FFFFFF' width='100%' ID='Table10'>\
						<tr>\
							<td>\
								<table border='0' cellpadding='0' cellspacing='0' bgcolor='#ffffff' ID='Table9'>\
									<tr><td><img src='/WARoot/Images/1x1.gif' width='1'></td>");
			WDVH_sendBodyChunk(reply,
							"<td align='right'><img src='/WARoot/Images/xml_btnl1.gif'></td>\
											<td background='/WARoot/Images/xml_btnb1.gif' align='middle' class='button3' nowrap>\
												&nbsp;&nbsp;<a href='javascript:restore()' class='buttonemph'>Restore</a>&nbsp;&nbsp;\
											</td>\
											<td><img src='/WARoot/Images/xml_btnr1.gif'></td>\
											<td><img src='/WARoot/Images/1x1.gif' width='10'></td>");
		WDVH_sendBodyChunk(reply,
						"<td align='right'><img src='/WARoot/Images/xml_btnl1.gif'></td>\
										<td background='/WARoot/Images/xml_btnb1.gif' align='middle' class='button3' nowrap>\
											&nbsp;&nbsp;<a href='");
		WDVH_sendBodyChunk(reply,
						server);
		WDVH_sendBodyChunk(reply,
						prefix);
		WDVH_sendBodyChunk(reply,
						location);
		WDVH_sendBodyChunk(reply,
						"' class='buttonemph'>Cancel</a>&nbsp;&nbsp;\
										</td>\
										<td><img src='/WARoot/Images/xml_btnr1.gif'></td>\
									</tr>\
								</table>\
							</td>\
						</tr>\
					</table>");
		if (erroroccured) {
			WDVH_sendBodyChunk(reply,
							"<!-- Separator -->\
					<table border='0' cellpadding='0' cellspacing='0' bgcolor='#ffffff' width='100%'>\
						<tr>\
							<td><img src='/WARoot/Images/1x1.gif' height='25'></td>\
						</tr>\
					</table>\
					<table border='0' cellpadding='0' cellspacing='0' width='10%'>\
						<tr>\
							<td>\
								<!-- Separator -->\
								<table border='0' cellpadding='0' cellspacing='0'>\
									<tr>\
										<td><img src='/WARoot/Images/1x1.gif' height='10'></td>\
									</tr>\
								</table>\
								<!-- GroupboxTitle -->\
								<table border='0' cellpadding='0' cellspacing='0' bgcolor='#CBD5E1' width='100%'>\
									<tr>\
										<td class='groupheader'><img src='/WARoot/Images/1x1.gif' height='5' width='660'></td>\
									</tr>\
									<tr>\
										<td nowrap class='groupheader'>&nbsp;&nbsp;Error&nbsp;</td>\
									</tr>\
									<tr>\
										<td class='groupheader'><img src='/WARoot/Images/1x1.gif' height='5' width='660'></td>\
									</tr>\
								</table>");
			WDVH_sendBodyChunk(reply,
							"<!-- Separator -->\
								<table border='0' cellpadding='0' cellspacing='0'>\
									<tr>\
										<td><img src='/WARoot/Images/1x1.gif' height='1'></td>\
									</tr>\
								</table>\
								<table border='0' cellpadding='0' cellspacing='1' bgcolor='#DCE3EC' width='100%'>\
									<tr>\
										<td>\
											<!-- Separator -->\
											<table bgcolor='#ffffff' border='0' cellpadding='0' cellspacing='0' width='100%'>\
												<tr>\
													<td><img src='/WARoot/Images/1x1.gif' height='5'</td>\
												</tr>\
											</table>\
											<table border='0' cellpadding='0' cellspacing='0' bgcolor='#ffffff' width='100%'>\
												<tr>\
													<td class='text'>&nbsp;&nbsp;<img src='/WARoot/Images/xml_msgerrosmall.gif' border='0'>&nbsp;");
			WDVH_sendBodyChunk(reply,
							errormsg);
			WDVH_sendBodyChunk(reply,
							"&nbsp;&nbsp;</td>\
												</tr>\
											</table>\
											<!-- Separator -->\
											<table bgcolor='#ffffff' border='0' cellpadding='0' cellspacing='0' width='100%'>\
												<tr>\
													<td><img src='/WARoot/Images/1x1.gif' height='5'</td>\
												</tr>\
											</table>\
										</td>\
									</tr>\
								</table>\
							</td>\
						</tr>\
					</table>");
		}
		WDVH_sendBodyChunk(reply,
					"<!-- Separator -->\
					<table border='0' cellpadding='0' cellspacing='0' bgcolor='#ffffff' width='100%' ID='Table22'>\
						<tr>\
							<td><img src='/WARoot/Images/1x1.gif' height='5'></td>\
						</tr>\
					</table>\
				</td>\
			</tr>\
		</table>\
	</form>\
</body>");

		WDVH_sendBodyChunkEnd(reply);

		if (server) {
			WDVHandler_Free((sapdbwa_UInt1*) server);
		}
	}


