/*!
  \file    ToolsDC_GZippedTarCreator.hpp
  \author  MarcW
  \ingroup Tools Common
  \brief   

    ========== licence begin  SAP

    Copyright (c) 2002-2006 SAP AG

    All rights reserved.

    ========== licence end

*/

#if !defined(ToolsDC_GZippedTarCreator_hpp)
#define ToolsDC_GZippedTarCreator_hpp

#include "extern/zlib/zlib.h"
#include "geo200.h"
#include "gsp00.h"

#include "ToolsCommon/Tools_List.hpp"

class TarEntry;
typedef Tools_List<TarEntry*> TarEntryList;

class  ToolsDC_GZippedTarCreator {
public:
    ToolsDC_GZippedTarCreator(const tsp00_Pathc& archiveName);
    ~ToolsDC_GZippedTarCreator();

    bool eraseArchive();
    bool writeArchive();

    bool addFile(const tsp00_Pathc& originalName);
    bool addFile(const tsp00_Pathc& originalName, const tsp00_Pathc& nameInArchive);

    const teo200_EventList& lastEvent();

private:
    bool writeArchiveImpl(gzFile& tarHandle, tsp00_Int4& originalHandle);
    void clearEntryList();

    teo200_EventList m_ErrorList;
    
    tsp00_Pathc m_archiveName;
    
    TarEntryList m_tarEntryList;
};

class TarEntry {
public:
    TarEntry(const tsp00_Pathc& originalName, const tsp00_Pathc& nameInArchive);
    ~TarEntry() {}

    const char* getOriginalName() const {
        return m_originalName.asCharp();
    }

    const char* getNameInArchive() const {
        return m_nameInArchive.asCharp();
    }

private:
    tsp00_Pathc m_originalName;
    tsp00_Pathc m_nameInArchive;
};

// tar header block, defined in POSIX 1003.1-1990, padded to 512 bytes
class TarHeader {
public:
    TarHeader(const char* originalName, const char* nameInArchive);
    ~TarHeader() {}

private:                            /* offset */
    char fileName[100];             /*   0 */
    char fileMode[8];               /* 100 */
    char ownerUserID[8];            /* 108 */
    char ownerGroupID[8];           /* 116 */
    char fileSize[12];              /* 124 */
    char modificationTime[12];      /* 136 */
    char checksum[8];               /* 148 */
    char typeFlag;                  /* 156 */
    char nameOfLinkedFile[100];     /* 157 */
    char ustarMagic[6];             /* 257 */
    char ustarVersion[2];           /* 263 */
    char ownerUserName[32];         /* 265 */
    char ownerGroupName[32];        /* 297 */
    char deviceMajorNumber[8];      /* 329 */
    char deviceMinorNumber[8];      /* 337 */
    char fileNamePrefix[155];       /* 345 */
    char padding[12];               /* 500 */
                                    /* 512 */
};

inline bool ToolsDC_GZippedTarCreator::addFile(const tsp00_Pathc& originalName) {
    return addFile(originalName, originalName);
}

inline TarEntry::TarEntry(const tsp00_Pathc& originalName, const tsp00_Pathc& nameInArchive)
: m_originalName(originalName),
  m_nameInArchive(nameInArchive) {
}

#endif
