/*!
 * \file    OMS_AllocatorTracer.hpp
 * \author  ThomasA
 * \brief   implements tracer callback of SAPDBMem_RawAllocator
 */
/*

    ========== licence begin  SAP

    (c) Copyright 2002-2006 SAP AG

    All rights reserved.

    ========== licence end




*/

#ifndef __OMS_ALLOCATORTRACE_HPP
#define __OMS_ALLOCATORTRACE_HPP

#include "SAPDBCommon/MemoryManagement/SAPDBMem_RawAllocator.hpp"

/*!
   @brief implements the SAPDBMem_RawAllocator::ITracerAndExceptionHandler interface
 */
class OMS_AllocatorTracer : public  SAPDBMem_RawAllocator::ITracerAndExceptionHandler 
{
public :
    enum ExceptionHandler {THROW_BAD_DEALLOC, KERNEL_CRASH};
    OMS_AllocatorTracer( OMS_AllocatorTracer::ExceptionHandler handler);
    virtual void Dump (void* p, int size);
    virtual void Trace (const char* msg);
    virtual void Exception(const char* msg);
private :
    OMS_AllocatorTracer::ExceptionHandler m_exceptionHandler;
};

#endif
