/*!
 * \file    OMS_AllocatorTracer.cpp
 * \author  ThomasA
 * \brief   implements tracer callback of SAPDBMem_RawAllocator
 */
/*

    ========== licence begin  SAP

    (c) Copyright 2002-2006 SAP AG

    All rights reserved.

    ========== licence end




*/


#include "Oms/OMS_AllocatorTracer.hpp"
#include "Oms/OMS_Globals.hpp"
#include "Oms/OMS_DbpError.hpp"


OMS_AllocatorTracer::OMS_AllocatorTracer( OMS_AllocatorTracer::ExceptionHandler handler)
: m_exceptionHandler(handler)
{
}

//-----------------------------------------------------------------------------

void OMS_AllocatorTracer::Dump (void* p, int size)
{
    OMS_Globals::GetKernelInterface()->DumpChunk (p, size);
}

//-----------------------------------------------------------------------------

void OMS_AllocatorTracer::Trace (const char* msg)
{
    OMS_Globals::GetKernelInterface()->Trace(msg);
}

//-----------------------------------------------------------------------------

void OMS_AllocatorTracer::Exception(const char* msg)
{   
  switch(m_exceptionHandler){
      case OMS_AllocatorTracer::THROW_BAD_DEALLOC:
        // TODO, new exception class for internal liboms allocator errors
      case OMS_AllocatorTracer::KERNEL_CRASH:
        OMS_Globals::GetKernelInterface()->Crash(msg);
  }
}

