/**************************************************************************/
/*!

  @file         Kernel_MigrationMatrix.hpp
  @author       UweH
  @brief        This defines the Kernel_MigrationMatrix
  @since        2003-06-30
*/
/*!
\if EMIT_LICENCE

  copyright:    (c) 2001-2004 SAP AG


    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



\endif
*/
#ifndef KERNEL_MIGRATION_MATRIX_HPP
#define KERNEL_MIGRATION_MATRIX_HPP
/* --------------------------------------------------------------------------- */
#define LIVECACHE_ONLY true
/* --------------------------------------------------------------------------- */
Kernel_Migration::ChangeInfo Kernel_Migration::m_ChangeInfos[] =
{
    Kernel_Migration::ChangeInfo( "historyRootIdCheck",
                                  Kernel_Migration::data,
                                  LIVECACHE_ONLY,
                                  Kernel_Version(<PERSINFO:historyRootIdCheck:COMMA_FORMATED>) ),
    Kernel_Migration::ChangeInfo( "omsContainerNewLockProtocol",
                                  Kernel_Migration::data,
                                  LIVECACHE_ONLY,
                                  Kernel_Version(<PERSINFO:omsContainerNewLockProtocol:COMMA_FORMATED>)  ),
    Kernel_Migration::ChangeInfo( "omsContainerDoubleLinkedFreeList",
                                  Kernel_Migration::data,
                                  LIVECACHE_ONLY,
                                  Kernel_Version(<PERSINFO:omsContainerDoubleLinkedFreeList:COMMA_FORMATED>)  ),
    Kernel_Migration::ChangeInfo( "openTransFileWithMinEotSeq",
                                  Kernel_Migration::data,
                                  ! LIVECACHE_ONLY,
                                  Kernel_Version(<PERSINFO:openTransFileWithMinEotSeq:COMMA_FORMATED>)  ),
    Kernel_Migration::ChangeInfo( "multipleActions",
                                  Kernel_Migration::log,
                                  ! LIVECACHE_ONLY,
                                  Kernel_Version(<PERSINFO:multipleActions:COMMA_FORMATED>)  ),
    Kernel_Migration::ChangeInfo( "RecreateIndexForOmsKeyedObjects",
                                  Kernel_Migration::data,
                                  LIVECACHE_ONLY,
                                  Kernel_Version(<PERSINFO:RecreateIndexForOmsKeyedObjects:COMMA_FORMATED>)  ),
    Kernel_Migration::ChangeInfo( "RepeatedRedoFlagInOpenTransFile",
                                  Kernel_Migration::data,
                                  ! LIVECACHE_ONLY,
                                  Kernel_Version(<PERSINFO:RepeatedRedoFlagInOpenTransFile:COMMA_FORMATED>)  ),
    Kernel_Migration::ChangeInfo(), // new change info can be inserted here
    Kernel_Migration::ChangeInfo(), // new change info can be inserted here
    // #############################################################################################
	// if you need more entries you have to update #define MAX_CHANGE_INFO 10 in Kernel_Migration.hpp
    // #############################################################################################
    // INVALID_CHANGE_INFO = MAX_CHANGE_INFO -1)
    Kernel_Migration::ChangeInfo()  // invalid value => DO NOT CHANGE THE LAST VALUE
};
/* --------------------------------------------------------------------------- */
#endif
