/*!
    \file    DBMSrvCmdAuto_AutologOn.cpp
    \author  TiloH
    \ingroup DBMServer commands
    \brief   definition of a class handling DBM Server command autolog_on

\if EMIT_LICENCE
    ========== licence begin  GPL
    Copyright (c) 2007 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif
*/

#include "hcn31.h"
#include "SAPDB/DBM/Srv/Commands/Auto/DBMSrvCmdAuto_AutologOn.hpp"

const char * const DBMSrvCmdAuto_AutologOn::m_LongHelp=
    "@command autolog_on You activate the function for the automatic backup "
        "of the log area."
        "<NL><NL>"
        "The first time you activate automatic log backup, "
        "you need to specify the name of a backup medium which will be used "
        "to automatically back up the log area."
        "<NL><NL>"
        "The backup medium can be "
        "specified for the LOG or AUTO backup types. If you specify a backup "
        "medium that was created for the LOG backup type, the system changes "
        "this property to AUTO."
        "<NL><NL>"
        "If automatic log backup has been activated "
        "before and you do not specify a backup medium, the system takes the "
        "last backup medium used for automatic log backup. "
        "<NL><NL>"
        "For security reasons, copy the backup files that the automatic "
        "log backup creates on another data carrier outside the database "
        "computer."
    "@preconditions You have the server authorization Backup. "
        "You have performed at least one complete data backup for the database "
        "instance (see: backup_start). You have specified a backup medium for "
        "the log backup (see: medium_put)."
    "@syntax autolog_on [<medium_name>] [INTERVAL <interval>]"
    "@param <medium_name> Name of the backup medium "
    "@param <interval> The maximal time interval in seconds until a log entry "
        "that was written to the log area is backed up by the automatic log "
        "backup. "
        "A value of 0 seconds for parameter <interval> deactivates interval "
        "handling by the automatic log backup. Automatic log backups are then "
        "only triggered by completed log segments. "
        "The default value for this option is 0."
        "@default 0" 
    "@reply OK";

DBMSrvCmdAuto_AutologOn::DBMSrvCmdAuto_AutologOn()
    :DBMSrv_Command(DBMSrv_Command::KeyUnknownCommand, false, m_LongHelp, false) //not obsolete and not hidden
{
}

tcn00_Error DBMSrvCmdAuto_AutologOn::runCommand(
    VControlDataT * vcontrol,
    CommandT      * command,
    char          * replyData,
    int           * replyLen,
    int             replyLenMax)
{
    return cn31AutosaveOn(vcontrol, command, replyData, replyLen, replyLenMax);
}
