/*!******************************************************************************

  @file         hkb71.h

  ------------------------------------------------------------------------------

  @author       JuergenA

  @brief        KB_get

\if EMIT_LICENCE  

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif

********************************************************************************/

#ifndef HKB71_H
#define HKB71_H


/*===========================================================================*
 *     RefType: C++                                                          *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\xf5\xd4\xaf\x4f\x3f\x90\xe4\x8f\x01\x5a\x06\xf5\xaf\xbe\x66\xcd'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "gkb07.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal tgg00_SeqInfo k71serial_seq_info;

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k71code_operand (
    tgg00_SelectFieldsParam  &  sel,
    char                     wanted_code,
    tsp00_MoveObjPtr      &  operand_addr,
    integer               &  len,
    tgg00_StEntryAddr        operand_st_addr,
    tgg00_BasisError      &  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k71col_select (
    tgg00_TransContext    &  t,
    tgg00_SelectFieldsParam  &  sel,
    tgg00_StackDesc       &  stack_desc,
    tgg00_Rec             &  rec_buf,
    pasbool               &  unqualified);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k71column_statistic (
    tgg00_MessBlock       &  m);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k71file_statistic (
    tgg00_MessBlock       &  m);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k71get (
    tgg00_MessBlock       &  m);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k71get_operand (
    tgg00_SelectFieldsParam  &  sel,
    pasbool                  check_spec_null,
    tsp00_MoveObjPtr      &  operand_addr,
    integer               &  len,
    tgg00_BasisError      &  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k71init ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k71inv_col_select (
    tgg00_TransContext    &  t,
    tgg00_SelectFieldsParam  &  sel,
    tgg00_StackDesc       &  stack_desc,
    tsp00_KeyPtr             sec_key,
    tsp00_Int2               sec_key_len,
    tsp00_KeyPtr             prim_key,
    tsp00_Int2               prim_key_len,
    pasbool               &  unqualified);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k71join_comparison (
    tgg00_SelectFieldsParam  &  sel,
    tgg00_StackOpType_Param     op,
    tkb07_buffer_description  &  workbuf,
    void *                   buf1,
    tsp00_Int4               pos1,
    integer                  len1,
    void *                   buf2,
    tsp00_Int4               pos2,
    integer                  len2,
    integer               &  ok);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k71num_err_to_b_err (
    tsp00_NumError_Param     num_err,
    tgg00_BasisError      &  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k71qualification_test (
    tgg00_MessBlock       &  m,
    pasbool                  first_qual,
    pasbool                  result_wanted,
    pasbool                  check_new_rec,
    tgg00_Rec             &  rec,
    tsp00_MoveObjPtr         result_ptr,
    tsp00_Int4               result_size,
    integer               &  result_len);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k71qual_handling (
    tgg00_TransContext    &  t,
    tgg00_SelectFieldsParam  &  sel,
    pasbool                  with_view,
    pasbool                  check_new_rec,
    tgg00_StackDesc       &  stack_desc,
    tgg00_StEntryAddr     &  err_st_ptr,
    pasbool               &  unqualified);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k71sel_qualification_test (
    tgg00_MessBlock       &  m,
    tgg00_SelectFieldsParam  &  sel,
    pasbool                  check_new_rec,
    tgg00_Rec             &  rec);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k71select (
    tgg00_MessBlock       &  m);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k71sub_value_get (
    tgg00_TransContext    &  t,
    tgg00_StackEntry      &  op,
    tsp00_MoveObjPtr         dataptr,
    integer                  datasize);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k71trigger_qualification_test (
    tgg00_MessBlock       &  m,
    tgg00_Rec             &  new_rec,
    tgg00_Rec             &  old_rec);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

