/*!***************************************************************************

  module      : gbd496.h

  -------------------------------------------------------------------------

  author      : TorstenS
  responsible : TorstenS

  special area: FileHandling
  description : 


  last changed: 1999-07-21  16:45
  see also    : 

  -------------------------------------------------------------------------

  copyright:    (c) 1999-2004 SAP AG



    ========== licence begin  GPL
    Copyright (c) 1999-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*****************************************************************************/


#ifndef GBD496_H
#define GBD496_H

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

                     // Content of include files

#include "gsp00.h"   // PASCAL: SP_basic_constants_and_types
#include "ggg00.h"   // PASCAL: GG_kernel_constants_and_types
#include "gbd00.h"   // PASCAL: BD_kernel_constants_and_types

#include "gbd494.h"  // CPP   : FunnelHandling
#include "gbd495.h"  // CPP   : DoubleQueueHandling
#include "gbd499.h"  // CPP   : IndexMemoryManagementUnit


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/


/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/

#define INIT_FILELIST_BD496     true
#define QUEUE_ENTRY_BD496       true

/*===========================================================================*
 *  FORWARD DECLARATION                                                      *
 *===========================================================================*/

class cbd497_StackDescInfo;

/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/


class cbd496_FileHandling 
{
public:
	
    cbd496_FileHandling(
		tgg00_TransContext	    &Trans,
		cbd494_SortableInvTree  &InvTree,
		bool				     bInvIsUnique);
    
    ~cbd496_FileHandling();
    
    
    void bd496ConvertFile(
        tsp00_Int4      CurrFileIndex,
        tsp00_PageNo    TempInvRoot);
    
    void bd496CreateFile( 
        tsp00_Int4       NewFileIndex,
        tsp00_PageNo    &PrimQueuePno,
        tsp00_PageNo    &SecQueuePno);
    
    void bd496CreateFile( 
        tsp00_Int4      &NewFileIndex,
        tgg00_FileId    &QueueId,
        tsp00_PageNo    &PrimQueuePno,
        tsp00_PageNo    &SecQueuePno);
    
    void bd496DeleteAllFiles();
    
    void bd496DeleteFile(
        tsp00_Int4   CurrFileIndex);
	
	static tsp00_Int4 bd496GetFileListItemSize();

	void bd496MergeFiles(
		tsp00_Bool			        bLastMergeStep,
        const cbd497_StackDescInfo  &stackDescInfo,
		tgg00_IndexCounter	        &IndexCounter);
	
private:
	
    void bd496_SetEntry(
        tsp00_Int4     CurrFileIndex,
        tsp00_PageNo   PrimQueuePno,
        tsp00_PageNo   SecQueuePno = NIL_PAGE_NO_GG00);

    void bd496_ClearEntry(
        tsp00_Int4  CurrFileIndex,
        bool        bInit = false);
    
    bool bd496_EntryUsed(
        tsp00_Int4  CurrFileIndex);
    
    tsp00_PageNo bd496_GetPrimQueuePno(
        tsp00_Int4  CurrFileIndex);
    
    tsp00_PageNo bd496_GetSecQueuePno(
        tsp00_Int4  CurrFileIndex);
    
    tsp00_PageNo bd496_GetTempInvRoot(
        tsp00_Int4  CurrFileIndex);
    
    void bd496_InitFile(
        tsp00_Int4      CurrFileIndex,
        tgg00_FileId   &QueueId,
        tsp00_PageNo   &PrimQueuePno, 
        tsp00_PageNo   &SecQueuePno);

    bool bd496_IsQueueEntry(
        tsp00_Int4  CurrFileIndex);
    
    void bd496_Merge(
        bool                        bLastMergeStep,
        tsp00_Int4                  LastItem,
        const cbd497_StackDescInfo  &stackDescInfo );

private:
    
    struct tbd496_FileListItem
    {
        tsp00_PageNo  fliPrimPno_bd496;
        tsp00_PageNo  fliSecPno_bd496;
    };
    
    tgg00_TransContext      &m_Trans;
	tgg00_BasisError	    &m_TrError;
	cbd494_SortableInvTree  &m_InvTree;
	/* */
	tsp00_Int4              m_FirstFileIndex;
	tsp00_Int4			    m_LastFileIndex;

	tsp00_Int4		    	m_FirstSortFileIndex;
	tsp00_Int4		    	m_LastSortFileIndex;

	tsp00_Int4			    m_FirstResultFileIndex;
	tsp00_Int4		    	m_LastResultFileIndex;

	tsp00_Int4			    m_FirstOverflowFileIndex;
	tsp00_Int4			    m_LastOverflowFileIndex;

	tsp00_Int4			    m_TargetFileIndex;

    tsp00_Int4              m_NumOpenQueues;
    tsp00_Int4              m_NumOpenTrees;

    tsp00_Int4			    m_NumFileListItems;
	tsp00_Int4		  	    m_NumFunnelItems;   // used by funnel
	tsp00_Int4			    m_MergeCount;		// used by funnel

	tsp00_BytePtr           m_pFunnel;			// used by funnel

    tbd496_FileListItem			       *m_pFileList;
	cbd499_IndexMemoryManagementUnit    m_MemUnit;
};


/*===========================================================================*
*  DEFINITION OF METHODS                                                    *
*===========================================================================*/

inline
cbd496_FileHandling::~cbd496_FileHandling ()
{
    ROUTINE_DBG_MEO00 ("~cbd496_FileHandling");
	
	
	m_MemUnit.bd499ReleaseFileListMemory (m_Trans.trTaskId_gg00);
	m_MemUnit.bd499ReleaseFunnelStackMemory (m_Trans.trTaskId_gg00);
}

/*---------------------------------------------------------------------------*/

inline tsp00_Int4
cbd496_FileHandling::bd496GetFileListItemSize()
{
	return sizeof (tbd496_FileListItem);
}

#endif  /* GBD496_H */
