/*!
  @file           Converter_Types.hpp
  @author         TorstenS
  @author         TillL
  @ingroup        Converter
  @brief          Common definitions of this component
*/

/*
    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*/

#ifndef CONVERTER_TYPES_HPP
#define CONVERTER_TYPES_HPP

#include "Converter/Converter_Version.hpp"

#include "KernelCommon/Kernel_Common.hpp"
#include "SAPDBCommon/SAPDB_EnhancedTypes.hpp"

#include "SAPDBCommon/Diagnostics/SAPDBDiag_CheckTopic.hpp"
#include "SAPDBCommon/Tracing/SAPDBTrace_Topic.hpp"
#include "SAPDBCommon/Tracing/SAPDBTrace_Stream.hpp"


/*===========================================================================*
*  EXTERNAL VARIABLES                                                       *
**/

/// check level for debug
extern SAPDBDiag_CheckTopic Converter_Check;
/// trace level for debug
extern SAPDBTrace_Topic     Converter_Trace;

/// @brief          number of entries of converter parent index
typedef SAPDB_UInt2
Converter_IndexEntryCount;

/// number which identifies a specific converter parent index entry
typedef SAPDB_Invalidatable<SAPDB_UInt2, SAPDB_MAX_UINT2>
Converter_IndexEntryNo;

/// number of entries on a converter page
typedef SAPDB_UInt2
Converter_PageEntryCount;

/// number which identifies a specific converter page entry
typedef SAPDB_Invalidatable<SAPDB_UInt2, SAPDB_MAX_UINT2>
Converter_PageEntryNo;

/// number of entries of converter map
typedef SAPDB_UInt4
Converter_MapEntryCount;

/// number which identifies a specific converter map entry
typedef SAPDB_Invalidatable<SAPDB_UInt4, SAPDB_MAX_UINT4>
Converter_MapEntryNo;

/// constants for different converter page types
typedef enum {
    Converter_IndexPageType,
    Converter_LeafPageType
}
Converter_PageType;

// AFTER MODIFICATION OF RETURN CODE, PLEASE ADJUST Converter_MapError.hpp

/// constants for different converter error reasons
typedef enum {
    Converter_Ok = 0,
    Converter_PageNoAlreadyInUse,
    Converter_FrameAllocationFailed,
    Converter_ConverterPageIOPending,
    Converter_InvalidBlockAddressFound,
    Converter_PageNoNotReserved,
    Converter_PageNoAlreadyFree,
    Converter_DuplicatePageNo,
    Converter_MemoryAllocationFailed,
    Converter_SavePointActive,
    Converter_NoPageNotAvailable,
    Converter_NoConverterEntry,
    Converter_PageNoOutOfRange
}
Converter_ReturnCode;

/// constants for garbage collection needed requests
typedef enum {
    Converter_GCNotWanted = 0,
    Converter_GCNotNeeded,
    Converter_GCNeeded
}
Converter_GarbageCollectionReturnCode;


#endif // CONVERTER_TYPES_HPP

