/*

    ========== licence begin  GPL
    Copyright (c) 2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*/
#ifndef __OMS_FREELISTHEADER_HPP
#define __OMS_FREELISTHEADER_HPP

#include "Oms/OMS_FreeListHeaderDef.hpp"
#include "Oms/OMS_ContextDef.hpp"

inline OMS_FreeListHeader::OMS_FreeListHeader(size_t sz) : next(NULL), size(sz), free(NULL) 
{
}

/*----------------------------------------------------------------------*/

inline void* OMS_FreeListHeader::operator new(size_t sz, OMS_Context* context) 
{
  return context->allocate(sz);
}

/*----------------------------------------------------------------------*/

#if defined(OMS_PLACEMENT_DELETE)
inline void OMS_FreeListHeader::operator delete (void* p, OMS_Context* context) 
{
  context->deallocate(p);
}
#endif

/*----------------------------------------------------------------------*/

inline void OMS_FreeListHeader::DeleteSelf (OMS_Context* context) 
{
  context->deallocate(this);
}

#endif // __OMS_FREELISTHEADER_HPP
