/*
    ========== licence begin  GPL
    Copyright (c) 2004-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

 */
#ifndef KERNEL_MESSAGES_HPP
#define KERNEL_MESSAGES_HPP

// Generated Header file Kernel_Messages.hpp.
// Generated by genmsg V2.2 DO NOT EDIT

#include "SAPDBCommon/ErrorsAndMessages/SAPDBErr_MessageList.hpp"

#define KERNEL_ERR_PAGE_BAD_INPUT                   SAPDBErr_MessageList::Error,0,"Page check failed; algorithm: %s, calculated: %s, header: %s, trailer: %s",4
#define KERNEL_ERR_PAGE_BAD_INPUT_ID 0
#define KERNEL_ERR_PAGE_BAD_OUTPUT                  SAPDBErr_MessageList::Error,1,"Page check failed; header: %s, trailer: %s",2
#define KERNEL_ERR_PAGE_BAD_OUTPUT_ID 1
#define KERNEL_ERR_OPEN_FAILED                      SAPDBErr_MessageList::Error,2,"The opening of file %s failed because of %s",2
#define KERNEL_ERR_OPEN_FAILED_ID 2
#define KERNEL_ERR_PAGE_BAD_VERIFY                  SAPDBErr_MessageList::Error,3,"Parity mismatch; header: %s, trailer: %s",2
#define KERNEL_ERR_PAGE_BAD_VERIFY_ID 3
#define KERNEL_ERR_HEADER_TRAILER_MISMATCH          SAPDBErr_MessageList::Error,4,"Header/Trailer mismatch",0
#define KERNEL_ERR_HEADER_TRAILER_MISMATCH_ID 4
#define KERNEL_ERR_HEADER_INFO                      SAPDBErr_MessageList::Error,5,"Header : Id: %s Type: %s Type2: %s CheckType: %s Mode: %s.",5
#define KERNEL_ERR_HEADER_INFO_ID 5
#define KERNEL_ERR_TRAILER_INFO                     SAPDBErr_MessageList::Error,6,"Trailer: Id: %s Type: %s Type2: %s CheckType: %s Mode: %s.",5
#define KERNEL_ERR_TRAILER_INFO_ID 6
#define KERNEL_ERR_ALLOCATE_FAILED                  SAPDBErr_MessageList::Error,7,"Memory allocation failed.",0
#define KERNEL_ERR_ALLOCATE_FAILED_ID 7
#define KERNEL_FORCE_OFFLINE                        SAPDBErr_MessageList::Error,8,"ERROR '%s' CAUSED EMERGENCY SHUTDOWN",1
#define KERNEL_FORCE_OFFLINE_ID 8
#define KERNEL_INCOMPATIBLE_VERSION                 SAPDBErr_MessageList::Error,9,"PersistentDataVersion %s.%s.%s.%s from '%s' is incompatible to current software version",5
#define KERNEL_INCOMPATIBLE_VERSION_ID 9
#define KERNEL_UNTILDATE_TOO_OLD                    SAPDBErr_MessageList::Error,10,"UNTIL DATE is older than last savepoint (%s %s)",2
#define KERNEL_UNTILDATE_TOO_OLD_ID 10
#define KERNEL_ENTER_CRITICAL_STATE_FAILED          SAPDBErr_MessageList::Error,11,"'INIT STANDBY' Collision of admin command of type '%s'",1
#define KERNEL_ENTER_CRITICAL_STATE_FAILED_ID 11
#define KERNEL_INIT_STANDBY_NOT_ALLOWED             SAPDBErr_MessageList::Error,12,"'INIT STANDBY' not for own '%s' = master '%s'",2
#define KERNEL_INIT_STANDBY_NOT_ALLOWED_ID 12
#define KERNEL_STANDBY_NODELIST_OP_FAILED           SAPDBErr_MessageList::Error,13,"'%s' internal list operation failed for '%s'",2
#define KERNEL_STANDBY_NODELIST_OP_FAILED_ID 13
#define KERNEL_STANDBY_SEND_TO_NODE_FAILED          SAPDBErr_MessageList::Error,14,"'%s' sending command to node '%s' failed",2
#define KERNEL_STANDBY_SEND_TO_NODE_FAILED_ID 14
#define KERNEL_RESTART_FILESYSTEM_FAILED            SAPDBErr_MessageList::Error,15,"RestartFilesystem failed with '%s'",1
#define KERNEL_RESTART_FILESYSTEM_FAILED_ID 15
#define KERNEL_PREPARE_LOGINFO_PAGE_FOR_READ_FAILED SAPDBErr_MessageList::Error,16,"Could not open log info page for read.",0
#define KERNEL_PREPARE_LOGINFO_PAGE_FOR_READ_FAILED_ID 16
#define KERNEL_RESET_READONLY_FAILED                SAPDBErr_MessageList::Error,17,"Reset data readonly state failed with '%s'",1
#define KERNEL_RESET_READONLY_FAILED_ID 17
#define KERNEL_CHECK_HOTSTANDBY_CONFIG              SAPDBErr_MessageList::Error,18,"RTEHSS_KernelInterface::CheckForValidHotStandbyConfiguration() returned 'InvalidConfiguration'",0
#define KERNEL_CHECK_HOTSTANDBY_CONFIG_ID 18
#define KERNEL_ALREADY_ACTIVATED                    SAPDBErr_MessageList::Warning,19,"is already activated.",0
#define KERNEL_ALREADY_ACTIVATED_ID 19
#define KERNEL_ACTIVATE_IS_MISSING                  SAPDBErr_MessageList::Warning,20,"ACTIVATE is missing",0
#define KERNEL_ACTIVATE_IS_MISSING_ID 20
#define KERNEL_UNKNOWN_ACTIVATION_STATE             SAPDBErr_MessageList::Warning,21,"Unknown activation state '%s' found.",1
#define KERNEL_UNKNOWN_ACTIVATION_STATE_ID 21
#define KERNEL_RESTART_LOCKLIST_FAILED              SAPDBErr_MessageList::Warning,22,"Sql lock manager could not be initialized",0
#define KERNEL_RESTART_LOCKLIST_FAILED_ID 22
#define KERNEL_INIT_LOG_FAILED                      SAPDBErr_MessageList::Warning,23,"Initialization of log for '%s' failed with '%s'",2
#define KERNEL_INIT_LOG_FAILED_ID 23
#define KERNEL_REDO_ERROR                           SAPDBErr_MessageList::Warning,24,"Redo error '%s' occured",1
#define KERNEL_REDO_ERROR_ID 24
#define KERNEL_INIT_TERMSET_FAILED                  SAPDBErr_MessageList::Warning,25,"Termset initialization failed.",0
#define KERNEL_INIT_TERMSET_FAILED_ID 25
#define KERNEL_CREATE_ERROR_FILE_FAILED             SAPDBErr_MessageList::Warning,26,"Create of errorfile failed",0
#define KERNEL_CREATE_ERROR_FILE_FAILED_ID 26
#define KERNEL_SAVE_GOOD_FAILED                     SAPDBErr_MessageList::Warning,27,"Saving last known good config failed with '%s', '%s'.",2
#define KERNEL_SAVE_GOOD_FAILED_ID 27
#define KERNEL_ATTACH_LOGVOLUMES_ERROR              SAPDBErr_MessageList::Warning,28,"Error occured during open log volumes",0
#define KERNEL_ATTACH_LOGVOLUMES_ERROR_ID 28
#define KERNEL_ATTACH_DATAVOLUMES_ERROR             SAPDBErr_MessageList::Warning,29,"Error occured during open data volumes",0
#define KERNEL_ATTACH_DATAVOLUMES_ERROR_ID 29
#define KERNEL_CLEAR_LOG_ERROR                      SAPDBErr_MessageList::Warning,30,"Error '%s' occured during clear log volume",1
#define KERNEL_CLEAR_LOG_ERROR_ID 30
#define KERNEL_ENABLE_MIGRATION                     SAPDBErr_MessageList::Info,31,"Migration enabled for '%s'",1
#define KERNEL_ENABLE_MIGRATION_ID 31
#define KERNEL_SWITCHED_TO_ACTIVATED                SAPDBErr_MessageList::Info,32,"Database is activated",0
#define KERNEL_SWITCHED_TO_ACTIVATED_ID 32
#define KERNEL_SWITCHED_TO_ACTIVATED2               SAPDBErr_MessageList::Info,33,"Database is activated for log only recovery",0
#define KERNEL_SWITCHED_TO_ACTIVATED2_ID 33
#define KERNEL_REDO_LOG_FINISHED                    SAPDBErr_MessageList::Info,34,"Kernel state: 'REDO LOG' finished",0
#define KERNEL_REDO_LOG_FINISHED_ID 34
#define KERNEL_STATE_IS_ADMIN                       SAPDBErr_MessageList::Info,35,"Kernel state: 'ADMIN' reached",0
#define KERNEL_STATE_IS_ADMIN_ID 35
#define KERNEL_STATE_IS_ONLINE                      SAPDBErr_MessageList::Info,36,"Kernel state: 'ONLINE' reached",0
#define KERNEL_STATE_IS_ONLINE_ID 36
#define KERNEL_STATE_IS_OFFLINE                     SAPDBErr_MessageList::Info,37,"Kernel state: 'OFFLINE' reached",0
#define KERNEL_STATE_IS_OFFLINE_ID 37
#define KERNEL_INIT_STANDBY_START                   SAPDBErr_MessageList::Info,38,"Kernel state: 'INIT STANDBY' for master '%s' started",1
#define KERNEL_INIT_STANDBY_START_ID 38
#define KERNEL_NEW_STANDBY                          SAPDBErr_MessageList::Info,39,"Hotstandby: new standby on %s registered with offset %s",2
#define KERNEL_NEW_STANDBY_ID 39
#define KERNEL_STANDBY_REMOVED                      SAPDBErr_MessageList::Info,40,"Hotstandby: standby (%s) removed",1
#define KERNEL_STANDBY_REMOVED_ID 40
#define KERNEL_LAST_STANDBY_REMOVED                 SAPDBErr_MessageList::Info,41,"Hotstandby: last standby (%s) removed",1
#define KERNEL_LAST_STANDBY_REMOVED_ID 41
#define KERNEL_STANDBY_REGISTER                     SAPDBErr_MessageList::Info,42,"Hotstandby: register succeded; redo until offset %s",1
#define KERNEL_STANDBY_REGISTER_ID 42
#define KERNEL_SYNC_RECEIVED                        SAPDBErr_MessageList::Info,43,"HotStandby: Synchronize: redo until offset %s",1
#define KERNEL_SYNC_RECEIVED_ID 43
#define KERNEL_SYNCREPLY_RECEIVED                   SAPDBErr_MessageList::Info,44,"HotStandby: SynchronizeReply from %s offset %s received",2
#define KERNEL_SYNCREPLY_RECEIVED_ID 44
#define KERNEL_CRITICAL_STATE_NOT_ENTERED           SAPDBErr_MessageList::Info,45,"Could not enter critical state '%s'.",1
#define KERNEL_CRITICAL_STATE_NOT_ENTERED_ID 45
#define KERNEL_HINT_HOTSTANDBY_CONFIG               SAPDBErr_MessageList::Info,46,"The database parameters are neither correctly configured for 'HotStandby' nor for 'Normal' operation.",0
#define KERNEL_HINT_HOTSTANDBY_CONFIG_ID 46
#define KERNEL_COMMAND_NOT_ALLOWED                  SAPDBErr_MessageList::Info,47,"'%s' is not allowed in mode '%s'.",2
#define KERNEL_COMMAND_NOT_ALLOWED_ID 47

#endif /* KERNEL_MESSAGES_HPP */
