/*!******************************************************************************

  @file         hsp51.h

  ------------------------------------------------------------------------------

  @author       

  @brief        Number-Arithmetic

\if EMIT_LICENCE  


    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif

********************************************************************************/

#ifndef HSP51_H
#define HSP51_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\xda\xbf\xac\x38\x03\xe3\xcd\x6e\x8b\xe0\x07\x3c\x0c\x5e\x76\x4b'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void s51abs (
    void                  *  source,
    tsp00_Int4                           spos,
    integer                              slen,
    void                  *  result,
    tsp00_Int4                           respos,
    integer                              reslen,
    integer                              resfrac,
    integer               VAR_VALUE_REF  resbytelen,
    tsp00_NumError        VAR_VALUE_REF  ret);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s51add (
    void                  *  left,
    tsp00_Int4                           lpos,
    integer                              llen,
    void                  *  right,
    tsp00_Int4                           rpos,
    integer                              rlen,
    void                  *  result,
    tsp00_Int4                           respos,
    integer                              reslen,
    integer                              resfrac,
    integer               VAR_VALUE_REF  resbytelen,
    tsp00_NumError        VAR_VALUE_REF  ret);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s51div (
    void                  *  left,
    tsp00_Int4                           lpos,
    integer                              llen,
    void                  *  right,
    tsp00_Int4                           rpos,
    integer                              rlen,
    void                  *  result,
    tsp00_Int4                           respos,
    integer                              reslen,
    integer                              resfrac,
    integer               VAR_VALUE_REF  resbytelen,
    tsp00_NumError        VAR_VALUE_REF  ret);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal integer s51floatlen (
    void                  *  source,
    tsp00_Int4                           spos,
    integer                              slen);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s51intdiv (
    void                  *  left,
    tsp00_Int4                           lpos,
    integer                              llen,
    void                  *  right,
    tsp00_Int4                           rpos,
    integer                              rlen,
    void                  *  result,
    tsp00_Int4                           respos,
    integer                              reslen,
    integer                              resfrac,
    integer               VAR_VALUE_REF  resbytelen,
    tsp00_NumError        VAR_VALUE_REF  ret);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s51isint (
    void                  *  source,
    tsp00_Int4                           spos,
    integer                              slen,
    pasbool               VAR_VALUE_REF  isint,
    tsp00_NumError        VAR_VALUE_REF  ret);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s51kroun (
    void                  *  source,
    tsp00_Int4                           spos,
    integer                              slen,
    void                  *  result,
    tsp00_Int4                           respos,
    integer                              reslen,
    integer                              resfrac,
    integer               VAR_VALUE_REF  resbytelen,
    tsp00_NumError        VAR_VALUE_REF  ret);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s51mul (
    void                  *  left,
    tsp00_Int4                           lpos,
    integer                              llen,
    void                  *  right,
    tsp00_Int4                           rpos,
    integer                              rlen,
    void                  *  result,
    tsp00_Int4                           respos,
    integer                              reslen,
    integer                              resfrac,
    integer               VAR_VALUE_REF  resbytelen,
    tsp00_NumError        VAR_VALUE_REF  ret);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s51neg (
    void                  *  source,
    tsp00_Int4                           spos,
    integer                              slen,
    void                  *  result,
    tsp00_Int4                           respos,
    integer                              reslen,
    integer                              resfrac,
    integer               VAR_VALUE_REF  resbytelen,
    tsp00_NumError        VAR_VALUE_REF  ret);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s51power (
    void                  *  base,
    tsp00_Int4                           basepos,
    integer                              baselen,
    integer                              basefrac,
    void                  *  power,
    tsp00_Int4                           ppos,
    integer                              plen,
    integer                              pfrac,
    void                  *  result,
    tsp00_Int4                           respos,
    integer                              reslen,
    integer                              resfrac,
    integer               VAR_VALUE_REF  resbytelen,
    tsp00_NumError        VAR_VALUE_REF  ret);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s51round (
    void                  *  source,
    tsp00_Int4                           spos,
    integer                              slen,
    integer                              round,
    void                  *  result,
    tsp00_Int4                           respos,
    integer                              reslen,
    integer                              resfrac,
    integer               VAR_VALUE_REF  resbytelen,
    tsp00_NumError        VAR_VALUE_REF  ret);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s51scale (
    tsp00_Number          VAR_ARRAY_REF  vnumber,
    integer                              scale,
    tsp00_NumError        VAR_VALUE_REF  res);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s51sqrt (
    void                  *  source,
    tsp00_Int4                           spos,
    integer                              slen,
    void                  *  result,
    tsp00_Int4                           respos,
    integer                              reslen,
    integer                              resfrac,
    integer               VAR_VALUE_REF  resbytelen,
    tsp00_NumError        VAR_VALUE_REF  ret);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s51sub (
    void                  *  left,
    tsp00_Int4                           lpos,
    integer                              llen,
    void                  *  right,
    tsp00_Int4                           rpos,
    integer                              rlen,
    void                  *  result,
    tsp00_Int4                           respos,
    integer                              reslen,
    integer                              resfrac,
    integer               VAR_VALUE_REF  resbytelen,
    tsp00_NumError        VAR_VALUE_REF  ret);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s51trunc (
    void                  *  source,
    tsp00_Int4                           spos,
    integer                              slen,
    integer                              trunc,
    void                  *  result,
    tsp00_Int4                           respos,
    integer                              reslen,
    integer                              resfrac,
    integer               VAR_VALUE_REF  resbytelen,
    tsp00_NumError        VAR_VALUE_REF  ret);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

