/*!
  @file           hsp100.h
  @author         RaymondR
  @special area   Version
  @brief          Version information functions


\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
*/

#ifndef HSP100_H
#define HSP100_H

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "gsp100.h"

/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externC void  sp100_GetVersionString  ( const tsp100_CompName      ComponentName,      /* INPUT */
                                        tsp100_BuildNumberFunc     pBuildNumberFunc,   /* INPUT */
#if defined (__cplusplus)
                                        tsp00_Versionc             &VersionString );   /* OUTPUT */
#else
                                        tsp00_Versionc             VersionString );    /* OUTPUT */
#endif

#if defined (__cplusplus)
externC void sp100_GetSenderIDVersion ( tsp00_C5c                  &SenderID );        /* OUTPUT */
#else
externC void sp100_GetSenderIDVersion ( tsp00_C5c                  SenderID );         /* OUTPUT */
#endif

externC void  sp100_GetVersionID      ( tsp100_VersionIDType       IDType,		   	     /* INPUT	 */
                                        tsp100_BuildNumberFuncEx   pBuildNumberFuncEx, /* INPUT  */
                                        tsp100_VersionID           *pVersionID );      /* OUTPUT */

externC tsp100_VersionResult
              sp100_Compare2VersionIDs( tsp100_VersionIDType       IDType,              /* INPUT */ 
                                        tsp100_VersionID           *pCmpVersionID1,     /* INPUT */
                                        tsp100_VersionID           *pCmpVersionID2 );   /* INPUT */

externC tsp100_VersionResult        /* - tsp100_VersionID0 compare only! */
              sp100_CompareVersionIDs ( tsp100_VersionID           *pCmpVersionID );   /* INPUT */

/* 
 *  following functions are generated by vmake !!!!
 */
externC char* s100buildnumber         ( void );
externC char* s100buildnumberEx       ( unsigned char             *pBuildNumberPrefix,
                                        unsigned long             *pBuildNumber );

#endif  /* HSP100_H */
