/*!**************************************************************************

  module:    vpr01StmtName.c

  -------------------------------------------------------------------------

  responsible: BurkhardD, MarcoP

  special area:   CPCDrv | Client | Statementnamen 
  description : Verwaltung von Statementnamen

  last changed: 2000-09-08  9:05
  see also    :

 change history:

        2001-06-22 D025086 PTS 1110677 Do not drop ParseIdNull

  -------------------------------------------------------------------------





    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*****************************************************************************/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include <stdio.h>
#include <ctype.h>
#include "vpr07Macro.h"
#include "gpr03.h"
#include "vpr01StmtName.h"
#include "vpr01Con.h"
#include "vpr01SQL.h"
#include "vpr06ParseId.h"
#include "gpr03.h"
#include "vpr01ParseInfo.h"

/*==================================================================*
 *  DECLARATIONS                                                    *
 *==================================================================*/

/*==================================================================*
 *  EXTERNAL PROTOTYPES                                             *
 *==================================================================*/

/*==================================================================*
 *  FUNCTION PROTOTYPES                                             *
 *==================================================================*/

static void pr01StmtNameInitCont(tpr01_StmtNameContainer *Cont);

static tsp00_Int4 pr01StmtNameOpenCont(tpr01_StmtNameContainer *Cont);

static tsp00_Int4 pr01StmtNameGetCount(tpr01_StmtNameContainer *Cont);

static void pr01StmtNameCloseCont(tpr01_StmtNameContainer *Cont);

static tpr01_StmtNameDesc *pr01StmtNameEnumDesc(tpr01_StmtNameContainer *Cont);

static tsp00_Int4 pr01StmtNameSetIndex(tpr01_StmtNameContainer *Cont, tsp00_Int4 cbIndex);

static tpr01_StmtNameDesc *pr01StmtNameAddDesc(tpr01_StmtNameContainer *StmtName, tpr05_String *stStmtName, tpr01_UniqueID UniqueID, sqlkaentry *ka);

static void pr01StmtNameDeleteDesc(tpr01_StmtNameDesc *StmtNameDesc);

static tpr01_StmtNameDesc *pr01StmtNameFindDesc(tpr01_StmtNameContainer *StmtName, tpr05_String *stStmtName, tpr01_UniqueID UniqueID);

static int pr01StmtNameGetSQL(tpr01_StmtNameDesc *StmtNameDesc, tpr05_String **pSQLStatement, tpr01_SQLStatementOptionEnum fOption);

static int pr01StmtNamePutSQL(tpr01_StmtNameDesc *StmtNameDesc, tpr05_String *pSQLStatement, tpr01_SQLStatementOptionEnum fOption);

static void pr01StmtNameTraceStmtName (tpr01_StmtNameDesc *StmtNameDesc, sqlcatype * sqlca);

/*static void pr01StmtNameSetStmtType(struct tpr01_StmtNameDesc *StmtNameDesc);*/

static void pr01StmtNameSetState(struct tpr01_StmtNameDesc *StmtNameDesc, tpr01_SQLStateBinary State);

static void pr01StmtNameDropParsId(tpr01_StmtNameDesc *StmtNameDesc, tpr01_SQLDesc *SQLDesc);

static void pr01StmtName_InitStmtNameStruct (tpr00_StmtNameStruct *StmtNameStruct);

/*==================================================================*
 *  CODE                                                            *
 *==================================================================*/

/*!
  Function:     pr01StmtNameInitCont

  see also: 

  Description:  initializes StmtName Container 
    
  Arguments:
    *Cont [in|out] pointer to container
    return value: void
 */
static void pr01StmtNameInitCont(tpr01_StmtNameContainer *Cont)
{
  Cont->Desc = pr09NewDescriptor(3, sizeof(tpr01_StmtNameDesc));
  Cont->InitCont           = pr01StmtNameInitCont;
  Cont->OpenCont           = pr01StmtNameOpenCont;
  Cont->CloseCont          = pr01StmtNameCloseCont;
  Cont->GetCount           = pr01StmtNameGetCount;
  Cont->SetIndex           = pr01StmtNameSetIndex;
  Cont->EnumDesc           = pr01StmtNameEnumDesc;
  Cont->DeleteDesc         = pr01StmtNameDeleteDesc;
  Cont->AddDesc            = pr01StmtNameAddDesc;
  Cont->FindDesc           = pr01StmtNameFindDesc;
  Cont->PutSQL             = pr01StmtNamePutSQL;
  Cont->GetSQL             = pr01StmtNameGetSQL;
  Cont->TraceStmtName      = pr01StmtNameTraceStmtName;
  Cont->DropParsId         = pr01StmtNameDropParsId;
  Cont->SetState           = pr01StmtNameSetState;
  Cont->InitStmtNameStruct = pr01StmtName_InitStmtNameStruct;
}


/*!
  Function:     pr01StmtNameDeleteCont

  see also: 

  Description:  deletes a StmtName Container 
    
  Arguments:
    *StmtName [in|out] pointer to a container
    return value: void
 */
void pr01StmtNameDeleteCont(tpr01_StmtNameContainer *StmtName)
{
  if (StmtName) {
    if (pr01StmtNameOpenCont(StmtName)) {
      /* liefert <> 0 wenn StmtName Descriptoren vorhanden sind */
      tpr01_StmtNameDesc *StmtNameDesc;
      while(StmtNameDesc = pr01StmtNameEnumDesc(StmtName))
	pr01StmtNameDeleteDesc(StmtNameDesc);
    }
    if (StmtName->Desc)
      pr09DeleteDescriptor(StmtName->Desc);
    pr03mFree((tsp00_Uint1*)StmtName, "StmtName");
  }
}

tpr01_StmtNameContainer *pr01StmtNameNewCont()
{
  tpr01_StmtNameContainer *StmtName;
  StmtName = pr03mAllocat(sizeof(tpr01_StmtNameContainer), "StmtName");
  if (StmtName)
    pr01StmtNameInitCont(StmtName);
  return StmtName;
}


static tsp00_Int4 pr01StmtNameOpenCont(tpr01_StmtNameContainer *StmtName)
{
  if (StmtName->Desc) {
    pr09SetIndex(StmtName->Desc, -1);
  }
  return(StmtName->GetCount(StmtName));
}

/*!
  Function:     pr01StmtNameAddDesc

  see also: 

  Description:  adds a new Statement Descriptor to a Statement Container
    
  Arguments:
    *StmtName  [in] pointer to StmtContainer 
    stStmtName [in] Name of the new Stmt Descriptor. If StmtNameStruct points to a
                    NULL Value the Parameter UniqueID must set. 
    UniqueID   [in] uniqueID of the Statement generated by precompiling.
                    If you pass an unique value not equal to 
		    EmptyUniqueID_cpr01 the function will generates a StmtName
                    by it selfs. 
    
    *ka        [in] pointer to an entry of sqlka-area. If ka points to NULL an empty
                    kaentry will generated autimaticly.

  return value: tpr01_StmtNameDesc - pointer to the new Statement Descriptor 
                which was inserted into the Statement Container

  Remarks: pr01StmtNameAddDesc dosn't check if an StmtName already is in use. A new entry will generate at all. 
 */
static tpr01_StmtNameDesc *pr01StmtNameAddDesc(tpr01_StmtNameContainer *StmtName, tpr05_String *stStmtName, tpr01_UniqueID UniqueID, sqlkaentry *ka)
{
  M90TRACE(M90_TR_ENTRY, "pr01StmtNameAddDesc", 0);
  M90TRACE(M90_TR_WORD, "kalineno", &ka->kalineno);
  {
    tpr01_StmtNameDesc *StmtNameDesc;  
    StmtNameDesc = pr09AddItem(StmtName->Desc);
    StmtNameDesc->DescType = StmtNameDesc_epr01;
    StmtNameDesc->StmtName = StmtName;
    StmtNameDesc->sn = pr03mAllocat(sizeof(sqlsnentry), "StmtNameDesc->sn");
    pr01StmtNameSnEntryInit(StmtNameDesc->sn);
    StmtNameDesc->UniqueID = UniqueID;
    StmtNameDesc->StmtName->InitStmtNameStruct(&(StmtNameDesc->StmtNameStruct));
    if (UniqueID != EmptyUniqueID_cpr01) {
      /*generate an implizit statement name*/
      sp77sprintfUnicode (StmtNameDesc->StmtNameStruct.stStmtName.encodingType,
                          StmtNameDesc->StmtNameStruct.stStmtName.rawString,
                          StmtNameDesc->StmtNameStruct.stStmtName.cbLen,
                          ":%#08lx", 
                          UniqueID);
    }
    else {
      /*take the given statement name*/  
      tpr05_StringError erg = pr05IfCom_String_Convert (&(StmtNameDesc->StmtNameStruct.stStmtName),
                                                        stStmtName );

    }
    /* grep shows that CursorDesc->cue->cuname is no longer required
    pr07C2P(StmtNameDesc->sn->snname, StmtNameDesc->szStmtName, sizeof(StmtNameDesc->sn->snname));*/
    /* alloc & init new SQLStatetement */
    StmtNameDesc->SQLStatement = pr05IfCom_String_NewDynString(0, NULL);
    StmtNameDesc->fOption      = First_epr01;   /* type of SQLStatement is new Statement */
    StmtNameDesc->State        = Empty_bpr01;
   
    StmtNameDesc->StmtTypeDesc.StmtType      = KeywordNOT_ANALYZED_epr01;
    StmtNameDesc->StmtTypeDesc.StmtOption    = KeywordNOT_FOUND_epr01;
    StmtNameDesc->StmtTypeDesc.CursorPos     = 0;
    StmtNameDesc->StmtTypeDesc.CursorLength  = 0;
    StmtNameDesc->StmtTypeDesc.CursorType    = CPR_S_UNKNOWN;
    StmtNameDesc->StmtTypeDesc.FetchPosType  = CPR_S_UNKNOWN;
    StmtNameDesc->StmtTypeDesc.UsingPos      = 0;
    StmtNameDesc->StmtTypeDesc.Cacheable     = notcacheable_epr01;
    
    StmtNameDesc->ParseInfoDesc = NULL;

    memset(&StmtNameDesc->KnlSessionID, '\0', sizeof(tpr00_SessionID));

    StmtNameDesc->ka = pr01cDupKa(ka);
    StmtNameDesc->ore = pr03mAllocat(sizeof(sqlorentry), "StmtNameDesc->ore");
    pr03cOrInit(StmtNameDesc->ore);    
    StmtNameDesc->cue = pr03mAllocat(sizeof(sqlcuentry), "StmtNameDesc->cue");
    pr03cCuInit(StmtNameDesc->cue);    
    M90TRACE(M90_TR_EXIT, "pr01StmtNameAddDesc", 0);    
    M90TRACE(M90_TR_HANDLE, "StmtNameDesc", &StmtNameDesc);    
    return(StmtNameDesc);
  }
}

static void pr01StmtNameDeleteDesc(tpr01_StmtNameDesc *StmtNameDesc)
{
  int cbIndex = pr09ItemFindIndex(StmtNameDesc->StmtName->Desc, StmtNameDesc);
  if (cbIndex >= 0) {
    PR07_HEAPCHECK(NULL);
    if (StmtNameDesc->sn)
      pr03mFree(StmtNameDesc->sn, "StmtNameDesc->sn");
    PR07_HEAPCHECK(NULL);
    if (StmtNameDesc->ka)
      pr01cFreeKa(StmtNameDesc->ka);
    PR07_HEAPCHECK(NULL);
    if (StmtNameDesc->ore)
      pr03mFree(StmtNameDesc->ore, "StmtNameDesc->ore");
    PR07_HEAPCHECK(NULL);
    if (StmtNameDesc->cue)
      pr03mFree(StmtNameDesc->cue, "StmtNameDesc->cue");
      
    /* deletes SQLStatement and frees memory, but only
       if SQLStatement is not a reference */
    PR07_HEAPCHECK(NULL);
    if ( StmtNameDesc->fOption != Reference_epr01 )
      pr05IfCom_String_DeleteString(StmtNameDesc->SQLStatement);

    /*delete statement name and release memory*/
    pr05IfCom_String_DeleterawString(&(StmtNameDesc->StmtNameStruct.stStmtName));
    PR07_HEAPCHECK(NULL);

    if ( StmtNameDesc->ParseInfoDesc )
      StmtNameDesc->ParseInfoDesc->ParseInfo->DeleteDesc(StmtNameDesc->ParseInfoDesc, DROP_PARSEID);
    PR07_HEAPCHECK(NULL);

    pr09CloseItemEx(StmtNameDesc->StmtName->Desc, cbIndex);
  }
}

static tsp00_Int4 pr01StmtNameGetCount(tpr01_StmtNameContainer *StmtName)
{
  return(pr09GetItemCount(StmtName->Desc));
}

/*!
  Function:     pr01StmtNameEnumDesc

  see also: 

  Description:  Iterator Function for Statement Container
    
  Arguments:
    *StmtName [in] pointer to Statement Container

  return value: 
    <UL>
        <LI>tpr01_StmtNameDesc* : pointer to then next StatementDescriptor 
                in the Statement Container.
        <LI>null pointer : if no next item in Statement Container exists
    </UL>

 */
static tpr01_StmtNameDesc *pr01StmtNameEnumDesc(tpr01_StmtNameContainer *StmtName)
{
  tpr01_StmtNameDesc *StmtNameDesc=pr09GetNextItem(StmtName->Desc);
  return(StmtNameDesc);
}

static void pr01StmtNameCloseCont(tpr01_StmtNameContainer *StmtName)
{
  pr09CloseAllItems(StmtName->Desc);
}

static tsp00_Int4 pr01StmtNameSetIndex(tpr01_StmtNameContainer *StmtName, tsp00_Int4 cbIndex)
{
  return(pr09SetIndex(StmtName->Desc, cbIndex));
}

static tpr01_StmtNameDesc *pr01StmtNameFindDesc(tpr01_StmtNameContainer *StmtName, tpr05_String *stStmtName, tpr01_UniqueID UniqueID)
{
  M90TRACE(M90_TR_ENTRY, "pr01StmtNameFindDesc", 0);
  {
    tsp00_Int4 cbOldIndex = StmtName->SetIndex(StmtName, -1);
    tpr01_StmtNameDesc *StmtNameDesc=NULL;
    if ( UniqueID == EmptyUniqueID_cpr01) {
      while(StmtNameDesc=StmtName->EnumDesc(StmtName)) {
        if (! pr05IfCom_String_strcmp(stStmtName,&(StmtNameDesc->StmtNameStruct.stStmtName))){
	  break;
	}
      }
    }
    else {
      while(StmtNameDesc=StmtName->EnumDesc(StmtName)) {
	if (UniqueID == StmtNameDesc->UniqueID) {
	  break;
	}
      }
    }
    if (!StmtNameDesc)
      StmtName->SetIndex(StmtName, cbOldIndex);
    M90TRACE(M90_TR_EXIT, "pr01StmtNameFindDesc", 0);
    M90TRACE(M90_TR_HANDLE, "StmtNameDesc", &StmtNameDesc);
    return(StmtNameDesc);    
  }
}


void pr01StmtNameSnEntryInit(sqlsnentry *sn)
{
  memset(sn->snname, 0, sizeof(sn->snname));
  sn->sntype    = cpr_is_statement;
  sn->snstmtp   = NULL;
  sn->sncount   = 0;
  sn->snindex   = 0;
  sn->snbuflen  = 0;
  sn->snstmtlen = 0;
  sn->snsession = ActualSession_cpr00;
  pr06ParseIdCopy(&sn->snParseInfo.ParseId, ParseIdNull_cpr00);
}

/*!
  Function:     pr01StmtNamePutSQL

  see also: 

  Description:  Sets sql statement, length and encoding type 
                in statement descriptor.
    
  Arguments:
    StmtNameDesc  [in] pointer to Stmt Descriptor
    pSQLStatement [in] tpr05_String which contains the sql-statement.
    fOption       [in] controls processing of pSQLStatement->rawString
    <UL>
        <LI>fOption == First_epr01     => a new sqlstatement, overwrite buffer 
        <LI>fOption == Append_epr01    => next part of sqlstatement, append on buffer 
        <LI>fOption == Reference_epr01 => only Referenz to sql-statement will be stored 
    </UL>

  return value: int 
    <UL>
        <LI>0 : error
        <LI>1 : sql-statement processing succeeds
    </UL>
 */
static int pr01StmtNamePutSQL(tpr01_StmtNameDesc *StmtNameDesc, tpr05_String* pSQLStatement, tpr01_SQLStatementOptionEnum fOption)
{
  M90TRACE(M90_TR_ENTRY, "pr01StmtNamePutSQL", 0);
  M90TRACE(M90_TR_HANDLE, "StmtNameDesc", &StmtNameDesc);
  M90TRACE(M90_TR_ENUM, "fOption", &fOption);
  PR07_CHECKDESC(StmtNameDesc, StmtNameDesc_epr01);  
  {
    if (pSQLStatement) {
      tsp00_Uint4 Len, Offset;
      if (pSQLStatement->cbLen != 0) 
        {
          Len = pSQLStatement->cbLen;
        }
      else 
        {
          /*Error nach Bufferumstellung ohne Nullterminator Lnge nicht entscheidbar
               
            if (encodingType == sp77encodingAscii)
            {
            Len = strlen(szSQLStatement);
            }
            else
            {
            Len = 2 * sp81UCS2strlen((tsp81_UCS2Char*) szSQLStatement);	
            }*/
          M90TRACE(M90_TR_EXIT, "pr01StmtNamePutSQL", 0);
          return(0);
        }
      /* Reset the analysed state from the Statement Desc */
      StmtNameDesc->State &= ~Analysed_bpr01;
      if (fOption == First_epr01 || fOption == Append_epr01) 
        {

	  if (fOption == First_epr01) 
            {
	      Offset = 0;
            }
	  else 
            {
	      Offset = StmtNameDesc->SQLStatement->cbLen;
            }
	  if (Len+Offset > StmtNameDesc->SQLStatement->cbMaxLen) 
            {
	      if (  StmtNameDesc->SQLStatement->allocationType == allocated_epr05
                    &&StmtNameDesc->SQLStatement->cbMaxLen > 0)
                {
	          StmtNameDesc->SQLStatement->rawString = pr03mReallocat(StmtNameDesc->SQLStatement->rawString, Len+Offset, "StmtNameDesc->SQLStatement->rawString");
                }
	      else 
                {
	          StmtNameDesc->State |= Allocated_bpr01;
	          StmtNameDesc->SQLStatement->rawString = pr03mAllocat(Len, "StmtNameDesc->SQLStatement->rawString");
                  StmtNameDesc->SQLStatement->allocationType = allocated_epr05;
                }
	    
	      if (!StmtNameDesc->SQLStatement->rawString) 
                {
	          pr07CheckAssert(TRUE);
	          return 0;
                }	    
	      StmtNameDesc->SQLStatement->cbMaxLen = Len+Offset;
            }
	  StmtNameDesc->SQLStatement->cbLen = Len+Offset;
	  StmtNameDesc->SQLStatement->encodingType = pSQLStatement->encodingType;
	  StmtNameDesc->fOption = fOption;
	  /* copy SQL-Statement to StmtNameDesc*/
	  memcpy(&StmtNameDesc->SQLStatement->rawString[Offset], pSQLStatement->rawString, Len);
        }
      else 
        {
	  if (fOption == Reference_epr01) 
            {
	      StmtNameDesc->SQLStatement->cbLen = Len;
	      /* if a Statement already allocated free it */
	      /* but don't free it if the new address is same to the old one 
	         or if Statement is only a referenz */
	      if (   StmtNameDesc->fOption != Reference_epr01
                     && StmtNameDesc->SQLStatement->rawString != pSQLStatement->rawString) 
                {
                  /* deletes SQLStatement and frees memory*/
	          pr05IfCom_String_DeleteString(StmtNameDesc->SQLStatement);
                }
	      StmtNameDesc->SQLStatement = pSQLStatement;      
              StmtNameDesc->fOption = Reference_epr01;
            }
	  else
            pr07CheckAssert(TRUE);
        }
      pSQLStatement = StmtNameDesc->SQLStatement;
    }
    M90TRACE(M90_TR_EXIT, "pr01StmtNamePutSQL", 0);
    return(1);
  }
}
/*!
  Function:     pr01StmtNameGetSQL

  see also: 

  Description:  Gets SQL-Command, length and encoding typ for a given 
                SQL-Command. Depending on fOption a copy or a reference 
                of StmtDesc->SQLStatement will be stored in pSQLStatement.

  Arguments:
    *StmtNameDesc [in]       pointer to a statement descriptor
    *pSQLStatement[in | out] pointer to a tpr05_String for output sql-statement
    fOption       [in]       controls type of pSQLStatement->rawString;
    <UL>
        <LI>fOption == Reference_epr01 => only Referenz to sql-statement will be stored
        <LI>fOption == someone else    => copy off sql-statement will be created
    </UL>

  return value: int 
    <UL>
        <LI>0 : error
        <LI>1 : processing succeeds
    </UL>
 */
static int pr01StmtNameGetSQL(tpr01_StmtNameDesc *StmtNameDesc, tpr05_String **pSQLStatement, tpr01_SQLStatementOptionEnum fOption)
{
  M90TRACE(M90_TR_ENTRY, "pr01StmtNameGetSQL", 0);
  M90TRACE(M90_TR_HANDLE, "StmtNameDesc", &StmtNameDesc);
  PR07_CHECKDESC(StmtNameDesc, StmtNameDesc_epr01);  
  {
    if (! *pSQLStatement || fOption == Reference_epr01) 
      /* copy by reference */
      {
        *pSQLStatement = StmtNameDesc->SQLStatement;
         
        M90TRACE(M90_TR_EXIT, "pr01StmtNameGetSQL", 0);
        M90TRACE(M90_TR_STRING, "SQLStatement", StmtNameDesc->SQLStatement->rawString);
        return(1);
      }
    if ((*pSQLStatement)->cbMaxLen >= StmtNameDesc->SQLStatement->cbLen)
      /* space is enough for copying */
      /* copy by value */ 
      {
        (*pSQLStatement)->cbLen        = StmtNameDesc->SQLStatement->cbLen;   
        (*pSQLStatement)->encodingType = StmtNameDesc->SQLStatement->encodingType;   
        memcpy((*pSQLStatement)->rawString, StmtNameDesc->SQLStatement->rawString, StmtNameDesc->SQLStatement->cbLen)
          M90TRACE(M90_TR_EXIT, "pr01StmtNameGetSQL", 0);
        return(1);
      }
    return (0);
  }
}

/*!
  Function:     pr01StmtNameTraceStmtName

  see also: 
  
  Description: Puts statement name to trace  
  
  Arguments:
    StmtNameDesc [in] pointer to tpr01_StmtNameDesc
    sqlca        [in] sqlca area
    
  return value: void
 */
static void pr01StmtNameTraceStmtName (struct tpr01_StmtNameDesc *StmtNameDesc, sqlcatype *sqlca)
{
  sqlratype *sqlrap = sqlca->sqlrap;
  sqltatype      *tap = sqlrap->rasqltap;  
  short           *ll = &sqlrap->rasqltap->tastr80l;
  struct SQLERROR errmsg;
  *ll = sp77sprintfUnicode (sp77encodingUTF8,
                            tap->tastr80,
                            sizeof(tap->tastr80),
                            "Statement Name : %=.*S",
                            StmtNameDesc->StmtNameStruct.stStmtName.encodingType,
                            StmtNameDesc->StmtNameStruct.stStmtName.cbLen, 
                            StmtNameDesc->StmtNameStruct.stStmtName.rawString);  
  p03tvfwritetrace (sqlrap, &errmsg);
}

static void pr01StmtNameDropParsId(tpr01_StmtNameDesc *StmtNameDesc, tpr01_SQLDesc *SQLDesc)
{
  if (SQLDesc->ConDesc) {
    sqlcatype *sqlca = SQLDesc->ConDesc->sqlca;
    sqlxatype *sqlxa = SQLDesc->ConDesc->sqlxa;
    sqlgaentry *ga   = SQLDesc->ConDesc->ga;
    sqlkaentry *ka = StmtNameDesc->ka;  
    if (!pr06ParseIdIsEqual(&ka->kaParseInfo.ParseId, ParseIdNull_cpr00)) {    
      p01bdrop_parsid (sqlca, sqlxa, ka->kaParseInfo.ParseId);
      pr06ParseIdDrop(sqlca, sqlxa, ga, (tpr06_ParseIDCache *)SQLDesc->ConDesc->ParseIdCache, &ka->kaParseInfo.ParseId);
      StmtNameDesc->ka->kastate = cpr_state_empty;
      StmtNameDesc->ka->kaParseInfo.sp1rFunctionCode = csp1_nil_fc;  
    }
  }
}

static void pr01StmtNameSetState(struct tpr01_StmtNameDesc *StmtNameDesc, tpr01_SQLStateBinary State)
{
  if (State != Empty_bpr01)
    StmtNameDesc->State |= State;
  else
    StmtNameDesc->State = State;
}

/*!
  Function:     pr01StmtName_InitStmtNameStruct

  see also: 
  
  Description:  initialized a tpr00_StmtNameStruct

  Arguments:
    StmtNameStruct [in] tpr00_StmtNameStruct
 
  return value: void
 */
static void pr01StmtName_InitStmtNameStruct (tpr00_StmtNameStruct *StmtNameStruct)
{
  StmtNameStruct->stStmtName.allocationType = constant_epr05;
  pr05IfCom_String_InitString(&(StmtNameStruct->stStmtName), 
                              &(StmtNameStruct->private_StrBuf), 
                              sizeof(StmtNameStruct->private_StrBuf), 
                              sp77encodingAscii, 
                              constant_epr05);
}

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
