/*
  -----------------------------------------------------------------------------

  module: vls31_catalogextract.cpp

  -----------------------------------------------------------------------------

  responsible:  d033893 and SteffenS

  special area: SAP DB LOADER

  description:  Implementation of the CATALOGEXTRACT/CATALOGLOAD functionality

  version:      7.5.

  -----------------------------------------------------------------------------


    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

#include "gls00.h"
#include "hls03.h"
#include "hls15.h"
#include "hls30.h"
#include "hls99.h"
#include "hls31_odbc_Result.h"
#include "hls31_catalogextract.h"

/* -----------------------------------------------------------------------------
   ls31ExecCatalogTransformation
/-------------------------------------------------------------------------------*/
SAPDB_Int4
ls31ExecCatalogTransformation(tls00_Command  *pTransformationCmd,
                              tls00_DBInfo   *pDBInfo,
                              tsp00_Addr      ErrText)
{
    ROUTINE_DBG_MEO00 ("ls31ExecCatalogTransformation");

    SAPDB_Int4        rc            = errOK_els00;
    RepServMessages  *pMsgInstance  = RepServMessages::Instance();

    MetaDataDef       *pMetaDataDef = new MetaDataDef( pDBInfo );
	tls00_CatExtrCmd*  pCatExtrCmd  = NULL;
    tls00_CatLoadCmd*  pCatLoadCmd  = NULL;

	StudioOAL_String   transformationpackage;
	StudioTD_String    username;

    tls00_FileInfo     streamInfo;

	// interpret <catalogextract statement>::=
    // catalogextract <part_spec> OUTFILE <external_file_spec>;
    // <part_spec> :: = all | user | table
    if (srFctCatExtr_els00 == pTransformationCmd->cmdScanRC_ls00)
    {
        pCatExtrCmd = REINTERPRET_CAST( tls00_CatExtrCmd*, pTransformationCmd->cmdScnDat_ls00 );
        pMetaDataDef->setPartSpec( pCatExtrCmd->cexPartSpec_ls00);

        streamInfo.fileSpec = pCatExtrCmd->cexOutfile_ls00;

        if ( SAPDB_TRUE == pCatExtrCmd->cexOutfile_ls00.fsFormat_ls00.ffoXml_ls00 )
            pMetaDataDef->setExtrMode(emExtractAsXML_els00);
        else
            pMetaDataDef->setExtrMode(emExtractAsDDL_els00);
    }
	// interpret <catalogload statement>::=
    // catalogload    <part_spec> INFILE <external_file_spec>;
    // <part_spec> :: = all | user | table
    else if (srFctCatLoad_els00 == pTransformationCmd->cmdScanRC_ls00)
    {
        pCatLoadCmd = REINTERPRET_CAST( tls00_CatLoadCmd*, pTransformationCmd->cmdScnDat_ls00 );
        pMetaDataDef->setPartSpec( pCatLoadCmd->cloPartSpec_ls00);

        streamInfo.fileSpec = pCatLoadCmd->cloInfile_ls00;

        if ( SAPDB_TRUE == pCatLoadCmd->cloInfile_ls00.fsFormat_ls00.ffoXml_ls00 )
            pMetaDataDef->setExtrMode(emLoadAsXML_els00);
        else
            pMetaDataDef->setExtrMode(emLoadAsDDL_els00);
    }
    //*
    //*   check if user is sysdba
    //*
    if (ptAll_els00 == pMetaDataDef->getPartSpec().psPartType_ls00)
    {
        rc = ls15CheckUserMode(pDBInfo, pDBInfo->dbiSession_ls00.siUserName_ls00.asCharp(),dbuSysdba_els00, ErrText);
        if (errOK_els00 != rc)
        {
            if (dbRowNotFound_els00 == rc)
            {
                 pMsgInstance->ls98Msg(layTableExtract_els98, ErrText, errRestrictedStmt_els98);
                 rc = errRestrictedStmt_els98;
            }
        }
    }
    if ( errOK_els00 == rc  )
    {
		//*
		//*  configure transformationpackage
		//*
		transformationpackage = "LOAD TRANSFORMATIONPACKAGE";

		rc = ls31LoadTransformationPackage( pMetaDataDef, pTransformationCmd, ErrText );

		TransformationDef * pTransformationDef = pMetaDataDef->getTransformationModel();

		//*
		//*  initialize stream
		//*
		streamInfo.vFile.vfFileType_ls00   = streamInfo.fileSpec.fsDeviceType_ls00;

		if ( dtypeTape_ls00 == streamInfo.fileSpec.fsDeviceType_ls00 )
		{
			streamInfo.vFile.vfBackupTool_ls00 = pDBInfo->dbiSession_ls00.siBackupTool_ls00;
			streamInfo.vFile.vfNodeName_ls00.ConvertFromASCII_Latin1(pDBInfo->dbiSession_ls00.si_pDBNode_ls00,
																	 pDBInfo->dbiSession_ls00.si_pDBNode_ls00 + _tcslen(pDBInfo->dbiSession_ls00.si_pDBNode_ls00));
			streamInfo.vFile.vfDBName_ls00.ConvertFromASCII_Latin1(pDBInfo->dbiSession_ls00.siDBName_ls00,
																   pDBInfo->dbiSession_ls00.siDBName_ls00+_tcslen(pDBInfo->dbiSession_ls00.siDBName_ls00));
		}

		//*
		//* extract catalog ddl, xml
		//*
		if (srFctCatExtr_els00 == pTransformationCmd->cmdScanRC_ls00)
		{
			ls30VFInitialize(streamInfo.vFile, pCatExtrCmd->cexOutfile_ls00.fsFileName_ls00, sp5vf_text, sp5vf_write, ctUTF8_els00);
			rc = ls30VFOpen (streamInfo.vFile,ErrText);

			if ( rc != errOK_els00 )
				return rc;

			pMetaDataDef->setMedium( streamInfo );
			//*
			//*  storagedevice, servernode, serverdb, username, codetype, codepage, transformation, part, streamformat
			//*
			rc = ls31UpdateTransformationPackage( pMetaDataDef, pTransformationCmd, ErrText);
			//*
			//*  execute transformationpackage
			//*
			transformationpackage = "EXECUTE PACKAGE TO TRANSFORM CATALOG";

			pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgCommandExecuting_els98, transformationpackage.StrPtr());

			if ( ptTable_els00  < pCatExtrCmd->cexPartSpec_ls00.psPartType_ls00 )
			{
				TransformationDef * pTransformationDef = pMetaDataDef->getTransformationModel();
				pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgNumTabToTransform_els98    ,pTransformationDef->m_nTableCount);
				pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgNumViewToTransform_els98   ,pTransformationDef->m_nViewCount);
				pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgNumSynonymToTransform_els98,pTransformationDef->m_nSynonymCount);
		    }

			username.ConvertFromASCII_Latin1(pDBInfo->dbiSession_ls00.siUserName_ls00.asCharp(),
											 pDBInfo->dbiSession_ls00.siUserName_ls00.asCharp() +
											 pDBInfo->dbiSession_ls00.siUserName_ls00.length () );

			//*
			//*  update  transformationpackage
			//*
			if (ptAll_els00 == pCatExtrCmd->cexPartSpec_ls00.psPartType_ls00)
				rc = pMetaDataDef->ExtrCatalogCmd(username);
			else if ( ptUser_els00  == pCatExtrCmd->cexPartSpec_ls00.psPartType_ls00 )
				rc = pMetaDataDef->ExtrSchemaCmd(username);
			else if (ptTable_els00 == pCatExtrCmd->cexPartSpec_ls00.psPartType_ls00)
				rc = pMetaDataDef->ExtrTableCmd( pCatExtrCmd->cexPartSpec_ls00 );

			SAPDB_Int4 rcFile = ls30VFClose(streamInfo.vFile,ErrText);
			if ( (errOK_els00 == rc) && (errOK_els00 != rcFile) )
				 rc = rcFile;

			//*
			//*  storagedevice, servernode, serverdb, username, codetype, codepage, transformation, part, streamformat
			//*
			if ( (dtypeTape_ls00 == pCatExtrCmd->cexOutfile_ls00.fsDeviceType_ls00) &&
				 (ptTable_els00   < pCatExtrCmd->cexPartSpec_ls00.psPartType_ls00 )   )
			{
				pCatExtrCmd->cexOutfile_ls00.fsBackupId_ls00.bBackupIdName_ls00 = REINTERPRET_CAST(SAPDB_Char *,(CONST_CAST (unsigned char* ,streamInfo.vFile.vfBackupId_ls00.StrPtr())));
				rc = ls31UpdateTransformationPackage( pMetaDataDef, pTransformationCmd, ErrText);
			}
			//*
			//*  unload  transformationpackage
			//*
			transformationpackage = "UNLOAD TRANSFORMATIONPACKAGE x'";
		    transformationpackage += pDBInfo->dbiPackageid_ls00;
		    transformationpackage += "'";

		    SAPDB_Int4 rcUnload = ls31UnloadTransformationPackage( pMetaDataDef, pTransformationCmd, ErrText);

		}// if (srFctCatExtr_els00 == pTransformationCmd->cmdScanRC_ls00)

		//*
		//* load catalog ddl
		//*
		else if (srFctCatLoad_els00 == pTransformationCmd->cmdScanRC_ls00)
		{
			if ( dtypeTape_ls00 == pCatLoadCmd->cloInfile_ls00.fsDeviceType_ls00 )
			{
				streamInfo.vFile.vfBackupId_ls00.ConvertFromASCII_Latin1(streamInfo.fileSpec.fsBackupId_ls00.bBackupIdName_ls00,
																		 streamInfo.fileSpec.fsBackupId_ls00.bBackupIdName_ls00+
																_tcslen( streamInfo.fileSpec.fsBackupId_ls00.bBackupIdName_ls00));
			}

			ls30VFInitialize(streamInfo.vFile, pCatLoadCmd->cloInfile_ls00.fsFileName_ls00, sp5vf_text, sp5vf_read, ctUTF8_els00);
			rc = ls30VFOpen (streamInfo.vFile, ErrText);
			if (errOK_els00 == rc)
			{
				pMetaDataDef->setMedium( streamInfo );

				username.ConvertFromASCII_Latin1(pDBInfo->dbiSession_ls00.siUserName_ls00.asCharp(),
												 pDBInfo->dbiSession_ls00.siUserName_ls00.asCharp() +
												 pDBInfo->dbiSession_ls00.siUserName_ls00.length() );

				//*
			    //*  execute transformationpackage
			    //*
				if (ptAll_els00 == pCatLoadCmd->cloPartSpec_ls00.psPartType_ls00)
					rc = pMetaDataDef->LoadCatalogCmd(username);
				else if ( ptUser_els00 == pCatLoadCmd->cloPartSpec_ls00.psPartType_ls00)
					rc = pMetaDataDef->LoadSchemaCmd(username);
				else if (ptTable_els00 == pCatLoadCmd->cloPartSpec_ls00.psPartType_ls00)
					rc = pMetaDataDef->LoadTableCmd( pCatLoadCmd->cloPartSpec_ls00 );

				SAPDB_Int4 rcFile = ls30VFClose(streamInfo.vFile,ErrText);
				if ( (errOK_els00 == rc) && (errOK_els00 != rcFile) )
					rc = rcFile;

				transformationpackage = "LOAD TRANSFORMATIONPACKAGE";

				if (errOK_els00 == rc)
				{
					pTransformationDef->unload( pMetaDataDef->getConnection()->dbiOdbcConnection);
					//*
					//*  storagedevice, servernode, serverdb, username, codetype, codepage, transformation, part, streamformat
					//*
					rc = ls31UpdateTransformationPackage( pMetaDataDef, pTransformationCmd, ErrText);

				}
				if (errOK_els00 != rc)
				{
					sapdb_Error *pError = pMetaDataDef->getError();
					pMsgInstance->ls98MsgToString(layTableExtract_els98, ErrText, STATIC_CAST(ErrorNumbers, rc), pError->getErrorText().StrPtr());
				}

				transformationpackage = "EXECUTE PACKAGE TO TRANSFORM CATALOG";

				pMsgInstance->ls98PrintMessage(layCatalogLoad_els98, msgCommandExecuting_els98, transformationpackage.StrPtr());

				if ( ptTable_els00  < pCatLoadCmd->cloPartSpec_ls00.psPartType_ls00  )
				{
					pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgNumTabTransformed_els98     ,pTransformationDef->m_nTableCount);
					pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgNumViewsTransformed_els98   ,pTransformationDef->m_nViewCount);
					pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgNumSynonymsTransformed_els98,pTransformationDef->m_nSynonymCount);
				}
                //*
				//*  unload  transformationpackage
				//*
				transformationpackage = "UNLOAD TRANSFORMATIONPACKAGE x'";
				transformationpackage += pDBInfo->dbiPackageid_ls00;
				transformationpackage += "'";

				SAPDB_Int4 rcUnload = ls31UnloadTransformationPackage( pMetaDataDef, pTransformationCmd, ErrText);

			}
		}// if (srFctCatLoad_els00 == pTransformationCmd->cmdScanRC_ls00)

	}// ls31LoadTransformationPackage

    if ( pMetaDataDef != NULL )
    {
        delete pMetaDataDef;
        pMetaDataDef = NULL;
    }

    return rc;
}
//ls31ExecCatalogTransformation()

/*
  -----------------------------------------------------------------------------
  function:     ls27LoadTransformationPackage
  -----------------------------------------------------------------------------
*/
tsp00_Int4
ls31LoadTransformationPackage ( MetaDataDef      *&pMetaDataDef,
                                tls00_Command    *pTransformationCmd,
                                tsp00_Addr        ErrText)
{
    ROUTINE_DBG_MEO00 ("ls31LoadTransformationPackage");

    RepServMessages *pMsgInstance = RepServMessages::Instance();
    SAPDB_Long rc = errOK_els00;

	if ( NULL != pMetaDataDef )
	{
		tls00_DBInfo  *pDBInfo = pMetaDataDef->getConnection();

		//*
		//*  packageid, taskid, stepid, owner, tablename, tabletype
		//*
		if ( pMetaDataDef->initResultSets(pDBInfo) )
		{
 			 TransformationDef * pTransformationDef = pMetaDataDef->getTransformationModel();
			 assert ( pTransformationDef!=NULL );
		}
	}

	return rc;
}

/* -----------------------------------------------------------------------------
   ls31UpdateTransformationPackage
/-------------------------------------------------------------------------------*/
tsp00_Int4 ls31UpdateTransformationPackage( MetaDataDef      *pMetaDataDef,
                                        tls00_Command    *pTransformationCmd,
                                        tsp00_Addr       ErrText)
{
     ROUTINE_DBG_MEO00 ("ls31UpdateTransformationPackage");

     SAPDB_Int4  rc = errOK_els00;

     RepServMessages *pMsgInstance  = RepServMessages::Instance();

     TransformationDef * pTransformationDef = pMetaDataDef->getTransformationModel();
	 tls00_DBInfo     *  pDBInfo            = pMetaDataDef->getConnection();

     SAPDB_Bool       Error       = SAPDB_TRUE;
     SAPDB_Long       NativeError= 0;
     SAPDB_Int4       ErrorPos   = 0;
     SQLRETURN        ReturnCode = 0;
     StudioOAL_String ErrorText;
     StudioOAL_String NativeErrorAsString;

     //*
     //*  update transformation table columns:
     //*  taskid, storagedevice, servernode, serverdb, username, codetype, codepage, transformation, part, streamformat
     //*

      StudioTD_String  servernode;
      StudioTD_String  serverdb;
      StudioTD_String  codetype;
      StudioTD_String  codepage;
      StudioTD_String  username;
      StudioOAL_String catalogstreamname;
      StudioOAL_String catalogstreamebid ;

      StudioOAL_String parameter[13];

      SAPDB_Char   destBeg[1000] ;
      SAPDB_UInt4  destAt  = 1000;

      // packageid
      parameter[0]  = "0";
      // servernode
      parameter[1]  = "'";
      memset(destBeg,0,sizeof(destBeg));
      pMetaDataDef->getConnection()->dbiOdbcConnection.GetServerNode( REINTERPRET_CAST(unsigned char*, destBeg ), destAt);
      servernode.ConvertFromASCII_Latin1( destBeg, destBeg+strlen(destBeg));
      parameter[1] += servernode;
      parameter[1] += "'";
      // serverdb
      parameter[2]  = "'";
      memset(destBeg,0,sizeof(destBeg));
      pMetaDataDef->getConnection()->dbiOdbcConnection.GetServerDb ( REINTERPRET_CAST(unsigned char*,destBeg ),destAt);
      serverdb.ConvertFromASCII_Latin1( destBeg, destBeg+strlen(destBeg));
      parameter[2] += serverdb;
      parameter[2] += "'";

      // codetype
      parameter[3] = pszCodeTypeValue_ls00[pDBInfo->dbiSession_ls00.siCodeType_ls00];

      // username
      parameter[4]  = "'";
      memset(destBeg,0,sizeof(destBeg));
      pMetaDataDef->getConnection()->dbiOdbcConnection.GetUser( REINTERPRET_CAST(unsigned char*,destBeg ),destAt);
      username.ConvertFromASCII_Latin1( destBeg, destBeg+strlen(destBeg));
      parameter[4] += username;
      parameter[4] += "'";

      // codepage
      if (ctAscii_els00 == pDBInfo->dbiSession_ls00.siCodeType_ls00)
      {
          parameter[5]  = "'";
          parameter[5] += pDBInfo->dbiSession_ls00.siCodePage_ls00.name.asCharp();
          parameter[5] += "'";
      }

      // storagedevice
      parameter[6]  = pszBackupToolValue_ls00[pDBInfo->dbiSession_ls00.siBackupTool_ls00];
      // transformation
      parameter[7]  = "'EXTRACT'";

      switch (pTransformationCmd->cmdScanRC_ls00)
      {
            case srFctCatExtr_els00:
            {
                  tls00_CatExtrCmd* pCatExtrCmd = REINTERPRET_CAST( tls00_CatExtrCmd*, pTransformationCmd->cmdScnDat_ls00 );

                  // part
                  if (ptAll_els00 == pCatExtrCmd->cexPartSpec_ls00.psPartType_ls00)
                      parameter[8]  = "'ALL'";
                  if (ptUser_els00 == pCatExtrCmd->cexPartSpec_ls00.psPartType_ls00)
                      parameter[8]  = "'USER'";
                  if (ptTable_els00 == pCatExtrCmd->cexPartSpec_ls00.psPartType_ls00)
                      parameter[8]  = "'TABLE'";

                  // catalogstreamname
                  if ( NULL != pCatExtrCmd->cexOutfile_ls00.fsFileName_ls00 )
                  {
                     _TCHAR* pszDest = strrchr(pCatExtrCmd->cexOutfile_ls00.fsFileName_ls00, SLASH_LS00);
                     if (NULL == pszDest)
                        pszDest = strrchr(pCatExtrCmd->cexOutfile_ls00.fsFileName_ls00, BACKSLASH_LS00);
                        if (NULL == pszDest)
                            pszDest = pCatExtrCmd->cexOutfile_ls00.fsFileName_ls00;
                     pszDest = (pszDest == pCatExtrCmd->cexOutfile_ls00.fsFileName_ls00) ? pszDest : pszDest + 1;

                     catalogstreamname.ConvertFromASCII_Latin1(pszDest,pszDest + _tcslen(pszDest) );

                     parameter[9]  = "'";
                     parameter[9] += catalogstreamname;
                     parameter[9] += "'";
                  }
                  // catalogstreamtype

                  parameter[10] = pszDeviceTypeValue_ls00[pCatExtrCmd->cexOutfile_ls00.fsDeviceType_ls00];

                  if ( dtypeTape_ls00 == pCatExtrCmd->cexOutfile_ls00.fsDeviceType_ls00 )
                  {
					  if ( NULL == pCatExtrCmd->cexOutfile_ls00.fsBackupId_ls00.bBackupIdName_ls00 )
  			               parameter[11] = catalogstreamebid.AssignRaw(REINTERPRET_CAST(unsigned char*, pDBInfo->dbiSession_ls00.siNullSpec_ls00.asCharp()),
								  						                                        _tcslen(pDBInfo->dbiSession_ls00.siNullSpec_ls00.asCharp()));
			          else
                           parameter[11] = catalogstreamebid.AssignRaw(REINTERPRET_CAST(unsigned char*, pCatExtrCmd->cexOutfile_ls00.fsBackupId_ls00.bBackupIdName_ls00),
                                                                                                _tcslen(pCatExtrCmd->cexOutfile_ls00.fsBackupId_ls00.bBackupIdName_ls00));
                  }

                  // catalogstreamformat
                  if  ( true == pCatExtrCmd->cexOutfile_ls00.fsFormat_ls00.ffoXml_ls00 )
                        parameter[12]  =  "'XML'";
                  else
                        parameter[12]   = "'DDL'";

                  break;

            }
            case srFctCatLoad_els00:
            {
                  tls00_CatLoadCmd* pCatLoadCmd = REINTERPRET_CAST( tls00_CatLoadCmd*, pTransformationCmd->cmdScnDat_ls00 );

                  // part
                  if (ptAll_els00   == pCatLoadCmd->cloPartSpec_ls00.psPartType_ls00)
                      parameter[8]   = "'ALL'";
                  if (ptUser_els00  == pCatLoadCmd->cloPartSpec_ls00.psPartType_ls00)
                      parameter[8]   = "'USER'";
                  if (ptTable_els00 == pCatLoadCmd->cloPartSpec_ls00.psPartType_ls00)
                      parameter[8]   = "'TABLE'";

                  // catalogstreamname
                  if ( NULL != pCatLoadCmd->cloInfile_ls00.fsFileName_ls00 )
                  {
                     _TCHAR* pszDest = strrchr(pCatLoadCmd->cloInfile_ls00.fsFileName_ls00, SLASH_LS00);
                     if (NULL == pszDest)
                     {
                        pszDest = strrchr(pCatLoadCmd->cloInfile_ls00.fsFileName_ls00, BACKSLASH_LS00);
                        if (NULL == pszDest)

                            pszDest = pCatLoadCmd->cloInfile_ls00.fsFileName_ls00;

                     }
                     pszDest = (pszDest == pCatLoadCmd->cloInfile_ls00.fsFileName_ls00) ? pszDest : pszDest + 1;

                     catalogstreamname.ConvertFromASCII_Latin1(pszDest,pszDest + _tcslen(pszDest) );

                     parameter[9]  = "'";
                     parameter[9] += catalogstreamname;
                     parameter[9] += "'";
                  }
                  // catalogstreamtype

                  parameter[10] = pszDeviceTypeValue_ls00[pCatLoadCmd->cloInfile_ls00.fsDeviceType_ls00];

                  // catalogstreamformat
                  if  ( true == pCatLoadCmd->cloInfile_ls00.fsFormat_ls00.ffoXml_ls00 )
                        parameter[12]  =  "'XML'";
                  else
                        parameter[12]   = "'DDL'";
                  break;
            }
      }// switch (pTransformationCmd->cmdScanRC_ls00)

      if ( !pTransformationDef->updateCatTask(parameter))
      {
            Error               = pTransformationDef->isError();
            NativeError         = pTransformationDef->getNativeError();
            ErrorPos            = pTransformationDef->getErrorPos();
            ReturnCode          = pTransformationDef->getReturnCode();
            ErrorText           = pTransformationDef->getErrorText();
            NativeErrorAsString = pTransformationDef->getNativeErrorAsString();

            pMsgInstance->ls98PrintMessage(layTableExtract_els98, errODBCErrors_els98, NativeErrorAsString.StrPtr());

      }

     return rc;

}//ls31UpdateTransformationPackage


/* -----------------------------------------------------------------------------
   ls31UnloadTransformationPackage
/-------------------------------------------------------------------------------*/
tsp00_Int4
ls31UnloadTransformationPackage(MetaDataDef      *pMetaDataDef,
                            tls00_Command    *pTransformationCmd,
                            tsp00_Addr       ErrText)
{
    ROUTINE_DBG_MEO00 ("ls31UnloadTransformationPackage");

	 RepServMessages *pMsgInstance = RepServMessages::Instance();
    SAPDB_Long       rc = errOK_els00;

	TransformationDef * pTransformationDef = pMetaDataDef->getTransformationModel();
	tls00_DBInfo      * pDBInfo            = pMetaDataDef->getConnection();

	Tools_DynamicUTF8String transformationpackage;
	transformationpackage = "UNLOAD TRANSFORMATIONPACKAGE ";
	transformationpackage += "x'";
	transformationpackage += pDBInfo->dbiPackageid_ls00;
	transformationpackage += "'";

	_TCHAR sztransformation[4096];

	tls00_CatExtrCmd*  pCatExtrCmd  = NULL;
    tls00_CatLoadCmd*  pCatLoadCmd  = NULL;

	 if (srFctCatExtr_els00 == pTransformationCmd->cmdScanRC_ls00)
	 {
        pCatExtrCmd = REINTERPRET_CAST( tls00_CatExtrCmd*, pTransformationCmd->cmdScnDat_ls00 );
		if ( pCatExtrCmd->cexInternal_ls00 == SAPDB_FALSE )
		{
			 sztransformation[0] = 0;
			 sp77sprintf(sztransformation, 4096, DEL_MAP_TABLE_ALL_73_LS00, pDBInfo->dbiPackageid_ls00.StrPtr());
			 pTransformationDef->executeSQL(sztransformation);
			 pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgCommandExecuting_els98, transformationpackage.StrPtr());
		}
	 }
     if (srFctCatLoad_els00 == pTransformationCmd->cmdScanRC_ls00)
	 {
		 pCatLoadCmd = REINTERPRET_CAST( tls00_CatLoadCmd*, pTransformationCmd->cmdScnDat_ls00 );
		 if ( pCatLoadCmd->cloInternal_ls00 == SAPDB_FALSE )
		 {
			  sztransformation[0] = 0;
			  sp77sprintf(sztransformation, 4096, DEL_MAP_TABLE_ALL_73_LS00, pDBInfo->dbiPackageid_ls00.StrPtr());
			  pTransformationDef->executeSQL(sztransformation);
			  pMsgInstance->ls98PrintMessage(layCatalogExtract_els98, msgCommandExecuting_els98, transformationpackage.StrPtr());
		 }
	 }

     return STATIC_CAST(tsp00_Int4, rc);

}//ls31UnloadTransformationPackage

/*===========================================================================*
 *     END
 *===========================================================================*/
