/*! 
  -----------------------------------------------------------------------------
 
  module: hls40cli.h
 
  -----------------------------------------------------------------------------
 
  responsible:  SteffenS
 
  special area: SAP DB Loader
 
  description:  SAP DB Loader CommandLineInterface (LoaderCLI)

  version:      7.4

  -----------------------------------------------------------------------------
 
  copyright:    (c) 1997-2004 SAP AG-2003
 
  -----------------------------------------------------------------------------



    ========== licence begin  GPL
    Copyright (c) 1997-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*/

#ifndef HLS40CLI
#define HLS40CLI

/* ------------------------------------------------------------------
 * includes
 * ------------------------------------------------------------------
 */
#if defined (_WIN32)
  #include <windows.h>
#else
  #define WINAPI
#endif

#ifndef MAX_CRYPT
  #define MAX_CRYPT csp_cryptname
#endif

static const char   *C_COMPONENT  = "repmcli                                                        ";


const char*        DEFAULT_PGM_L  = "lserver";
const char* const  CMD_SQLDEFAULT = "SQLMODE INTERNAL;";
const char* const  REPMAN_ERR_STR = "ERR";
const char* const  REPMAN_CON_STR = "CON";
const char         NULLCHAR       = '\0';

#define PRG_OK               0
#define PRG_FATAL           -1
#define PRG_VERYFATAL       -2
#define PRG_SHOW            -3      // used to release option parser (only help or version requested)
#define PRG_SERVER_ERROR    -4
#define PRG_CMD_ERROR       -5


// Answer header size from server containing either 'ERR\n' or 'OK \n'
#define REPLY_HEADER_SIZE_LS40   4

// Defines read buffer size when reading from batch file
const unsigned long MAXBUFFERSIZE_LS40 = 32768;


#define MAX_PARAM_LS40  9

// definition corresponds to the biggest possible message buffer
// that can be exchanged between server and db server
#define MAX_COMMAND_LENGTH_LS40 128*1024

#define MAX_CMD_SEPARATOR_LENGTH_LS40     2
#define DEFAULT_CMD_SEPARATOR_LENGTH_LS40 2

typedef enum
{
    rncLocal_els40,
    rncDBNode_els40,
    rncDifferent_els40
} tls40_RepmNodeLoc;

typedef struct tls40_CmdSeparator
{
    bool  csDefaultSeparator;
    char  csCmdSeparator_ls40[3];

} tls40_CmdSeparator;

typedef struct ls40_Options
{
    char              *application;
    char               dbuser[128];
    char              *dbname;
    tsp00_Pathc        szDBRoot_ls40;
    tls40_RepmNodeLoc  NodeLoc;

    const char        *db_node;
    
    const char        *repm_node;
    
    const char        *serverpgm;

    char              *pszInfileName;
    FILE              *infile;

    char              *pszOutfileName;
    FILE              *outfile;

    void              *session;

    _TCHAR            *pszCommBuffer_ls40;
    _TCHAR            *pszCmdBuffer;
    tsp00_Longint      CmdBufferLen;

    tls40_CmdSeparator CmdSeparator_ls40;

    _TCHAR            *pszReplyBuffer;
    tsp00_Int4         ReplyBufferLen;

    tsp00_Int4         CmdExecError;
    tsp00_Int4         BatchErrorCnt_ls40;

    _TCHAR            *pszParamList_ls40[MAX_PARAM_LS40];
    
    bool               bNoParam_ls40;

    bool               showServerVersion;
    
    bool               bSuppressOutput_ls40;
    
    bool               bStaticServer_ls40;

    bool               bInteractive_ls40;

    bool               bRelease_ls40;

    BOOLEAN            bCancelByte_ls40;
} ls40_Options;


#endif /* HLS40CLI */
