/*!
  @file           heo95.h
  @author         JoergM
  @special area   application startup Program
  @brief          description ...
  @see            example.html ...

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
*/



#ifndef HEO95_H
#define HEO95_H



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <stdlib.h>

#ifdef WIN32
#include <windows.h>
#include <process.h>
#include <sys/utime.h>
#include <direct.h>

#define F_READ  0200

#else

#include        <unistd.h>
#include        <utime.h>
#include        <errno.h>
#include        <termio.h>
#if ! T31 && ! T33 && ! T35
#include        <termios.h>
#endif
#if SVR4
#include        <wait.h>
#else
#if SCO
#include        <sys/wait.h>
#endif
#endif


#define TERM   "TERM"
#define DBTERM "DBTERM"

#define F_READ  S_IRUSR

#endif


#include "heo01.h"

/*-----------------------------------------------------------------------*/

/*-------------------------- global defines -----------------------------*/

#define EXPORT
#define IMPORT extern

#define CNULL  (char *) 0
#define TRUE            1
#define FALSE           0
#define NOTOK          -1
#define NO_TERM     FALSE
#define INIT_TERM    TRUE
#define INIT_WIN        2

#define MAX_DBNAME_LEN 8
#define MAX_HLP_FILES 10
#define MAX_HLP_LINE_LEN 80

#define HELP_ID  "h"
#define ALTERNATE_HELP_ID "?"
#define NO_HELP         (char **) 0
#define NOT_AVAIL       ""
#define NO_ALTERN       CNULL

/*--------------------- environment-vars using by SQL-DB ---------------*/

enum ProgramExecPathType
  {
    IndependentPGM,
    IndependentBIN,
    DbrootPGM,
    DbrootBIN,
	DbrootSAP
  };

/*------------------- permissions using by stat / open-------------------*/
#define F_EX 0
#define F_WRITE 0400
#define F_RW 0600
#define F_RWX 0700

#define ADABAS_KERNELS     { "kernel","quickknl","slowknl", "omststknl" }
#define ADABAS_GATEWAYS    { "fstgwada","qckgwada","slwgwada" }
#define ORACLE_GATEWAYS    { "fstgwora","qckgwora","slwgwora" }

/*-------------------------- USAGES for bad parameters ------------------*/
#define PRI_USAGE(x) { { printf x; } }
#define SQL_HELP_HEADER "\ncorrect use of %s is:\n\n"

#define SQL_USAGE "USAGE: "

#define USAGE_CLEAR(progname) \
        PRI_USAGE (("\n%s %s <serverdb>\n", SQL_USAGE, progname ))

#define USAGE_SHOW(progname) \
        PRI_USAGE (("\n%s %s [-c]\n", SQL_USAGE, progname ))


#if _WIN32
#define USAGE_SERVER(progname) \
        PRI_USAGE (("\n%s %s [ %s | %s | %s | %s ]\n", SQL_USAGE, progname, \
                  SERVER_OPT_START, SERVER_OPT_STOP,                        \
                  SERVER_OPT_INSTALL, SERVER_OPT_REMOVE ));
#else
#define USAGE_SERVER(progname) \
        PRI_USAGE (("\n%s %s [ %s | %s ]\n", SQL_USAGE, progname, \
                                      SERVER_OPT_START, SERVER_OPT_STOP ));
#endif

/*-------------------------- defines OS/2 and WIN32 -------------------------*/
#ifdef WIN32

#define USAGE_CONS(progname) \
        PRI_USAGE (("\n%s %s [<dbname>] <command>\n", SQL_USAGE, progname ))

#  define       IS_OPT_CHR(c) ( c == '-' || c == '/' )
#  define       TERMIO_INFO             int
#  define       GET_TERMIO(f,t)
#  define       SET_TERMIO(f,t)

#define BEG_ENV_VAR '%'
#define END_ENV_VAR '%'

#define SQLDB_START  "x_start" , "xstart", DbrootPGM, "start.exe\0strt.exe\0", NO_TERM
#define SQLDB_GWSTART  "x_gwstart" , "xgwstart", DbrootPGM, "strt.exe\0" , NO_TERM
#define SQLDB_STOP   "x_stop"  , "xstop" , DbrootPGM, "stop.exe\0stp.exe\0", NO_TERM
#define SQLDB_CONS   "x_cons"  , "xcons" , DbrootPGM, "cons.exe\0"       , NO_TERM
#define SQLDB_SHOW   "x_show"  , "xshow" , DbrootPGM, "show.exe\0"       , NO_TERM
#define SQLDB_SERV   "x_server","xserver", IndependentPGM, "serv.exe\0"  , NO_TERM
#define SQLDB_DIAG   "x_diag" , "x_diagnose", DbrootPGM, "diagnose.exe\0", INIT_TERM
#define SQLDB_QUERY  "xquery" , NO_ALTERN, DbrootPGM, "query.exe\0"      , INIT_TERM
#define SQLDB_LOAD   "xload"  , NO_ALTERN, DbrootPGM, "load.exe\0"       , INIT_TERM
#define SQLDB_PYTHON "x_python",NO_ALTERN, DbrootPGM, "pysapdb.exe\0"    , NO_TERM
#define SQLDB_EASY   "xeasy"  , NO_ALTERN, DbrootPGM, "easy.exe\0"       , INIT_TERM
#define SQLDB_PL     "xpl"    , NO_ALTERN, DbrootPGM, "sqlpl.exe\0"      , INIT_TERM
#define SQLDB_PLRUN  "xplrun" , NO_ALTERN, DbrootPGM, "plrun.exe\0"      , INIT_TERM
#define SQLDB_TOPL   "xtopl"  , NO_ALTERN, DbrootPGM, "topl.exe\0"       , INIT_TERM
#define SQLDB_TOPLR  "xtplrun", NO_ALTERN, DbrootPGM, "tplrun.exe\0"     , INIT_TERM
#define SQLDB_USER   "xuser"  , NO_ALTERN, IndependentBIN, "xuserUnicode.exe\0"      , NO_TERM
#define SQLDB_AUDIT  "xaudit" , NO_ALTERN, DbrootPGM, "audit.exe\0"      , INIT_TERM
#define SQLDB_CPC    "cpc"    , NO_ALTERN, DbrootPGM, "callpc3.exe\0"    , NO_TERM
#define SQLDB_CLEAR  NOT_AVAIL ,NO_ALTERN, DbrootBIN, "x_clear.exe\0"    , NO_TERM
#define SQLDB_CI     "xci"    , NO_ALTERN, DbrootPGM, "slowci.exe\0"     , INIT_TERM
#define SQLDB_CI_O   "xoldci" , NO_ALTERN, DbrootPGM, "oldci.exe\0"      , INIT_TERM
#define SQLDB_FILTER "xsql"   , NO_ALTERN, DbrootPGM, "sqlfilt.exe\0"    , NO_TERM
#define SQLDB_FILTER_RO "xsqlro", NO_ALTERN, DbrootPGM, "sqlfiltn.exe\0" , NO_TERM
#define SQLDB_MAKETI NOT_AVAIL, NO_ALTERN, DbrootBIN, "x_maketi.exe\0"   , NO_TERM
#define SQLDB_VTTEST NOT_AVAIL, NO_ALTERN, DbrootPGM, "vttest.exe\0"     , NO_TERM

#define SQLDB_SERVICE  "xservice" , "x_service", DbrootPGM, "service.exe\0", NO_TERM
#define SQLDB_BACKUP   "xbackup"   , NO_ALTERN , DbrootPGM, "backup.exe\0",  NO_TERM
#define SQLDB_RESTORE  "xrestore"  , NO_ALTERN , DbrootPGM, "restore.exe\0", NO_TERM

/* PTS 1107637 FF 17-Aug-2000    xregcomp statt regsvr32                */
#define SQLDB_REGCOMP "xregcomp", NO_ALTERN, DbrootPGM, "regcomp.exe\0"  , NO_TERM
#define SQLDB_KERNPROT "xkernprot" , NO_ALTERN , DbrootPGM, "diagnose.exe\0", NO_TERM

/* PTS 1108841 FH 10-Jan-2001                                                    */
#define SQLDB_TRACESORT "xtracesort", NO_ALTERN, DbrootPGM, "tracesort.exe\0", NO_TERM
#define SQLDB_SYSMON  "sysmon"    , NO_ALTERN , DbrootSAP, "sysmon.exe\0"   , NO_TERM
#define SQLDB_WIZARD  "x_wizard"  , NO_ALTERN , DbrootPGM, "wizard.exe\0" , NO_TERM
#define SQLDB_WIZTRC  "x_wiztrc"  , NO_ALTERN , DbrootPGM, "wiztrc.exe\0" , NO_TERM
#define SQLDB_XPU     "xpu"       , NO_ALTERN , DbrootPGM, "pu.exe\0"      , NO_TERM
#define SQLDB_WIZ     "x_wiz"     , NO_ALTERN , DbrootSAP, "wiz.cmd\0"    , NO_TERM
#define SQLDB_WIZSTOP "x_wizstop" , NO_ALTERN , DbrootSAP, "wizstop.cmd\0", NO_TERM
#define SQLDB_ANALYS  "x_analys"  , NO_ALTERN , DbrootSAP, "analys.cmd\0" , NO_TERM
/*------------------------- function prototypes  -----------------------*/

int e952_call_start(struct program_id*,int, char**);
int e952_call_gwstart(struct program_id*,int, char**);
int e952_call_stop(struct program_id*,int, char**);
int e952_call_console(struct program_id*,int, char**);
int e952_call_show(struct program_id*,int, char**);
int e952_call_vserver(struct program_id*,int, char**);
int e953_call_python(struct program_id*,int, char**);
int e950_call_component(struct program_id*,int, char**);
int e952_call_sqlfilter(struct program_id*,int, char**);
int e952_call_backup(struct program_id*,int, char**);
int e952_call_restore(struct program_id*,int, char**);
int e953_call_kernprot(struct program_id*,int, char**);
int e953_call_tracesort(struct program_id*,int, char**); /* PTS 1108471 */
int e953_call_PrecompiledTools(struct program_id*,int, char**);
int e952_call_service(struct program_id*,int, char**); /*  */
int eo954PrintIndepDataPath(struct program_id*,int, char**);
int eo954PrintIndepProgramsPath(struct program_id*,int, char**);
int eo954PrintDBRootOfDB(struct program_id*,int, char**);
int eo954PrintRundirOfDB(struct program_id*,int, char**);
int eo954PrintInstInfo(struct program_id*,int, char**);
int eo954PrintSysRC(struct program_id*,int, char**);

#else

/*-------------------------- defines UNIX only --------------------------*/


#define USAGE_CONS(progname) \
        PRI_USAGE (("\n%s %s <dbname> [ command [ interval [ count ] ] ] \n", \
                   SQL_USAGE, progname ))


#define IS_OPT_CHR(c) ( c == '-' )

#if     defined(NCCS) && defined(TCSADRAIN)
#  define       TERMIO_INFO             struct termios
#  define       GET_TERMIO(f,t)         tcgetattr(f,t)
#  define       SET_TERMIO(f,t)         tcsetattr(f,TCSADRAIN,t)
#else
#  define       TERMIO_INFO             struct termio
#  define       GET_TERMIO(f,t)         ioctl(f,TCGETA,t)
#  define       SET_TERMIO(f,t)         ioctl(f,TCSETAW,t)
#endif

#define BEG_ENV_VAR '{'
#define END_ENV_VAR '}'

#define SQLDB_START  "x_start", NO_ALTERN, DbrootPGM, "start\0"       , NO_TERM
#define SQLDB_GWSTART  "x_gwstart", NO_ALTERN, DbrootPGM, "start\0"   , NO_TERM
#define SQLDB_STOP   "x_stop" , NO_ALTERN, DbrootPGM, "stop\0"        , NO_TERM
#define SQLDB_CLEAR  "x_clear", NO_ALTERN, DbrootPGM, "clr_kernel\0clr_ps_ipc\0",NO_TERM
#define SQLDB_CONS   "x_cons" , NO_ALTERN, DbrootPGM, "cons\0console\0"     , NO_TERM
#define SQLDB_SERV   "x_server",NO_ALTERN, IndependentPGM, "vserver\0"     , NO_TERM
#define SQLDB_NISERV "x_niserver",NO_ALTERN, IndependentPGM, "niserver\0"    , NO_TERM
#define SQLDB_QUERY  "xquery" , NO_ALTERN, DbrootPGM, "query\0"       , INIT_TERM
#define SQLDB_LOAD   "xload"  , "xdbload", DbrootPGM, "load\0"        , INIT_TERM
#define SQLDB_PYTHON "x_python",NO_ALTERN, DbrootPGM, "python\0"      , NO_TERM
#define SQLDB_EASY   "xeasy"  , NO_ALTERN, DbrootPGM, "easy\0"        , INIT_TERM
#define SQLDB_PL     "xpl"    , NO_ALTERN, DbrootPGM, "sqlpl\0"       , INIT_TERM
#define SQLDB_PLRUN  "xplrun" , NO_ALTERN, DbrootPGM, "plrun\0"       , INIT_TERM
#define SQLDB_TOPL   "xtopl"  , NO_ALTERN, DbrootPGM, "topl\0"        , INIT_TERM
#define SQLDB_TOPLR  "xtplrun", NO_ALTERN, DbrootPGM, "tplrun\0"      , INIT_TERM
#define SQLDB_AUDIT  "xaudit" , NO_ALTERN, DbrootPGM, "audit\0"       , INIT_TERM
#define SQLDB_DIAG   "x_diagnose", NO_ALTERN, DbrootPGM, "diagnose\0" , INIT_TERM
#define SQLDB_CI     "xci"    , NO_ALTERN, DbrootPGM, "slowci\0"      , INIT_TERM
#define SQLDB_CI_O   "xoldci" , NO_ALTERN, DbrootPGM, "oldci\0"       , INIT_TERM
#define SQLDB_MAKETI "x_maketi",NO_ALTERN, IndependentPGM, "maketi\0" , INIT_TERM
#define SQLDB_VTTEST "xvttest", NO_ALTERN, IndependentPGM, "vttest\0" , INIT_TERM
#define SQLDB_USER   "xuser"  , NO_ALTERN, IndependentBIN, "xuserUnicode\0"       , NO_TERM
#define SQLDB_FILTER "xsql"   , NO_ALTERN, DbrootPGM, "sqlfilter\0"   , NO_TERM
#define SQLDB_FILTER_RO "xsqlro", NO_ALTERN, DbrootPGM, "sqlfiltern\0"   , NO_TERM
#define SQLDB_SHOW   "x_show" , NO_ALTERN, DbrootBIN, "x_show\0"      , NO_TERM
#define SQLDB_CPC    NOT_AVAIL, NO_ALTERN, DbrootBIN, "cpc\0"         , NO_TERM
/* PTS 1107637 FF 17-Aug-2000                                                    */
/*#define SQLDB_REGSVR32 "regsvr32", NO_ALTERN, DbrootPGM, "regsvr32\0"   , NO_TERM*/
#define SQLDB_REGCOMP "xregcomp", NO_ALTERN, DbrootPGM, "regcomp\0"  , NO_TERM
#define SQLDB_KERNPROT "xkernprot", NO_ALTERN, DbrootPGM, "diagnose\0", NO_TERM

/* PTS 1108841 FH 10-Jan-2001                                                    */
#define SQLDB_BACKUP   "xbackup"   , NO_ALTERN , DbrootPGM, "backup\0",  NO_TERM
#define SQLDB_RESTORE  "xrestore"  , NO_ALTERN , DbrootPGM, "restore\0", NO_TERM
#define SQLDB_TRACESORT "xtracesort", NO_ALTERN, DbrootPGM, "tracesort\0", NO_TERM
#define SQLDB_SYSMON  "sysmon"    , NO_ALTERN , DbrootSAP, "sysmon\0"   , NO_TERM
#define SQLDB_WIZARD  "x_wizard"  , NO_ALTERN , DbrootPGM, "wizard\0"   , NO_TERM
#define SQLDB_WIZTRC  "x_wiztrc"  , NO_ALTERN , DbrootPGM, "wiztrc\0"   , NO_TERM
#define SQLDB_XPU     "xpu"       , NO_ALTERN , DbrootPGM, "pu\0"       , NO_TERM
#define SQLDB_WIZ     "x_wiz"     , NO_ALTERN , DbrootSAP, "wiz\0"    , NO_TERM
#define SQLDB_WIZSTOP "x_wizstop" , NO_ALTERN , DbrootSAP, "wizstop\0", NO_TERM
#define SQLDB_ANALYS  "x_analys"  , NO_ALTERN , DbrootSAP, "analys\0" , NO_TERM

int e952_call_start() ;
int e952_call_gwstart() ;
int e952_call_stop() ;
int e952_call_console() ;
int e952_call_show() ;
int e952_call_regcomp(); /* PTS 1108471 */
int e952_call_vserver() ;
int eo952CallNiServer() ;
int e953_call_python() ;
int e950_call_component() ;
int e952_call_sqlfilter() ;
int e952_call_clear() ;
int e953_call_tracesort() ; /* PTS 1108471 */
int e953_call_kernprot() ;
int e953_call_PrecompiledTools();
int e952_call_backup();
int eo954PrintIndepDataPath();
int eo954PrintIndepProgramsPath();
int eo954PrintDBRootOfDB();
int eo954PrintRundirOfDB();
int eo954PrintInstInfo();
int eo954PrintSysRC();

#endif

#define SAPDB_GET_INDEP_DATA        "_gid"  , NO_ALTERN , DbrootSAP, "\0", NO_TERM
#define SAPDB_GET_INDEP_PROGRAMS    "_gip"  , NO_ALTERN , DbrootSAP, "\0", NO_TERM
#define SAPDB_GET_DBROOT_OF_DB      "_gdbr" , NO_ALTERN , DbrootSAP, "\0", NO_TERM
#define SAPDB_GET_RUNDIR_OF_DB      "_grd"  , NO_ALTERN , DbrootSAP, "\0", NO_TERM
#define SAPDB_GET_INSTALLATION_INFO "xinstinfo"  , NO_ALTERN , DbrootSAP, "\0", NO_TERM
#define SAPDB_GET_SYSRC             "xsysrc"  , NO_ALTERN , DbrootSAP, "\0", NO_TERM

/*------------------------- structure definitions -----------------------*/

#ifdef _WIN32
 typedef int             (* INT_FUNC_PTR  )(struct program_id*,int, char**);
#else
 typedef int             (* INT_FUNC_PTR  )();
#endif

typedef struct          program_id
                        { char *progid , *alter_progid;
                          enum ProgramExecPathType ProgramLocation;
/*
  After console was renamed into cons and strt.exe was renamed into start.exe 'progname' is no longer
  a simple character string but a character string list terminated with doubled zero!!!!
  This allow to lookup different executables until an existing program is found and can be called...
 */
                          char *progname;
                          int init_term ;
                          INT_FUNC_PTR call_func ;
                          char **prog_helpfiles ;
                        } PROG_ID ;

/*-----------------------------------------------------------------------*/


/*------------------- global vars for MAIN-MUDUL only -------------------*/
#ifdef DEF_PROGLIST

static char *start_hlpfiles[]= { "xstart.use", CNULL } ;
static char *gwstart_hlpfiles[]= { "xgwstart.use", CNULL } ;
static char *stop_hlpfiles[] = { "xstop.use", CNULL } ;
static char *query_hlpfiles[]= { "general.use", "qu.use", CNULL } ;
static char *load_hlpfiles[] = { "general.use", "lo.use", CNULL } ;
static char *easy_hlpfiles[] = { "general.use", "ye.use", CNULL } ;
static char *pl_hlpfiles[]   = { "general.use", "plrun.use",
                                "plimp.use"  , "plexp.use", CNULL } ;
static char *plrun_hlpfiles[] = { "general.use", "plrun.use", CNULL } ;
static char *topl_hlpfiles[]  = { "general.use", CNULL } ;
static char *tplrun_hlpfiles[]= { "general.use", "plrun.use",
                                "plimp.use"  , CNULL } ;
static char *audit_hlpfiles[] = { "xtau.use" , CNULL } ;

#ifdef  WIN32
static char *server_hlpfiles[] = { "serv.use" , CNULL } ;
#else

static char *server_hlpfiles[] = { "vserver.use" , CNULL } ;
static char *niserver_hlpfiles[] = { "niserver.use" , CNULL } ;
/* PTS 1107637 FF 17-Aug-2000 */
/*static char *regsvr32_hlpfiles[] = { "regsvr32.use" , CNULL } ;*/
#endif
/* PTS 1107637 FF 17-Aug-2000 */
static char *regcomp_hlpfiles[] = { "regcomp.use" , CNULL } ;

static char *kernprot_hlpfiles[] = { "kernprot.use" , CNULL } ;
static char *tracesort_hlpfiles[] = { "tracesort.use" , CNULL } ;

static PROG_ID  proglist[] = {
                { SQLDB_QUERY , e950_call_component , query_hlpfiles } ,
                { SQLDB_LOAD  , e950_call_component , load_hlpfiles } ,
                { SQLDB_PYTHON, e953_call_python    , NO_HELP } ,
                { SQLDB_EASY  , e950_call_component , easy_hlpfiles } ,
                { SQLDB_PL    , e950_call_component , pl_hlpfiles } ,
                { SQLDB_PLRUN , e950_call_component , plrun_hlpfiles } ,
                { SQLDB_TOPL  , e950_call_component , topl_hlpfiles } ,
                { SQLDB_TOPLR , e950_call_component , tplrun_hlpfiles } ,
                { SQLDB_CONS  , e952_call_console   , NO_HELP } ,
                { SQLDB_SHOW  , e952_call_show      , NO_HELP } ,
                { SQLDB_MAKETI, e950_call_component , NO_HELP } ,
                { SQLDB_VTTEST, e950_call_component , NO_HELP } ,
                { SQLDB_CPC   , e950_call_component , NO_HELP } ,
                { SQLDB_USER  , e950_call_component , NO_HELP } ,
                { SQLDB_DIAG  , e950_call_component , NO_HELP } ,
                { SQLDB_AUDIT , e950_call_component , audit_hlpfiles } ,
                { SQLDB_CI    , e950_call_component , NO_HELP } ,
                { SQLDB_CI_O  , e950_call_component , NO_HELP } ,
                { SQLDB_START , e952_call_start,      start_hlpfiles} ,
                { SQLDB_GWSTART, e952_call_gwstart,  gwstart_hlpfiles} ,
                { SQLDB_STOP  , e952_call_stop ,      stop_hlpfiles } ,
                { SQLDB_SERV  , e952_call_vserver   , server_hlpfiles } ,
                { SQLDB_FILTER, e952_call_sqlfilter , NO_HELP } ,
                { SQLDB_FILTER_RO, e952_call_sqlfilter , NO_HELP } ,
#ifdef WIN32
                { SQLDB_SERVICE, e950_call_component, NO_HELP } ,
                { SQLDB_REGCOMP, e950_call_component ,regcomp_hlpfiles } ,
#else
                { SQLDB_NISERV, eo952CallNiServer   , niserver_hlpfiles } ,
                { SQLDB_CLEAR , e952_call_clear,      NO_HELP } ,
                { SQLDB_REGCOMP,  e952_call_regcomp ,regcomp_hlpfiles } ,
/* PTS 1107636 FF 17-Aug-2000 */
/*                { SQLDB_REGSVR32, e950_call_component,regsvr32_hlpfiles } ,*/
#endif
                { SQLDB_KERNPROT, e953_call_kernprot, kernprot_hlpfiles } ,
/* PTS 1108841 FH 10-Jan-2001 */
                { SQLDB_BACKUP , e952_call_backup   , NO_HELP } ,
                { SQLDB_RESTORE, e952_call_backup  , NO_HELP } ,
                { SQLDB_TRACESORT, e953_call_tracesort, tracesort_hlpfiles } ,
                { SQLDB_SYSMON,   e953_call_PrecompiledTools, NO_HELP } ,
                { SQLDB_WIZTRC,   e953_call_PrecompiledTools, NO_HELP } ,
                { SQLDB_WIZARD,   e953_call_PrecompiledTools, NO_HELP } ,
                { SQLDB_XPU,      e953_call_PrecompiledTools, NO_HELP } ,
                { SQLDB_WIZ,      e953_call_PrecompiledTools, NO_HELP } ,
                { SQLDB_WIZSTOP,  e953_call_PrecompiledTools, NO_HELP } ,
                { SQLDB_ANALYS,   e953_call_PrecompiledTools, NO_HELP } ,
                { SAPDB_GET_INDEP_DATA,       eo954PrintIndepDataPath, NO_HELP } ,
                { SAPDB_GET_INDEP_PROGRAMS   ,eo954PrintIndepProgramsPath, NO_HELP } ,
                { SAPDB_GET_DBROOT_OF_DB     ,eo954PrintDBRootOfDB, NO_HELP } ,
                { SAPDB_GET_RUNDIR_OF_DB     ,eo954PrintRundirOfDB, NO_HELP } ,
                { SAPDB_GET_INSTALLATION_INFO,eo954PrintInstInfo, NO_HELP } ,
                { SAPDB_GET_SYSRC,eo954PrintSysRC, NO_HELP } ,
                } ;

#define PROGLIST_SIZE     (sizeof( proglist )/sizeof (PROG_ID))
EXPORT int debug ;
#else
IMPORT int debug ;
#endif
/*-----------------------------------------------------------------------*/

#define DBG0(x)         { if ( debug ) { printf x; } }

/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

void e950_PutEnvDBRoot           ( tsp00_Pathc DBRoot ) ;  /* PTS 1108841 */

int en950ApplStartupProgram      ( int NumArgs, char **Args ) ;

int e950_search_and_call_sqlprog ( char               *sql_prog,
                                   int                 num_params,
                                   char              **params ) ;

int e950_call_help               ( char               *progname,
                                   char              **helpfiles ) ;

void e950_print_params           ( char               *funcname,
                                   int                 num_params,
                                   char              **params ) ;

int e950_call_prog               ( char                *progname,
                                   int                  num_params,
                                   char               **params ) ;

int e950_call_component          ( PROG_ID             *sel_component,
                                   int                  num_args,
                                   char               **args ) ;

void en950_PrintRteError         ( char               *HeaderInfo,
                                   tsp01_RteError     *RteError) ;

boolean en950_GetProgramExecPath ( enum ProgramExecPathType   ProgramLocation,
                                   char                      *GetProgramExecPath );

int eo950_ArgC ();

const char **  eo950_ArgV ();

int e951_f_access                ( char               *path,
                                   int                 mode,
                                   int                 pri_err );

char *e951_toupper_str           ( char               *str ) ;

int e951_create_path             ( char               *path_to_create,
                                   unsigned short      mode );

char *e951_getparam              ( char               *dbname,
                                   char               *param_id,
                                   char              **param );


int en952_GetDbrootPgmPath       ( char               *DbrootPgmPath ) ;

#endif  /* HEO95_H */
