/*!******************************************************************************

  @file         hbd05.h

  ------------------------------------------------------------------------------

  @author       JuergenP

  @brief        filesysteminterface_5

\if EMIT_LICENCE  

    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif

********************************************************************************/

#ifndef HBD05_H
#define HBD05_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x20\x67\x90\xa8\x82\x43\x35\x78\x5a\xbd\xac\x61\x71\xb7\x52\xe1'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void b05copy_bytestr (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tgg00_FileId          VAR_VALUE_REF  source_file,
    tsp00_Int4                           from_pos,
    tgg00_FileId          VAR_VALUE_REF  target_file,
    tsp00_Int4                           to_pos,
    tsp00_Int4                           length,
    tsp00_Int4                           new_str_version);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b05expand_bytestr (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tgg00_FileId          VAR_VALUE_REF  file_id,
    tsp00_Int4                           length,
    char                                 fill_char,
    tsp00_Int4                           new_str_version);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b05get_str_version (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tgg00_FileId          VAR_VALUE_REF  file_id,
    tsp00_Int4            VAR_VALUE_REF  str_version);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b05length_bytestr (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tgg00_FileId          VAR_VALUE_REF  file_id,
    tsp00_Int4            VAR_VALUE_REF  filelength,
    tsp00_Int4            VAR_VALUE_REF  page_count,
    tsp00_Int4            VAR_VALUE_REF  str_version);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b05read_bytestr (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tgg00_FileId          VAR_VALUE_REF  file_id,
    tsp00_Int4                           pos,
    tsp00_Int4            VAR_VALUE_REF  length,
    tsp00_Int4                           buf_size,
    tsp00_MoveObjPtr                     buf_addr,
    tsp00_Int4                           bufpos);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b05trunc_bytestr (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tgg00_FileId          VAR_VALUE_REF  file_id,
    tsp00_Int4                           new_filelength,
    tsp00_Int4                           new_str_version);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b05write_bytestr (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tgg00_FileId          VAR_VALUE_REF  file_id,
    tsp00_Int4                           pos,
    tsp00_Int4                           length,
    tsp00_Int4                           buf_size,
    const void*                          buf_addr,
    tsp00_Int4                           bufpos,
    tsp00_Int4                           new_str_version);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd05Prefetch (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    tgg00_FileId          VAR_VALUE_REF  fileId,
    tsp00_Int4                           blobPosition);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

