/*!******************************************************************************

  @file         hbd01.h

  ------------------------------------------------------------------------------

  @author       JuergenP

  @brief        filesysteminterface_1

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif

********************************************************************************/

#ifndef HBD01_H
#define HBD01_H


/*===========================================================================*
 *     RefType: C++                                                          *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x6c\x05\xa2\x89\xc2\xac\x68\x28\x59\x44\xab\x68\x42\x08\xcd\xee'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "gbd00.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal tsp00_Int4 b01bad_index_cnt;
externPascal pasbool b01downfilesystem;
externPascal tsp00_VFilename b01blankfilename;
externPascal tsp00_Key b01zerokey;
externPascal tsp00_Key b01fullkey;

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01b_check_bytestr (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01bcreate_bytestr (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01change_filetype (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id,
    tgg00_FiletypeSet     &  new_filetype);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01check_table (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id,
    tsp00_Int2               long_col_cnt,
    tsp00_Int2               new_long_col_cnt,
    pasbool                  bWithExtendedCheck,
    pasbool                  check_long_existence);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool b01connect_allowed ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01create_filesystem (
    tgg00_TransContext    &  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool b01db_full (
    tsp00_TaskId             taskId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01dbspace_statistic (
    tgg00_TransContext    &  t,
    tgg00_DbSpaceInfo     &  info);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01destroy_file (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01empty_file (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01end_read_only (
    tgg00_TransContext    &  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01fcreate_file (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id,
    tsp00_Int2               stringcol_cnt,
    pasbool                  no_tree_index);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01filestate (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01fn_new_and_unload (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  orig_id,
    tgg00_FileId          &  new_id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 b01get_bad_index_cnt ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01get_bad_indexid (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01get_data_cache_workload (
    tgg00_TransContext    &  trans,
    tsp00_Int4            &  DataCacheSize,
    tsp00_Int4            &  OmsHistoryPageCnt,
    tsp00_Int4            &  OmsDataPageCnt,
    tsp00_Int4            &  OmsUnloadedVersPageCnt,
    tsp00_Int4            &  SqlDataPageCnt);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01ldestroy_long_file (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01move_filecontent (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  sourceFileId,
    tgg00_FileId          &  destFileId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01next_fdir_entry (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 b01no_of_data_devs ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 b01no_of_log_devs ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01pdestroy_perm_file (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01prefix_destroy_files (
    tgg00_TransContext    &  t,
    tgg00_Filename        &  prefix_fn,
    integer                  prefix_len);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01pverify_participant (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id,
    pasbool                  is_cold,
    pasbool                  bWithExtendedCheck);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 b01rec_align (
    tsp00_Int4               len);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01reload_file (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01rename_file (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  old_id,
    tgg00_FileId          &  new_id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01reset_monitor (
    tgg00_MonitorPart_Param     part);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01restart_filesystem (
    tgg00_TransContext    &  t,
    pasbool                  IncrementConvVersion);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01set_fileversion (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id,
    tgg91_FileVersion        new_fileversion,
    tsp00_Int2               new_long_cnt);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01treeleafnodes (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id,
    tgg00_MessType_Param     m_type,
    tsp00_Int4            &  old_treeleafnodes);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01setto_zero_full_and_null ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01sfile_statistic (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id,
    pasbool                  with_shortcol_file,
    tgg00_SampleInfo      &  info);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01show_monitor (
    tsp00_TaskId             TaskId,
    tgg00_ReferenceInfo   &  info);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01shutdown_filesystem (
    tgg00_TransContext    &  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01tcreate_file (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01tinit_temp_cache (
    tgg00_TransContext    &  t,
    tsp00_Int4               buffers,
    pasbool                  is_control_session);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01trelease_temp_cache (
    tgg00_TransContext    &  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01treset_file (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01unload_file (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01verify_database (
    tgg00_TransContext    &  t,
    pasbool                  bWithUpdate,
    pasbool                  bWithIndexes,
    pasbool                  bWithExtendedCheck,
    tsp00_Int4            &  NumPermPages,
    tsp00_Int4            &  NumReleasedBlocks,
    tsp00_Int4            &  bad_index_cnt,
    tsp00_Int4            &  total_bad_cnt);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b01vstate_fileversion (
    tgg00_TransContext    &  t,
    tgg00_FileId          &  file_id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd01AddInvToFileDirectory (
    tgg00_TransContext    &  Trans,
    tgg00_FileId          &  FileId,
    pasbool                  SetNotAccessible);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd01DataCacheSize (
    tsp00_Int4            &  TotalPages,
    tsp00_Int4            &  UnMapPages);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 bd01ConverterSize ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd01CreateCoordinator (
    tgg00_TransContext    &  t,
    tgg00_MessType_Param     MessType);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd01SetToBad (
    tgg00_TransContext    &  trans,
    tgg00_FileId          &  fileId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd01SetToNilCurrent (
    tbd_current_tree      &  Current);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd01StartCoordinator (
    tgg00_TransContext    &  t,
    tgg00_MessType_Param     MessType);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal integer bd01UsableServerForParallelExecution (
    tsp00_TaskId             TaskId,
    tgg00_MessType_Param     MessType,
    pasbool                  InRegion);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd01CalculateRecordsAndLeaves (
    tgg00_TransContext    &  Trans,
    tgg00_FileId          &  FileId,
    tsp00_Int4            &  NumberOfLeaves,
    tsp00_Int4            &  NumberOfRecords);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd01SampleRecordsAndLeaves (
    tgg00_TransContext    &  Trans,
    tgg00_FileId          &  FileId,
    tsp00_Int4               NumberOfSampleLeaves,
    tsp00_Int4            &  NumberOfLeaves,
    tsp00_Int4            &  NumberOfRecords);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd01ExtractForeignKey (
    tgg00_MessBlock       &  MessBlock,
    tgg00_FileId          &  AuxFileId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd01MultiColumnStatistic (
    tgg00_MessBlock       &  MessBlock,
    tgg00_FileId          &  AuxFileId,
    pasbool                  bCalculate,
    tsp00_Int4               NumberOfSampleLeaves,
    tsp00_Int4            &  NumberOfLeaves,
    tsp00_Int4            &  NumberOfRecords,
    tgg00_ColumnDistinctValues  &  DistinctValues);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd01MigrateDataBase (
    tsp00_TaskId             TaskId,
    tgg00_BasisError      &  TrError);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

