/*!***************************************************************************

  module      : gbd499.h

  -------------------------------------------------------------------------

  author      :  AlexanderK
  responsible :  UweH

  special area: IndexMemoryManagementUnit
  description : 


  last changed: 1999-07-22  10:00
  see also    : 

  -------------------------------------------------------------------------

  copyright:    (c) 1999-2004 SAP AG



    ========== licence begin  GPL
    Copyright (c) 1999-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*****************************************************************************/




#ifndef GBD499_H
#define GBD499_H

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/

/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/


/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

class cbd499_IndexMemoryManagementUnit
{
public:

    cbd499_IndexMemoryManagementUnit ();


    bool bd499GetFileListMemory (
		tsp00_TaskId      TaskId,
        tsp00_BytePtr    &pFileList,
        tsp00_Int4       &FileListItems
        );

    bool bd499GetFunnelStackMemory (
		tsp00_TaskId      TaskId,
        tsp00_BytePtr    &pFunnelStack,
        tsp00_Int4       &FunnelStackItems
        );
    
    static  void bd499Init (tgg00_TransContext &Trans);
    
    void bd499ReleaseFileListMemory (tsp00_TaskId	TaskId);

    void bd499ReleaseFunnelStackMemory (tsp00_TaskId	TaskId);

private:
    
    static bool          m_MemoryAllocated;
    static void         *m_pFileList;
    static void         *m_pFunnelStack;
    static tsp00_TaskId  m_FileListUsedByTask;
    static tsp00_TaskId  m_FunnelStackUsedByTask;
};

/*===========================================================================*
 *  DEFINITION OF METHODS                                                    *
 *===========================================================================*/

#endif  /* GBD499_H */
