/*!******************************************************************************

  @file         hak683.h

  ------------------------------------------------------------------------------

  @author       GertG

  @brief        join_trace_routines

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif

********************************************************************************/

#ifndef HAK683_H
#define HAK683_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\xba\xec\xa2\xf4\xf4\x55\x68\xc4\x33\x4f\x38\x0c\x00\x2e\xfc\xbf'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "vak001.h"
#include "ggg07.h"
#include "gak68.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void a683trans_to_line (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tak_dml_info          VAR_VALUE_REF  dmli,
    tsp00_Int2                           tableno,
    tsp00_Int2                           colno,
    tsp00_DataLine        VAR_VALUE_REF  line,
    tsp00_Int2                           maxlen,
    pasbool               VAR_VALUE_REF  res_state);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#if defined (SAPDB_SLOW)

externPascal void a683tabarr_output (
    tak_dml_info          VAR_VALUE_REF  dmli);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a683output_joins (
    tgg00_Debug_Param                    debug,
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tak_dml_info          VAR_VALUE_REF  dmli,
    tak_joinrec           VAR_VALUE_REF  joins);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a683trace_jprops (
    tgg00_Debug_Param                    debug,
    tak_jcolpropset       VAR_ARRAY_REF  jprop);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a683trace_jointype (
    tgg00_Debug_Param                    debug,
    const char*                          desc,
    tak68_one_jointype_Param                 jtype);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a683trace_kbjrec (
    tgg00_Debug_Param                    debug,
    tgg07_KbJoinRec       VAR_VALUE_REF  kbjrec);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a683_output (
    tgg00_Debug_Param                    debug,
    tak_dml_info          VAR_VALUE_REF  dmli);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a683_one_join_entry (
    tgg00_Debug_Param                    debug,
    tak_dml_info          VAR_VALUE_REF  dmli,
    integer                              index);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a683_one_join_entry_ex (
    tgg00_Debug_Param                    debug,
    tak_dml_info          VAR_VALUE_REF  dmli,
    integer                              index);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a683joinset_trace (
    tgg00_Debug_Param                    debug,
    const char*                          nam,
    tak_joinset           VAR_ARRAY_REF  join_set);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a683out_equal_record (
    tgg00_Debug_Param                    debug,
    tak68_eq_record       VAR_VALUE_REF  eq_rec);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a683join_transition_trace (
    tgg00_Debug_Param                    debug,
    tak68_join_transitions  VAR_ARRAY_REF  jtrans,
    tsp00_Int2            VAR_VALUE_REF  table_cnt);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a683multabs_trace (
    tgg00_Debug_Param                    debug,
    tak68_mult_tabs       VAR_VALUE_REF  mul_tabs,
    integer                              size_multabs,
    integer                              position,
    integer                              table_cnt);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a683tr_newsucc (
    tgg00_Debug_Param                    debug,
    tak68_succession      VAR_ARRAY_REF  succession,
    integer                              start,
    integer                              stop,
    pasbool                              dst_table);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a683tr_tableset (
    tgg00_Debug_Param                    debug,
    const char*                          nam,
    tak_joinset           VAR_ARRAY_REF  table_set);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a683tr_tablenames (
    tgg00_Debug_Param                    debug,
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tak_dml_info          VAR_VALUE_REF  dmli,
    integer                              tablecnt);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a683tr_sequence (
    tgg00_Debug_Param                    debug,
    tak_dml_info          VAR_VALUE_REF  dmli,
    tak68_sequence        VAR_ARRAY_REF  series);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif


#endif

