/*!******************************************************************************

  @file         hak51.h

  ------------------------------------------------------------------------------

  @author       ElkeZ

  @brief        AK_Connect

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif

********************************************************************************/

#ifndef HAK51_H
#define HAK51_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x67\x31\x82\x87\x85\xda\xd2\xc8\x65\xd4\x27\xae\x3a\x98\xfb\x7f'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "vak001.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void a51_aconnect_statement (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tsp00_Int2            VAR_VALUE_REF  put_node);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51_acurrent_user (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tsp00_Int2            VAR_VALUE_REF  put_node);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51_aset_statement (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tsp00_Int2            VAR_VALUE_REF  put_node);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 a51CatalogCacheSize ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51connect (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tak_connect_rec       VAR_VALUE_REF  connect_rec,
    pasbool                              change_curr_user);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51getascii_password (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tsp00_CryptPw         VAR_ARRAY_REF  password);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51trimcn_password (
    tsp00_CryptPw         VAR_ARRAY_REF  password);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51init_cache_sizes ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51_connect (
    tak_all_command_glob  VAR_VALUE_REF  acv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tak_acv_address a51NextSession (
    pasbool               VAR_VALUE_REF  isFirst);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51session_init (
    tak_all_command_glob  VAR_VALUE_REF  acv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51build_userkey (
    tsp00_KnlIdentifier   VAR_ARRAY_REF  user_name,
    tgg00_SysInfoKey      VAR_VALUE_REF  userkey);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51inc_ak_cache_size (
    tak_size_ptr                         size_info_ptr,
    tsp00_Int4                           increment);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51cache_size_info (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tgg91_SessionNo                      session,
    tsp00_Int4            VAR_VALUE_REF  ak_cache);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51release_cache_size_info (
    tak_all_command_glob  VAR_VALUE_REF  acv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51semantic (
    tak_all_command_glob  VAR_VALUE_REF  acv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51SetDebugSession (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tgg91_SessionNo                      session,
    tgg91_SessionNo                      listener);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51set_degree (
    tak_all_command_glob  VAR_VALUE_REF  acv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51SetSessionReplicationProlog (
    tak_all_command_glob  VAR_VALUE_REF  acv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51switch_user (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tsp00_KnlIdentifier   VAR_ARRAY_REF  new_user_name,
    tsp00_KnlIdentifier   VAR_ARRAY_REF  curr_user_name);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51a_alter_session_statement (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tsp00_Int2            VAR_VALUE_REF  put_node);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51get_date_format (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tsp00_C120            VAR_ARRAY_REF  format,
    pasbool                              has_to_be_uni);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51_internal_trans (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tgg00_UnivTrans       VAR_VALUE_REF  old_trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a51close_internal_trans (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tgg00_UnivTrans       VAR_VALUE_REF  old_trans,
    tgg00_MessType_Param                 m_type);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

