/****************************************************************************

  module      : WDVHandler_MKCOLHandler.c

  -------------------------------------------------------------------------

  responsible : Daniel Kirmse

  special area: 
  description : 


  last changed: 2001-02-28  13:32
  see also    : 

  -------------------------------------------------------------------------


  ========== licence begin  GPL
  Copyright (c) 2001-2004 SAP AG

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  ========== licence end

*****************************************************************************/

	
	#include "SAPDB/WebDAV/Handler/WDVHandler_MKCOLHandler.h"


	/*------------------------------------------------------------------------
		Function: mkcolCallCapiFunc
	--------------------------------------------------------------------------*/
	sapdbwa_Int2 mkcolCallCapiFunc(WDVH_Handle		wdvhHandle,
								   WDVCAPI_WDV		pCapiHandle,
								   WDVH_Char		*errmsg)			/* http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1124007 */
	{
		sapdbwa_Int2			rc;
		WDV_Bool				success;
		WDVCAPI_ErrorItem		errorItem;
		WDVCAPI_ErrorType		errorType;
		WDVCAPI_ErrorCode		errorCode;
		WDVCAPI_ErrorText		errorMsg;
		WDVH_Error				error;
		WDVH_Char				errorText[1000];
		WDVH_Char				*server;
		
		/* get server string for error messages */
		buildServerString(wdvhHandle->request,&server);
		
		success = WDVCAPI_MkCol( pCapiHandle, wdvhHandle->requesturi, wdvhHandle->locktoken);

		/* error handling */
		if (!success) {
			WDVCAPI_GetLastError(pCapiHandle,&errorItem);
			WDVCAPI_GetErrorType(errorItem,&errorType);
			switch (errorType) {
				case WDVCAPI_ERR_TYPE_UNDEFINED:
				case WDVCAPI_ERR_TYPE_SQL: 
					{
						/* internal server error */
						error = ERROR_500;
						WDVCAPI_GetErrorText(errorItem,&errorMsg);
						sp77sprintf(errorText,1000,ERROR_MKCOL_URI,server,(char*)sapdbwa_GetRequestURI(wdvhHandle->request));
						sapdbwa_WriteLogMsg(wdvhHandle->wa, errorText);
						sp77sprintf(errorText,1000,ERROR_MKCOL_500,errorMsg);
						sapdbwa_WriteLogMsg(wdvhHandle->wa, errorText);
						break;
					}
				case WDVCAPI_ERR_TYPE_CAPI: 
					{
						WDVCAPI_GetErrorCode(errorItem,&errorCode);
						switch(errorCode) {
							case WDVCAPI_ERR_CODE_PARENT_DOESNT_EXIST:
								{
									error = ERROR_409;
									/* Correction Begin http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1121446 
									WDVCAPI_GetErrorText(errorItem,&errorMsg);
									sp77sprintf(errorText,1000,ERROR_MKCOL_PARENT_409,server,(char*)sapdbwa_GetRequestURI(wdvhHandle->request));
									sapdbwa_WriteLogMsg(wdvhHandle->wa, errorText);
									sp77sprintf(errorText,1000,ERROR_MKCOL_MESSAGE,errorMsg);
									sapdbwa_WriteLogMsg(wdvhHandle->wa, errorText);
									/* Correction End http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1121446 */
									break;
								}
							/* Correction Begin http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1124007 */
							case WDVCAPI_ERR_CODE_PARENT_NOT_A_COLLECTION:
								{
									error = ERROR_403;
									sp77sprintf(errmsg,1000,"At least one parent is no collection.");
									break;
								}
							/* Correction End http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1124007 */
							case WDVCAPI_ERR_CODE_COLLECTION_ALREADY_EXIST:
								{
									error = ERROR_405;
									/* Correction Begin http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1121446 
									WDVCAPI_GetErrorText(errorItem,&errorMsg);
									sp77sprintf(errorText,1000,ERROR_MKCOL_EXISTS_405,server,(char*)sapdbwa_GetRequestURI(wdvhHandle->request));
									sapdbwa_WriteLogMsg(wdvhHandle->wa, errorText);
									sp77sprintf(errorText,1000,ERROR_MKCOL_MESSAGE,errorMsg);
									sapdbwa_WriteLogMsg(wdvhHandle->wa, errorText);
									/* Correction End http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1121446 */
									break;
								}
							case WDVCAPI_ERR_CODE_LOCK_EXISTS:
								{
									error = ERROR_423;
									/* Correction Begin http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1121446 
									WDVCAPI_GetErrorText(errorItem,&errorMsg);
									sp77sprintf(errorText,1000,ERROR_MKCOL_LOCKED_423,server,(char*)sapdbwa_GetRequestURI(wdvhHandle->request));
									sapdbwa_WriteLogMsg(wdvhHandle->wa, errorText);
									sp77sprintf(errorText,1000,ERROR_MKCOL_MESSAGE,errorMsg);
									sapdbwa_WriteLogMsg(wdvhHandle->wa, errorText);
									/* Correction End http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1121446 */
									break;
								}
							default:
								{
									error = ERROR_500;
									WDVCAPI_GetErrorText(errorItem,&errorMsg);
									sp77sprintf(errorText,1000,ERROR_MKCOL_URI,server,(char*)sapdbwa_GetRequestURI(wdvhHandle->request));
									sapdbwa_WriteLogMsg(wdvhHandle->wa, errorText);
									sp77sprintf(errorText,1000,ERROR_MKCOL_500,errorMsg);
									sapdbwa_WriteLogMsg(wdvhHandle->wa, errorText);
									break;
								}
						}
						break;
					}
				default:
					{
						error = ERROR_500;
						WDVCAPI_GetErrorText(errorItem,&errorMsg);
						sp77sprintf(errorText,1000,ERROR_MKCOL_URI,server,(char*)sapdbwa_GetRequestURI(wdvhHandle->request));
						sapdbwa_WriteLogMsg(wdvhHandle->wa, errorText);
						sp77sprintf(errorText,1000,ERROR_MKCOL_500,errorMsg);
						sapdbwa_WriteLogMsg(wdvhHandle->wa, errorText);
						break;
					}
			}
		} else {
			error = ERROR_201;
		}

		if (server) {
			WDVHandler_Free((sapdbwa_UInt1*) server);
		}
		return error;

	}

	/*------------------------------------------------------------------------
		Function:	mkcolBuildReply
	--------------------------------------------------------------------------*/
	void mkcolBuildReply(WDVH_Handle	wdvhHandle, 
						 sapdbwa_Int2	statuscode,
						 WDVH_Char		*errmsg)			/* http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1124007 */
	{
		/* initialize Response Header */
		if (statuscode==ERROR_201) {
			sapdbwa_InitHeader(wdvhHandle->reply,
							   statuscode,
							   NULL,
							   NULL,
							   NULL,								/* const char    *LastModified,*/
							   NULL,								/* const char    *Expires,*/
							   NULL);								/* const char    *Location );*/
		} else {
			sapdbwa_InitHeader(wdvhHandle->reply,
							   statuscode,
							   "text/html",
							   NULL,
							   NULL,								/* const char    *LastModified,*/
							   NULL,								/* const char    *Expires,*/
							   NULL);								/* const char    *Location );*/
		}
		sapdbwa_SendHeader(wdvhHandle->reply);

		switch (statuscode) {
			case ERROR_409: 
				sapdbwa_SendBody(wdvhHandle->reply,
								 ERROR_PAGE_409,
								 strlen(ERROR_PAGE_409));
				break; 
			/* Correction Begin http://pts:1080/webpts?wptsdetail=yes&ErrorType=1&ErrorID=1124007 */
			case ERROR_403:								
				sapdbwa_SendBody(wdvhHandle->reply,
								 ERROR_PAGE_403,
								 0);
				sapdbwa_SendBody(wdvhHandle->reply,
								 errmsg,
								 0);
				sapdbwa_SendBody(wdvhHandle->reply,
								 ERROR_PAGE_FOOTER,
								 0);
				break; 
			/* Correction End http://pts:1080/webpts?wptsdetail=yes&ErrorType=1&ErrorID=1124007 */
			case ERROR_405:
				sapdbwa_SendBody(wdvhHandle->reply,
								 ERROR_PAGE_405,
								 strlen(ERROR_PAGE_405));
				break;
			case ERROR_500:
				sapdbwa_SendBody(wdvhHandle->reply,
							 ERROR_PAGE_500,
							 strlen(ERROR_PAGE_500));
				break;
		}
	}
