#    module      : loadertest.py
#
#    responsible : d033893 
#
#    special area: SAP DB LOADER
#
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2004 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

# make 1    imf pyinst.mac 
# make 2    imf ::SAPDB/Scripting/Resource/loaderpy.mac

# usage 1:  %JTEST_ROOT%                                   >perl     jtrun.pl loadertest.cfg
# usage 2:  %INSTROOT%/misc/sapdb/pythondef/loaderdoc/test >x_python          loadertest.py  -u <usecase>

#system
import sys
import time
import os
import socket
#shell
import shutil
#string
import string
import re
import regsub
#sapdb
import optlib
from   sapdb    import loader,sql,dbm


loadersyntax = [
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                                                                                                                                     |',
'|                                        SAP DB Loader Session Attributes                                                             |',
'|                                                                                                                                     |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                                                                                                                                     |',
'|  Session Attribute       Attribute Value                                 Default Value                                              |',
'|                                                                                                                                     |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                                                                                                                                     |', 
'|  SET COMPRESSED          \'/<s>/<d>/\'                                   \'/,/"/\'                                                  |',
'|  SET BLOBMASK            \'#######\'                                                                                                |',
'|  SQLMODE                 [INTERNAL|ANSI|DB2|ORACLE]                      INTERNAL                                                   |', 
'|  SET LANGUAGE            [ENG|DEU]                                       \'ENG\'                                                    |', 
'|  SET CODETYPE            [ASCII|UCS2|UTF8]                               ASCII                                                      |',
'|  SET CODEPAGE            [http://www.unicode.org/Public/MAPPINGS/]       ISO-8859-1                                                 |',
'|  SET DATE                [INTERNAL|ISO|USA|EUR|JIS]                      ISO                                                        |',
'|  SET TIME                [INTERNAL|ISO|USA|EUR|JIS]                      ISO                                                        |',
'|  SET TIMESTAMP           [INTERNAL|ISO|USA|EUR|JIS]                      ISO                                                        |',
'|  SET DECIMAL             \'/[<t>]/<d>/\'                                 \'//./\'                                                   |',
'|  SET BOOLEAN                                                             \'TRUE/FALSE\'                                             |',
'|  SET NULL                                                                \'?\'                                                      |',
'|  SET TRANSACTION SIZE                                                    1000                                                       |',
'|  SET MAXERRORCOUNT                                                       100                                                        |',
'|  SET BACKUPTOOL          [TSM|NETWORKER|BACKINT]                         NETWORKER                                                  |', 
'|  SET ODBCTRACE           [ON|OFF]                                        OFF                                                        |',
'|                                                                                                                                     |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                                                                                                                                     |',
'|                                        SAP DB Loader Transformation Attributes                                                      |',
'|                                                                                                                                     |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                    |                    |                 |                |               |                       |                |',
'| What should be     | Transformation of  |  Logging of     | Package of     | Medium of     | Format of             | Mapping of     |',
'| imported/exported ?| Models und Data    |  Transformation | Transformation | Staging Area  | Models and Data       | Char Codetypes |',
'|                    |                    |                 |                |               |                       |                |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|Catalog, Data and   |EXTRACT|LOAD        |[RESTORE]        | DB             |               |                       |                |',
'|Package of a        |CONFIGURATION       |                 |                | FILE          | DTL, XMI              | UCS2           |',
'|Database            |CATALOG             |                 |                | PIPE          | DDL, XMI              | UTF8           |',
'|                    |DATA                |                 |                | TAPE          | PAGES, RECORDS        | ASCII          |',
'|                    |PACKAGE             |[RESTART]        |                |               | DTL, XMI              |                |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|Catalog, Data and   |EXTRACT|LOAD        |[RESTORE]        | USER           |               |                       |                |',
'|Package of a        |CONFIGURATION       |                 |                | FILE          | DTL, XMI              | UCS2           |',
'|Database User       |CATALOG             |                 |                | PIPE          | DDL, XMI              | UTF8           |',
'|                    |DATA                |                 |                | TAPE          | PAGES, RECORDS        | ASCII          |',
'|                    |PACKAGE             |[RESTART]        |                |               | DTL, XMI              |                |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|Catalog, Data and   |EXTRACT|LOAD[FAST]| |[RESTORE]        | TABLE          |               |                       |                |',
'|Package of a        |CONFIGURATION       |                 |                | FILE          | DTL, XMI              | UCS2           |',
'|Database Table      |CATALOG             |                 |                | PIPE          | DDL, XMI              | UTF8           |',
'|                    |DATA                |                 |                | TAPE          | PAGES, RECORDS,       | ASCII          |',
'|                    |                    |                 |                |               | FORMATTED, COMPRESSED |                |',
'|                    |                    |                 |                |               | COMPRESSED            |                |',
'|                    |PACKAGE             |[RESTART]        |                |               | DTL, XMI              |                |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|Data and Package    |EXTRACT|LOAD[FAST]  |                 | COLUMNS FIELDS |               |                       |                |',
'|of a qualified      |                    |                 |                | FILE          |                       | UCS2           |',
'|Database Columnset  |                    |                 |                | PIPE          |                       | UTF8           |',
'|                    |DATA                |                 |                | TAPE          | FORMATTED, COMPRESSED | ASCII          |',
'|                    |PACKAGE             |[RESTART]        |                |               | DTL, XMI              |                |',
'|                    |                    |                 |                |               |                       |                |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                                                                                                                                     |',
'|                                        SAP DB Loader Migration Attributes                                                           |',
'|                                                                                                                                     |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                                                                                                                                     |',
'| Option     Transformation Attribute                 Attribute Value                 Default Value             Varname               |',
'|                                                                                                                                     |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                                                                                                                                     |',
'| t          Type      of Transformation              TRANSPORT, EXPORT, IMPORT       TRANSPORT                 transformationtype    |',
'| p          Package   of Transformation              DB  , USER, TABLE               DB                        transformationpackage |',
'| m          Medium    of Staging Area                PIPE, FILE, TAPE                FILE                      streammedium          |',
'| f          Format    of Models and Data             DDL, XML                        DDL,RECORDS               streamformat          |',
'|                                                     RECORDS, PAGES,                                                                 |',
'|                                                     COMPRESSED, FORMATTED                                                           |',
'| F                                                   DATA , FAST                     DATA                      streamformat_target   |',
'| e          Mapping of Char Codetypes                ASCII, UCS2, UTF8               ASCII                     streamcharencoding    |',
'| b          Mask    of BLOB Datatypes                SINGLE, MULTIPLE                SINGLE                    streamblob            |',
'| l          Logging of Transformation                START, RESTART                  START                     restart               |',
'|                                                                                                                                     |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                                                                                                                                     |',
'| x          Connector to Medium                      PIPE2TAPE,PIPE2FILE,PIPE2HTTP   none                      streamconnector       |',
'| X          Connector to Database System             SAPDB, ADABAS                   SAPDB                     migration             |',
'|                                                                                                                                     |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                                                                                                                                     |',
'| z          specifies debug  mode                    TRUE , FALSE                    false                     debug                 |',
'| t          specifies test   case                                                    80                        testcase              |',
'|                                                                                                                                     |',
'| n          specifies source servernode                                              localhost                 sourcenode            |',
'| r          specifies sapdb  source  instroot                                        os.environ[INSTROOT]      sourceinstroot        |',
'| i          init      sapdb  source                  SYSTEM,USER,CATALOG,DELETE      data                      sourceinit            |',
'| d          specifies source serverdb to create                                      sourcedb                  sourcedbname          |',
'| a          specifies source SYSDBA user                                             DBA                       sourcedbauser         |',
'| c          specifies source catalog coding          ASCII, UNICODE                  ascii                     sourcecatalog         |',
'|                                                                                                                                     |',
'| N          specifies target servernode                                              localhost                 targetnode            |',
'| R          specifies sapdb  target  instroot                                        os.environ[INSTROOT]      targetinstroot        |',
'| I          init      sapdb  target                  SYSTEM,USER,CATALOG,DELETE      system                    targetinit            |',
'| D          specifies target serverdb to create                                      targetdb                  targetdbname          |',
'| A          specifies target SYSDBA user                                             DBA                       targetdbauser         |',
'| C          specifies target catalog coding          ASCII, UNICODE                  ascii                     targetcatalog         |',
'|                                                                                                                                     |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
'|                                                                                                                                     |',
'|                                        SAP DB Loader Migration Parameters                                                           |',
'|                                                                                                                                     |',
'|-------------------------------------------------------------------------------------------------------------------------------------|',
]

#package webdav : 1,2,3,4,5,
#medium  file   : 6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,                                                                                                                                                                                            
#medium  pipe   : 58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,                                                                                                                                                                                                            
#medium  tape   : 83,84,85 

#71,73       # E -25801

parameters = [
#|Usecase           |Transformation                 |Datastream                                                                         |Testframe                 |Initialize DB                                                                                         
                                                                                                                                                                                                                                                                        
#|Case  |Demo       |Type        |Package  |Logging |Medium |Format              |Encoding                      |Blobmask               |Validation                |Sourcedb             |Version                        |Targetdb               |Version                                                                               
#|1     |2          |3           |4        |5       |6      |7            |8     |9       |10         |11       |12                     |13         |14            |15        |16        |17                |18          |19        |20          |21               |22                                                                  

#data                                    usecases:
'-u  1 -demo FALSE  -t TRANSPORT -p WEBDAV -l START -m FILE -f PAGES      -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v data    -V complete     -i data    -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
'-u  2 -demo FALSE  -t TRANSPORT -p WEBDAV -l START -m FILE -f RECORDS    -F DATA -e ASCII -c ascii   -C unicode -b SINGLE              -v data    -V complete     -i delete  -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
'-u  3 -demo FALSE  -t TRANSPORT -p WEBDAV -l START -m FILE -f RECORDS    -F DATA -e UCS2  -c ascii   -C unicode -b SINGLE              -v data    -V complete     -i delete  -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
'-u  4 -demo FALSE  -t TRANSPORT -p WEBDAV -l START -m FILE -f COMPRESSED -F DATA -e ASCII -c ascii   -C unicode -b SINGLE              -v data    -V complete     -i delete  -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
'-u  5 -demo FALSE  -t TRANSPORT -p WEBDAV -l START -m FILE -f COMPRESSED -F FAST -e ASCII -c ascii   -C unicode -b SINGLE              -v data    -V complete     -i delete  -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
#metadata                                usecases : ascii2ascii																	 
'-u  6 -demo FALSE  -t TRANSPORT -p DB     -l START -m FILE -f DDL        -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v catalog -V sorted       -i catalog -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
'-u  7 -demo FALSE  -t EXPORT    -p DB     -l START -m FILE -f XML        -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v catalog -V none         -i delete  -n localhost -r sourceinstroot -d sourcedb  -I delete  -N localhost -R targetinstroot -D targetdb',                                                          
'-u  8 -demo FALSE  -t TRANSPORT -p USER   -l START -m FILE -f DDL        -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v catalog -V none         -i delete  -n localhost -r sourceinstroot -d sourcedb  -I delete  -N localhost -R targetinstroot -D targetdb',                                                          
'-u  9 -demo FALSE  -t EXPORT    -p USER   -l START -m FILE -f XML        -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v catalog -V none         -i delete  -n localhost -r sourceinstroot -d sourcedb  -I delete  -N localhost -R targetinstroot -D targetdb',                                                          
'-u 10 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f DDL        -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v catalog -V none         -i delete  -n localhost -r sourceinstroot -d sourcedb  -I delete  -N localhost -R targetinstroot -D targetdb',                                                          
'-u 11 -demo FALSE  -t EXPORT    -p TABLE  -l START -m FILE -f XML        -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v catalog -V none         -i delete  -n localhost -r sourceinstroot -d sourcedb  -I delete  -N localhost -R targetinstroot -D targetdb',                                                          
'-u 12 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f PAGES      -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v catalog -V none         -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 13 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f RECORDS    -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v catalog -V none         -i delete  -n localhost -r sourceinstroot -d sourcedb  -I delete  -N localhost -R targetinstroot -D targetdb',                                                          
'-u 14 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f FORMATTED  -F FAST -e ASCII -c ascii   -C ascii   -b SINGLE              -v catalog -V none         -i delete  -n localhost -r sourceinstroot -d sourcedb  -I delete  -N localhost -R targetinstroot -D targetdb',                                                         
'-u 15 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f COMPRESSED -F FAST -e ASCII -c ascii   -C ascii   -b SINGLE              -v catalog -V none         -i delete  -n localhost -r sourceinstroot -d sourcedb  -I delete  -N localhost -R targetinstroot -D targetdb',                                                          
#data																															 
'-u 16 -demo FALSE  -t TRANSPORT -p DB     -l START -m FILE -f PAGES      -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v all     -V sorted       -i data    -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
'-u 17 -demo FALSE  -t TRANSPORT -p DB     -l START -m FILE -f RECORDS    -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
'-u 18 -demo FALSE  -t TRANSPORT -p USER   -l START -m FILE -f PAGES      -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v data    -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 19 -demo FALSE  -t TRANSPORT -p USER   -l START -m FILE -f RECORDS    -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v data    -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 20 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f PAGES      -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 21 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f RECORDS    -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 22 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f FORMATTED  -F DATA -e ASCII -c ascii   -C ascii   -b MULTIPLE            -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 23 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f FORMATTED  -F FAST -e ASCII -c ascii   -C ascii   -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 24 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f COMPRESSED -F DATA -e ASCII -c ascii   -C ascii   -b MULTIPLE            -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 25 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f COMPRESSED -F FAST -e ASCII -c ascii   -C ascii   -b MULTIPLE            -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
#metadata                                usecases : ascii2unicode																 
'-u 26 -demo FALSE  -t TRANSPORT -p DB     -l START -m FILE -f DDL        -F DATA -e ASCII -c ascii   -C unicode -b SINGLE              -v catalog -V sorted       -i catalog -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
'-u 27 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f FORMATTED  -F FAST -e ASCII -c ascii   -C unicode -b SINGLE              -v catalog -V none         -i delete  -n localhost -r sourceinstroot -d sourcedb  -I delete  -N localhost -R targetinstroot -D targetdb',                                                          
'-u 28 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f COMPRESSED -F FAST -e ASCII -c ascii   -C unicode -b SINGLE              -v catalog -V none         -i delete  -n localhost -r sourceinstroot -d sourcedb  -I delete  -N localhost -R targetinstroot -D targetdb',                                                          
#data																															 
'-u 29 -demo FALSE  -t TRANSPORT -p DB     -l START -m FILE -f RECORDS    -F DATA -e UCS2  -c ascii   -C unicode -b SINGLE              -v all     -V sorted       -i data    -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 30 -demo FALSE  -t TRANSPORT -p USER   -l START -m FILE -f RECORDS    -F DATA -e UCS2  -c ascii   -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 31 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f RECORDS    -F DATA -e UCS2  -c ascii   -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 32 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f FORMATTED  -F DATA -e ASCII -c ascii   -C unicode -b MULTIPLE            -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 33 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f FORMATTED  -F FAST -e ASCII -c ascii   -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 34 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f COMPRESSED -F DATA -e ASCII -c ascii   -C unicode -b MULTIPLE            -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 35 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f COMPRESSED -F FAST -e ASCII -c ascii   -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 36 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f FORMATTED  -F DATA -e UTF8  -c ascii   -C unicode -b MULTIPLE            -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 37 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f FORMATTED  -F FAST -e UTF8  -c ascii   -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 38 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f COMPRESSED -F DATA -e UTF8  -c ascii   -C unicode -b MULTIPLE            -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 39 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f COMPRESSED -F FAST -e UTf8  -c ascii   -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
#metadata                                usecases : unicode2unicode																 
'-u 40 -demo FALSE  -t TRANSPORT -p DB     -l START -m FILE -f DDL        -F DATA -e UCS2  -c unicode -C unicode -b SINGLE              -v catalog -V sorted       -i catalog -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
'-u 41 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f PAGES      -F DATA -e UCS2  -c unicode -C unicode -b SINGLE              -v catalog -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 42 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f RECORDS    -F DATA -e UCS2  -c unicode -C unicode -b SINGLE              -v catalog -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I delete  -N localhost -R targetinstroot -D targetdb',                                                          
'-u 43 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f FORMATTED  -F FAST -e UCS2  -c unicode -C unicode -b SINGLE              -v catalog -V none         -i delete  -n localhost -r sourceinstroot -d sourcedb  -I delete  -N localhost -R targetinstroot -D targetdb',                                                          
'-u 44 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f COMPRESSED -F FAST -e UCS2  -c unicode -C unicode -b SINGLE              -v catalog -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I delete  -N localhost -R targetinstroot -D targetdb',                                                          
#data																															 
'-u 45 -demo FALSE  -t TRANSPORT -p DB     -l START -m FILE -f PAGES      -F DATA -e UCS2  -c unicode -C unicode -b SINGLE              -v all     -V sorted       -i data    -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
'-u 46 -demo FALSE  -t TRANSPORT -p DB     -l START -m FILE -f RECORDS    -F DATA -e UCS2  -c unicode -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
'-u 47 -demo FALSE  -t TRANSPORT -p USER   -l START -m FILE -f RECORDS    -F DATA -e UCS2  -c unicode -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 48 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f PAGES      -F DATA -e UCS2  -c unicode -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 49 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f RECORDS    -F DATA -e UCS2  -c unicode -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 50 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f FORMATTED  -F DATA -e UCS2  -c unicode -C unicode -b MULTIPLE            -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 51 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f FORMATTED  -F FAST -e UCS2  -c unicode -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 52 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f COMPRESSED -F DATA -e UCS2  -c unicode -C unicode -b MULTIPLE            -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 53 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f COMPRESSED -F FAST -e UCS2  -c unicode -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 54 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f FORMATTED  -F DATA -e UTF8  -c unicode -C unicode -b MULTIPLE            -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 55 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f FORMATTED  -F FAST -e UTF8  -c unicode -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 56 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f COMPRESSED -F DATA -e UTF8  -c unicode -C unicode -b MULTIPLE            -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 57 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m FILE -f COMPRESSED -F FAST -e UTF8  -c unicode -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
#metadata                                usecases : ascii2ascii																	 
'-u 58 -demo FALSE  -t TRANSPORT -p DB     -l START -m PIPE -f DDL        -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v catalog -V sorted       -i catalog -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
#data																															 
'-u 59 -demo FALSE  -t TRANSPORT -p DB     -l START -m PIPE -f PAGES      -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v all     -V sorted       -i data    -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
'-u 60 -demo FALSE  -t TRANSPORT -p DB     -l START -m PIPE -f RECORDS    -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
'-u 61 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m PIPE -f RECORDS    -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 62 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m PIPE -f FORMATTED  -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 63 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m PIPE -f FORMATTED  -F FAST -e ASCII -c ascii   -C ascii   -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 64 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m PIPE -f COMPRESSED -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 65 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m PIPE -f COMPRESSED -F FAST -e ASCII -c ascii   -C ascii   -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
#metadata                                usecases : ascii2unicode																 
'-u 66 -demo FALSE  -t TRANSPORT -p DB     -l START -m PIPE -f DDL        -F DATA -e ASCII -c ascii   -C unicode -b SINGLE              -v catalog -V sorted       -i catalog -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
#data																															 
'-u 67 -demo FALSE  -t TRANSPORT -p DB     -l START -m PIPE -f RECORDS    -F DATA -e UCS2  -c ascii   -C unicode -b SINGLE              -v all     -V sorted       -i data    -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
'-u 68 -demo FALSE  -t TRANSPORT -p USER   -l START -m PIPE -f RECORDS    -F DATA -e UCS2  -c ascii   -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 69 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m PIPE -f RECORDS    -F DATA -e UCS2  -c ascii   -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 70 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m PIPE -f FORMATTED  -F DATA -e ASCII -c ascii   -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 71 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m PIPE -f FORMATTED  -F FAST -e ASCII -c ascii   -C unicode -b SINGLE              -v all     -V none         -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 72 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m PIPE -f COMPRESSED -F DATA -e ASCII -c ascii   -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 73 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m PIPE -f COMPRESSED -F FAST -e ASCII -c ascii   -C unicode -b SINGLE              -v all     -V none         -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
#metadata                                usecases : unicode2unicode																 
'-u 74 -demo FALSE  -t TRANSPORT -p DB     -l START -m PIPE -f DDL        -F DATA -e UCS2  -c unicode -C unicode -b SINGLE              -v catalog -V sorted       -i catalog -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
#data																															 
'-u 75 -demo FALSE  -t TRANSPORT -p DB     -l START -m PIPE -f PAGES      -F DATA -e UCS2  -c unicode -C unicode -b SINGLE              -v all     -V sorted       -i data    -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
'-u 76 -demo FALSE  -t TRANSPORT -p DB     -l START -m PIPE -f RECORDS    -F DATA -e UCS2  -c unicode -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
'-u 77 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m PIPE -f RECORDS    -F DATA -e UCS2  -c unicode -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 78 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m PIPE -f FORMATTED  -F DATA -e UCS2  -c unicode -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 79 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m PIPE -f FORMATTED  -F FAST -e UCS2  -c unicode -C unicode -b SINGLE              -v all     -V none         -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 80 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m PIPE -f COMPRESSED -F DATA -e UCS2  -c unicode -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 81 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m PIPE -f COMPRESSED -F FAST -e UCS2  -c unicode -C unicode -b SINGLE              -v all     -V none         -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
'-u 82 -demo FALSE  -t TRANSPORT -p TABLE  -l START -m PIPE -f COMPRESSED -F DATA -e UTF8  -c unicode -C unicode -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I catalog -N localhost -R targetinstroot -D targetdb',                                                          
#metadata                                usecases: ascii2ascii																	 
'-u 83 -demo FALSE  -t TRANSPORT -p DB     -l START -m TAPE -f DDL        -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v catalog -V sorted       -i catalog -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
#data																															 
'-u 84 -demo FALSE  -t TRANSPORT -p DB     -l START -m TAPE -f PAGES      -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v all     -V sorted       -i data    -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb',                                                          
'-u 85 -demo FALSE  -t TRANSPORT -p DB     -l START -m TAPE -f RECORDS    -F DATA -e ASCII -c ascii   -C ascii   -b SINGLE              -v all     -V sorted       -i delete  -n localhost -r sourceinstroot -d sourcedb  -I system  -N localhost -R targetinstroot -D targetdb'       
]

def _options ():
    return [
    #usecase
    ('u', 'usecase'                , ':', ''                    , 'specifies use    case'  ),   
    ('demo', 'demo'                , ':', ''                    , 'specifies demo   mode'  ),                     # TRUE , FALSE                  
    ('v', 'validation'             , ':', ''                    , 'specifies validation scope'),                  # 
    ('V', 'validationmode'         , ':', ''                    , 'specifies validation type' ),                  # 
    #transport sourcedb to targetdb
    ('t', 'transformationtype'     , ':', ''                    , 'type      of transformation '),                # TRANSPORT, EXPORT, IMPORT
    ('p', 'transformationpackage'  , ':', ''                    , 'package   of transformation '),                # DB   , USER, TABLE, WEBDAV
    ('m', 'streammedium'           , ':', ''                    , 'streammedium of transformation '),             # PIPE , FILE, TAPE
    ('f', 'streamformat'           , ':', ''                    , 'streamformat of transformation '),             # RECORDS, PAGES, COMPRESSED, FORMATTED, FORMATTED BINARY, DDL, XML
    ('F', 'streamformat_target'    , ':', ''                    , 'streamformat of transformation '),             # DATA  , FAST
    ('e', 'streamcharencoding'    , ':', ''                     , 'streamcoding of transformation '),             # ASCII , UCS2, UTF8
    ('b', 'streamblob'             , ':', ''                    , 'blobmask     of transformation '),             # SINGLE, MULTIPLE
    ('l', 'restart'                , ':', ''                    , 'restart transformation '),                     # START , RESTART
    ('L', 'loaderinstroot'         , ':', os.environ['INSTROOT'], 'specifies sapdb  loader  independent path'),   # 
    #sourcedb
    ('i', 'sourceinit'             , ':', ''                    , 'init      sapdb  source'),                     # DELETE, SYSTEM, USER, CATALOG, DATA 
    ('c', 'sourcecharencoding'     , ':', ''                    , 'specifies sapdb  source char encoding '),      # ASCII , UNICODE
    ('n', 'sourcenode'             , ':', socket.gethostname()  , 'specifies source servernode'),
    ('r', 'sourceinstroot'         , ':', ''                    , 'specifies sapdb  source  instroot'), 
    ('j', 'sourceindepdatapath'    , ':', os.environ['INSTROOT'], 'specifies sapdb  source  independent path'), 
    ('d', 'sourcedbname'           , ':', ''                    , 'specifies source serverdb to create'),
    ('a', 'sourcedbauser'          , ':', 'DBA'                 , 'specifies source SYSDBA user'),
    #targetdb
    ('I', 'targetinit'             , ':', ''                    , 'init      sapdb  target'),                     # DELETE, SYSTEM, USER, CATALOG, DATA
    ('C', 'targetcharencoding'     , ':', ''                    , 'specifies sapdb  target char encoding '),      # ASCII , UNICODE
    ('N', 'targetnode'             , ':', socket.gethostname()  , 'specifies target servernode '),
    ('R', 'targetinstroot'         , ':', ''                    , 'specifies sapdb  target  instroot'), 
    ('J', 'targetindepdatapath'    , ':', os.environ['INSTROOT'], 'specifies sapdb  target  independent path'), 
    ('D', 'targetdbname'           , ':', ''                    , 'specifies target serverdb to create'),
    ('A', 'targetdbauser'          , ':', 'DBA'                 , 'specifies target SYSDBA user'),
] 

def main (options, args): 

    usecase = options.usecase
    
    for case in regsub.split(usecase,','):
        options.usecase = string.atoi(case,10)
        #source db
        if socket.gethostname() == 'p66796':
           options.sourceinstroot = os.path.join('D:','SAPDevelop','V75','usr') #'V7300','b_21',V743
        else:   
           options.sourceinstroot = os.path.join(os.environ['INSTROOT']) 
        #target db
        options.targetinstroot = os.path.join(os.environ['INSTROOT']) 
        options.loaderinstroot = os.path.join(os.environ['INSTROOT'])
        
        if  check_options(options) == 0 :
            #execute use case
            print '\n# %i: EXECUTE USECASE \n ' % (options.usecase)
            #usecase
            print '-u %i   ' % options.usecase
            print '-demo %s' % options.demo
            print '-v %s   ' % options.validation
            print '-V %s \n' % options.validationmode
            #transformation attributes
            print '-t %s  ' % options.transformationtype
            print '-p %s  ' % options.transformationpackage
            print '-m %s  ' % options.streammedium
            print '-f %s  ' % options.streamformat
            print '-F %s  ' % options.streamformat_target
            print '-e %s  ' % options.streamcharencoding 
            print '-b %s  ' % options.streamblob
            print '-l %s\n' % options.restart
            #sourcedb
            print '-i %s  ' % options.sourceinit
            #targetdb
            print '-I %s\n' % options.targetinit
            #transformation resources
            init_transformation_resources(options)
            #transport sourcedb to targetdb
            print '\nTransport Source Database to Target Database'  
            #     |Loader Version  |Source Target Database |Transformation                           |Testframe  
            cmd = 'x_python %s -v %s -n %s -d %s -N %s -D %s -t %s -p %s -m %s -f %s -F %s -e %s -b %s -l %s -u %s -demo %s ' % ( os.path.join (os.environ ['INSTROOT'],'env','transport.py' ), options.loaderinstroot,
                                                                                                                                  options.sourcenode, options.sourcedbname,  
                                                                                                                                  options.targetnode, options.targetdbname,
                                                                                                                                  options.transformationtype,options.transformationpackage, options.streammedium, options.streamformat, options.streamformat_target, options.streamcharencoding, options.streamblob, options.restart, 
                                                                                                                                  options.usecase, options.demo )
            try:
               os.system (cmd)
            except OSError, err:
               print 'command failed:', err

               
            #transformation resources   
            deinit_transformation_resources(options) 
            
def init_transformation_resources (options):

    init_transformation_databases (options)
    init_transformation_files     (options)
    
def deinit_transformation_resources(options):
    
    deinit_transformation_files    (options)  
    
    #transformation attributes
    options.transformationtype    = ''
    options.transformationpackage = ''
    options.streammedium          = ''   
    options.streamformat          = ''    
    options.streamformat_target   = ''    
    options.streamcharencoding    = ''    
    options.streamcoding_target   = ''    
    options.streamblob            = ''    
    options.restart               = ''    

    #sourcedb
    options.sourceinit            = ''
    options.transformationpackage = ''
    options.sourcecharencoding    = ''   
    options.sourcenode            = ''  
    options.sourceinstroot        = ''
    options.sourcedbname          = ''
    
    #targetdb   
    options.targetinit            = '' 
    options.targetcharencoding    = ''
    options.targetnode            = ''
    options.targetinstroot        = ''
    options.targetdbname          = ''          
    
def init_transformation_databases (options):
    input = None
    
    while input not in ["y","n"]:   
          if options.demo == 'TRUE':
             input = raw_input('Init      Transformation Databases ? [y]/[n] : ')
          if options.demo == 'FALSE':
             print             'Init      Transformation Databases '
             input  = "y"
             
          if input == "n":
             try:
                 session = dbm.DBM ('',options.sourcedbname, options.sourceinstroot, 'DBM,DBM' )
                 sourceindepdatapath = session.cmd('dbm_getpath INDEPDATAPATH ')
                 options.sourceindepdatapath = regsub.split(sourceindepdatapath,'\n')[0]
             except dbm.CommunicationError, err :
                 pass 
             try:
                 session = dbm.DBM ('',options.targetdbname, options.targetinstroot, 'DBM,DBM' )
                 targetindepdatapath = session.cmd('dbm_getpath INDEPDATAPATH ')
                 options.targetindepdatapath = regsub.split(targetindepdatapath,'\n')[0]
             except dbm.CommunicationError, err :
                 pass   
                    
          if input == "y":
             #sourcedb
             if options.sourceinit <> 'DELETE' and options.sourcedbname == 'SOURCEDB':
                print '\nInstall   Databasesystem %s ' % options.sourcedbname
                cmd = 'x_python %s -demo %s -r %s -d %s -c %s '         % (os.path.join (os.environ ['INSTROOT'],'misc','sapdb','pythondef','dbmdoc','demo','installdb.py' ) , options.demo ,options.sourceinstroot,options.sourcedbname,options.sourcecharencoding)
                try:
                    os.system (cmd)
                except OSError, err:
                    print 'command failed:', err
                   
             try:
                 session = dbm.DBM ('',options.sourcedbname, options.sourceinstroot, 'DBM,DBM' )
                 sourceindepdatapath = session.cmd('dbm_getpath INDEPDATAPATH ')
                 options.sourceindepdatapath = regsub.split(sourceindepdatapath,'\n')[0]
             except dbm.CommunicationError, err :
                 pass
                
             #db
             if options.transformationpackage <> 'WEBDAV':          
                print '\nImport    Database       %s ' % options.sourcedbname
                cmd = 'x_python %s -demo %s -r %s -d %s -i %s'           % (os.path.join (os.environ ['INSTROOT'],'misc','sapdb','pythondef','loaderdoc','demo','import.py' ), options.demo,options.loaderinstroot,options.sourcedbname,options.sourceinit)
                try:
                    os.system (cmd)
                except OSError, err:
                    print 'command failed:', err    
             #dav
             if options.transformationpackage == 'WEBDAV' :    
                print '\nImport    DAV Database   %s ' % options.sourcedbname
                cmd = 'x_python %s -demo %s -r %s -d %s -i %s -h %s:85'  % (os.path.join (os.environ ['INSTROOT'],'misc','sapdb','pythondef','davdoc'   ,'demo','import.py' ), options.demo,options.targetinstroot,options.sourcedbname,options.sourceinit,socket.gethostname())
                try:
                    os.system (cmd)
                except OSError, err:
                    print 'command failed:', err        
                
             #targetdb
             if options.targetinit <> 'DELETE' and options.targetdbname == 'TARGETDB':
                print '\nInstall   Databasesystem %s \n'  % options.targetdbname 
                cmd = 'x_python %s -demo %s -r %s -d %s -c %s '          % (os.path.join (os.environ ['INSTROOT'],'misc','sapdb','pythondef','dbmdoc','demo','installdb.py' ), options.demo,options.targetinstroot,options.targetdbname,options.targetcharencoding)
 
                try:
                    os.system (cmd)
                except OSError, err:
                    print 'command failed:', err
                   
             try:
                 session = dbm.DBM ('',options.targetdbname, options.targetinstroot, 'DBM,DBM' )
                 targetindepdatapath = session.cmd('dbm_getpath INDEPDATAPATH ')
                 options.targetindepdatapath = regsub.split(targetindepdatapath,'\n')[0]
             except dbm.CommunicationError, err :
                 pass
                           
             #db
             if options.transformationpackage <> 'WEBDAV':      
                print '\nImport    Database       %s '  % options.targetdbname 
                cmd = 'x_python %s -demo %s -r %s -d %s -i %s'           % (os.path.join (os.environ ['INSTROOT'],'misc','sapdb','pythondef','loaderdoc','demo','import.py' ), options.demo,options.loaderinstroot,options.targetdbname,options.targetinit)
                try:
                    os.system (cmd)
                except OSError, err:
                    print 'command failed:', err  
             #dav
             if options.transformationpackage == 'WEBDAV' :        
                print '\nImport    DAV Database   %s'   % options.targetdbname
                cmd = 'x_python %s -demo %s -r %s -d %s -i %s -h %s:85'  % (os.path.join (os.environ ['INSTROOT'],'misc','sapdb','pythondef','davdoc'   ,'demo','import.py' ), options.demo,options.targetinstroot,options.targetdbname,options.targetinit,socket.gethostname())
                try:
                    os.system (cmd)
                except OSError, err:
                    print 'command failed:', err   
           
    
def init_transformation_files     (options): 
    input = None
    
    while input not in ["y","n"]:   
          if options.demo == 'TRUE':
             input = raw_input('Init      Transformation Files ?     [y]/[n] : ')
          if options.demo == 'FALSE':
             print             'Init      Transformation Files '
             input  = "y"
             
          if input == "n": 
              pass          
        
          if input == "y": 
              #source and target loader protocol file             
              try :
                  os.chdir (os.path.join (options.targetindepdatapath, 'wrk'))

                  curdir = os.getcwd()
                  print 'Remove    Protocols %s' % curdir     
                  for file in os.listdir(curdir) :
                      if os.path.isfile(file) and  ( string.find(file,'loader') == 0 or string.find(file,'%s_loader' % options.usecase ) == 0 or string.find(file,'%s_install' % options.usecase ) == 0) :
                         try:
                            os.unlink(file)
                         except OSError, err:
                            print 'os.unlink (%s) failed: %s ' %( file ,err )

                  os.mkdir(os.path.join(options.sourceindepdatapath, 'wrk', '%s' % options.sourcedbname, 'LOADER' ))
                  os.mkdir(os.path.join(options.targetindepdatapath, 'wrk', '%s' % options.targetdbname, 'LOADER' ))
              except OSError, (errno, err ):
                  if errno == 17 :
                     pass
	          else:    
                     print 'command failed %s ' % ( err )

              #source loader staging area                
              try :
                  if options.transformationtype <> 'IMPORT':
                     os.chdir (os.path.join(options.sourceindepdatapath,'wrk', '%s' % options.sourcedbname, 'LOADER' ))
                    
                     curdir = os.getcwd()
                     print 'Empty     Directory %s' % curdir     
                     for file in os.listdir(curdir) :
                         if  file <> '%s.xml' % options.sourcedbname :
                             try:
                                 os.unlink(file)
                             except OSError, err:
                                 print 'os.unlink(%s) failed: %s ' % ( file , err  )
                                 
                     sourceconfiguration   = open('%s' % os.path.join(options.sourceindepdatapath,  'wrk', '%s' % options.sourcedbname, 'LOADER' , '%s.configuration' % options.sourcedbname),'a+')            
                     sourceconfiguration.close()
                     
              except OSError, (errno, err ):
                     print 'command failed %s ' % ( err )
                     
                     
              #target loader staging area
              try :
                  os.chdir (os.path.join(options.targetindepdatapath, 'wrk', '%s' % options.targetdbname, 'LOADER' ))
             
                  curdir = os.getcwd()
                  print 'Empty     Directory %s' % curdir     
                  for file in os.listdir(curdir) :
                      if  file <> '%s.xml' % options.targetdbname :
                          try:
                              os.unlink(file)
                          except OSError, err:
                              print 'os.unlink (%s) failed: %s ' %( file, err  )
                              
                  targetconfiguration   = open('%s' % os.path.join(options.targetindepdatapath,  'wrk', '%s' % options.targetdbname, 'LOADER' , '%s.configuration' % options.targetdbname),'a+')            
                  targetconfiguration.close()       
                        
                  #copy *registered* transformationpackage in source loader staging area
                  if options.transformationpackage == 'WEBDAV':
                     shutil.copy(os.path.join(options.targetinstroot,'env','WEBDAV.xml'), os.path.join(options.sourceindepdatapath, 'wrk', '%s' % options.sourcedbname, 'LOADER', '%s.xml' % options.sourcedbname ))
                       
              except OSError, err:
                     print 'command failed %s ' % ( err )                
                           
              #backup file     
              try:
                  os.mkdir     (os.path.join(options.sourceindepdatapath, 'wrk', '%s' % options.sourcedbname, 'TAPE' ))
                  os.mkdir     (os.path.join(options.targetindepdatapath, 'wrk', '%s' % options.targetdbname, 'TAPE' ))  
              except OSError, (errno, err ):
                  if errno == 17 :
                     pass
	          else:    
                     print 'os.mkdir (%s) failed: %s ' % (os.path.join(options.sourceindepdatapath, 'wrk', '%s' % options.sourcedbname, 'TAPE' ), err )
              if options.streammedium == 'TAPE' and socket.gethostname() == 'p66796':            
                 try :
                     os.chdir ("C:\\WINNT\\Temp\\")
                 except OSError, err:
                     print 'command failed:', err 
                  
                 curdir = os.getcwd() 
                 print 'Empty     Directory %s' % curdir     
                 for file in os.listdir(curdir) :
                     if ( os.path.isfile(file) and ( 
                          string.find(file,'temp')  == 0 )):
                          try:
                              os.unlink(file)
                          except OSError, err:
                              print 'command failed:', err 
                    
def deinit_transformation_files (options):
    # source db install protocol                  
    try :
        os.chdir (os.path.join (options.sourceindepdatapath, 'wrk'))
    except OSError, (errno, err ):
        print 'os.chdir %s : %s ' % (os.path.join (options.sourceindepdatapath, 'wrk'), err  )
    
    for file in os.listdir(os.curdir) :        
        if os.path.isfile(file) and  string.find(file,'install') == 0 :
           time.sleep(1) 
           file_install = string.replace(file, 'install', '%s_install' % options.usecase ) 
           try:
              os.rename(file,file_install)
           except OSError, err:
              print 'os.rename(%s) failed: %s ' % ( file , err )

    # target db install protocol                  
    try :
        os.chdir (os.path.join (options.targetindepdatapath, 'wrk'))
    except OSError, (errno, err ):
        print 'os.chdir %s : %s ' % (os.path.join (options.targetindepdatapath, 'wrk'), err  )
    
    for file in os.listdir(os.curdir) :        
        if os.path.isfile(file) and  string.find(file,'install') == 0 :
           time.sleep(1) 
           file_install = string.replace(file, 'install', '%s_install' % options.usecase ) 
           try:
              os.rename(file,file_install)
           except OSError, err:
              print 'os.rename(%s) failed: %s ' % ( file , err )
               
    try :
        os.chdir (os.path.join (options.targetindepdatapath, 'wrk'))
    except OSError, (errno, err ):
        print 'os.chdir %s : %s ' % (os.path.join (options.targetindepdatapath, 'wrk'), err  )
   
    for file in os.listdir(os.curdir) :
        #target loader protocol       
        if os.path.isfile(file) and  string.find(file,'loader_') == 0 :
           time.sleep(1) 
           file_target = string.replace(file, 'loader_', '%s_loader_' % options.usecase ) 
           try:
              os.rename(file,file_target)
           except OSError, err:
              print 'os.rename(%s) failed: %s ' % ( file , err )
        #source loader protocol              
        if os.path.isfile(file) and  string.find(file,'loader') == 0 :
           time.sleep(1) 
           file_source = string.replace(file, 'loader', '%s_loader' %  options.usecase ) 
           try:
              os.rename(file,file_source)
           except OSError, err:
              print 'os.rename(%s) failed: %s ' % ( file , err )
              
def check_parameter(options):
    rc = 0
    
    #usecase
    if options.usecase               == '':    
       options.usecase                = string.upper(string.replace(string.replace(regsub.split(parameters[options.usecase-1],'-') [1],'u ',''),' ',''))
    if options.demo                  == '':    
       options.demo                   = string.upper(string.replace(string.replace(regsub.split(parameters[options.usecase-1],'-') [2],'demo ',''),' ',''))   
    else:
       options.demo                   = string.upper(options.demo)    
    #transformation 
    if options.transformationtype    == '':
       options.transformationtype     = string.upper(string.replace(string.replace(regsub.split(parameters[options.usecase-1],'-') [3] ,'t ',''),' ',''))  
    else:
       options.transformationtype     = string.upper(options.transformationtype)
    if options.transformationpackage == '':
       options.transformationpackage  = string.upper(string.replace(string.replace(regsub.split(parameters[options.usecase-1],'-') [4] ,'p ',''),' ',''))
    if options.restart               == '':    
       options.restart                = string.upper(string.replace(string.replace(regsub.split(parameters[options.usecase-1],'-') [5] ,'l ',''),' ',''))       
    #stream   
    if options.streammedium          == '':   
       options.streammedium           = string.upper(string.replace(string.replace(regsub.split(parameters[options.usecase-1],'-') [6] ,'m ',''),' ',''))
    if options.streamformat          == '':    
       options.streamformat           = string.upper(string.replace(string.replace(regsub.split(parameters[options.usecase-1],'-') [7] ,'f ',''),' ',''))
    if options.streamformat_target   == '':    
       options.streamformat_target    = string.upper(string.replace(string.replace(regsub.split(parameters[options.usecase-1],'-') [8] ,'F ',''),' ',''))
    if options.streamcharencoding   == '':    
       options.streamcharencoding     = string.upper(string.replace(string.replace(regsub.split(parameters[options.usecase-1],'-') [9] ,'e ',''),' ',''))
    if options.sourcecharencoding    == '':   
       options.sourcecharencoding     = string.upper(string.replace(string.replace(regsub.split(parameters[options.usecase-1],'-') [10] ,'c ',''),' ',''))   
    if options.targetcharencoding    == '':
       options.targetcharencoding     = string.upper(string.replace(string.replace(regsub.split(parameters[options.usecase-1],'-') [11] ,'C ',''),' ',''))
    if options.streamblob            == '':    
       options.streamblob             = string.upper(string.replace(string.replace(regsub.split(parameters[options.usecase-1],'-') [12],'b ',''),' ',''))

    if options.validation            == '':    
       options.validation             = string.upper(string.replace(string.replace(regsub.split(parameters[options.usecase-1],'-') [13],'v ',''),' ',''))
    if options.validationmode        == '':    
       options.validationmode         = string.upper(string.replace(string.replace(regsub.split(parameters[options.usecase-1],'-') [14],'V ',''),' ',''))      
       
    #sourcedb
    if options.sourceinit            == '':
       options.sourceinit             = string.upper(string.replace(string.replace(regsub.split(parameters[options.usecase-1],'-') [15],'i ',''),' ',''))
    else:
       options.sourceinit             = string.upper(options.sourceinit)
    if options.sourcenode            == 'localhost' or options.sourcenode == '':  
       options.sourcenode             = socket.gethostname()
    if options.sourcedbname          == '':
       options.sourcedbname           = string.upper(string.replace(string.replace(regsub.split(parameters[options.usecase-1],'-') [18],'d ',''),' ',''))
    
    #targetdb   
    if options.targetinit            == '': 
       options.targetinit             = string.upper(string.replace(string.replace(regsub.split(parameters[options.usecase-1],'-') [19],'I ',''),' ',''))
    else:
       options.targetinit             = string.upper(options.targetinit)
    if options.targetnode            == 'localhost' or options.targetnode == '':
       options.targetnode             = socket.gethostname()
    if options.targetdbname          == '':
       options.targetdbname           = string.upper(string.replace(string.replace(regsub.split(parameters[options.usecase-1],'-') [22],'D ',''),' ',''))
    
    return rc   
              
              
def check_options(options):
    rc    = 0 
    if( check_range        (options) <> 0 or
        check_parameter    (options) <> 0 or
        check_configuration(options) <> 0   ):
        rc = 1
    return rc            
           
def check_range    (options):
    rc = 0
    if options.usecase > 85:
       print 'Index out of range.' 
       rc = 1
    return rc  

def check_configuration (options):
    rc = 0
    if options.transformationpackage == 'WEBDAV':
       if(socket.gethostname() == 'p66796' or 
          socket.gethostname() == 'P76209' or
          socket.gethostname() == 'P48142' or 
          socket.gethostname() == 'P59953'   ) :
          rc = 0
       else:        
          print 'transformationpackage DAV: test restricted on server' 
          rc = 1
    if options.streammedium == 'TAPE' :
       if(socket.gethostname() == 'p66796' or
          socket.gethostname() == 'P76209' or
          socket.gethostname() == 'p47579'   ):
          rc = 0
       else:
           print 'medium TAPE: test restricted on server' 
           rc = 1
    if options.streammedium == 'PIPE':
       if sys.platform == 'win32':
          rc = 0
       else: 
          print 'medium PIPE: test restricted on platform' 
          rc = 1
    return rc
       
if __name__ == '__main__':
   optlib.optMain2 (main, _options () )
