/*!
    @file     SharedSQL_CommandCacheIterator.cpp
    @ingroup  SharedSQL
    @author   DirkT
    @brief    Cache for SQLCommands, shared
    @see            

\if EMIT_LICENCE
    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif
*/

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "SQLManager/SharedSQL/SharedSQL_CommandCacheIterator.hpp"
#include "SQLManager/SharedSQL/SharedSQL_ICommandCache.hpp"
#include "SQLManager/SharedSQL/SharedSQL_ICommand.hpp"
#include "SQLManager/SharedSQL/SharedSQL_Types.hpp"

//----------------------------------------------------------------------------
SharedSQL_CommandCacheIterator& SharedSQL_CommandCacheIterator::operator++()
{
    SAPDBERR_ASSERT_STATE(IsValid());
    
    mCommandCache->NonExclusiveLockSlot(mSlot);

    if (SharedSQL_ICachedCommand* NextCommand = mCommand->NextHashCommand())
    {
        mCommand->DecParseIDCount();
        mCommand = NextCommand;
        mCommand->IncParseIDCount();
        mCommandCache->LeaveLockSlot(mSlot);
    }
    else
    {
        mCommand->DecParseIDCount();
        mCommandCache->LeaveLockSlot(mSlot);
        mCommand = 0;
        for (SharedSQL_HashValue i=mSlot+1; (!NextCommand && i<mSlotCount); i++)
        {
            mCommandCache->NonExclusiveLockSlot(i);
            if (NextCommand = mCommandCache->GetHashTableEntry(i))
	        {
                mCommand = NextCommand;
                mCommand->IncParseIDCount();
                mSlot = i;
            }
            mCommandCache->LeaveLockSlot(i);
        }
    }

    return *this;
}

SharedSQL_CommandCacheIterator::~SharedSQL_CommandCacheIterator( void )
{
    if (mCommand)
        mCommand->DecParseIDCount();
}


//----------------------------------------------------------------------------
