/*!---------------------------------------------------------------------
  @file           RTESys_AtomicSwapSun.c
  @author         JoergM
  @brief          Atomic Swapping: Support routine for SUN SPARC atomic swap
              Needed, since optimized version dumps core...
  @see            example.html ...
  @first created  000-05-26  17:33

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
---------------------------------------------------------------------*/




/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/



/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTIONS (PROTOTYPES)                                     *
 *===========================================================================*/



/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

#if defined(SUN)
  /*
   * function: SUN_AtomicSwap (SUN only)
   * description: Does an atomic swap of two integer values
   * 
   * After this call first value and second values are exchanged
   *
   * arguments: val1 [inout] First value
   *            val2 [inout] Second value
   */
/*SUN*/// extern "C" is needed or 'asm()' does not compile... 
/*SUN*/void RTESys_AtomicSwapSun(int *val1, int *val2)
/*SUN*/{
/*SUN*/    asm(" ld [%i1],%o0");
/*SUN*/    asm(" swap	[%i0],%o0");
/*SUN*/    asm(" st %o0,[%i1]");
/*SUN*/}

#ifdef BIT64
/*SUN*/int RTESys_AtomicCmpxchgWithMembarInt4( int *address,
/*SUN*/                                        int expectedValue,
/*SUN*/                                        int newValue,
/*SUN*/                                        int *pOldValue)
/*SUN*/{
/*SUN*/    asm(" cas [%i0], %i1, %i2");
/*SUN*/    asm(" membar #LoadLoad | #StoreLoad");
/*SUN*/    asm(" st %i2, [%i3]");
/*SUN*/    return ( expectedValue == (*pOldValue) );
/*SUN*/}

/*SUN*/int RTESys_AtomicCmpxchgWithMembarInt8( long *address,
/*SUN*/                                        long expectedValue,
/*SUN*/                                        long newValue,
/*SUN*/                                        long *pOldValue)
/*SUN*/{
/*SUN*/    asm(" casx [%i0], %i1, %i2");
/*SUN*/    asm(" membar #LoadLoad | #StoreLoad");
/*SUN*/    asm(" stx %i2, [%i3]");
/*SUN*/    return ( expectedValue == (*pOldValue) );
/*SUN*/}

#else

/*SUN*/int RTESys_AtomicCmpxchgWithMembarInt4( int *address,
/*SUN*/                                        int expectedValue,
/*SUN*/                                        int newValue,
/*SUN*/                                        int *pOldValue)
/*SUN*/{
/*SUN*/    *pOldValue = *address;
/*SUN*/    if ( *pOldValue == expectedValue )
/*SUN*/    {
/*SUN*/        *address = newValue;
/*SUN*/        return 1;
/*SUN*/    }
/*SUN*/    else
/*SUN*/    {
/*SUN*/        return 0;
/*SUN*/    }
/*SUN*/}

/*SUN*/int RTESys_AtomicCmpxchgWithMembarInt8( long *address,
/*SUN*/                                        long expectedValue,
/*SUN*/                                        long newValue,
/*SUN*/                                        long *pOldValue)
/*SUN*/{
/*SUN*/    *pOldValue = *address;
/*SUN*/    if ( *pOldValue == expectedValue )
/*SUN*/    {
/*SUN*/        *address = newValue;
/*SUN*/        return 1;
/*SUN*/    }
/*SUN*/    else
/*SUN*/    {
/*SUN*/        return 0;
/*SUN*/    }
/*SUN*/}

#endif /* BIT64 */

#endif /*SUN*/



/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
