/*!***************************************************************************

  module      : RTE_saveUNIXcalls.h

  -------------------------------------------------------------------------

  responsible : JoergM

  special area: System Calls
  description : System Calls for UNIX wrapped to prevent LINUX signal problems
  
  last changed: 2001-04-03  16:25
  see also    : 

  -------------------------------------------------------------------------



    ========== licence begin  GPL
    Copyright (c) 2001-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*****************************************************************************/

#if defined(_WIN32)

/* UNIX only */

#else

#ifndef externC
#    if defined(__cplusplus)
#        define externC extern "C"
#    else
#        define externC
#    endif /* __cplusplus */
#endif /* externC */

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h> /* for stat and fstat */
#include <fcntl.h>
#include <sys/poll.h> /* for poll */
#include <sys/uio.h> /* for writev */
#include <sys/ipc.h> /* for semop */
#include <sys/sem.h> /* for semop */
#include <sys/shm.h> /* for shmctl */
#include <stdarg.h>

#include "gen00.h"
#include "RunTime/RTE_Types.h"

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

/*===========================================================================*
 *  GLOBAL FUNCTIONS                                                         *
 *===========================================================================*/

externC RTE_FileHandle RTE_save_open(SAPDB_Char const *pathname, SAPDB_Int flags);

externC RTE_FileHandle RTE_save_openCreate(SAPDB_Char const *pathname, SAPDB_Int flags, SAPDB_Int mode);

externC SAPDB_Int      RTE_save_close(RTE_FileHandle fd);

externC SAPDB_Int      RTE_save_stat(SAPDB_Char const *pathname, struct stat *statBuf);

externC SAPDB_Int      RTE_save_fstat(RTE_FileHandle fd, struct stat *statBuf);

externC RTE_FileOffset RTE_save_lseek(RTE_FileHandle fd, RTE_FileOffset offset, SAPDB_Int whence);
 
externC SAPDB_Long     RTE_save_read(RTE_FileHandle fd, void *buf, SAPDB_Long nbyte);

externC SAPDB_Long     RTE_save_nonblocking_read(RTE_FileHandle fd, void *buf, SAPDB_Long nbyte);

externC SAPDB_Long     RTE_save_write(RTE_FileHandle fd, void *buf, SAPDB_Long nbyte);

externC SAPDB_Long     RTE_save_nonblocking_write(RTE_FileHandle fd, void *buf, SAPDB_Long nbyte);

externC SAPDB_Long     RTE_save_writev(RTE_FileHandle fd, struct iovec *vector, SAPDB_Long count);

externC SAPDB_Int      RTE_save_poll(struct pollfd fds[], SAPDB_Int nfds, SAPDB_Int timeout);

externC SAPDB_Int      RTE_save_unlink(SAPDB_Char const *pathname);

externC SAPDB_Int      RTE_save_semop(SAPDB_Int semid, struct sembuf *semops, SAPDB_UInt nsemops);

externC SAPDB_Int      RTE_save_semctl(SAPDB_Int semid, SAPDB_Int semnum, SAPDB_Int cmd, union semun arg);

externC SAPDB_Int      RTE_save_shmctl(SAPDB_Int shmid, SAPDB_Int cmd, struct shmid_ds *shmState);

externC SAPDB_Int4     RTE_save_waitpid(SAPDB_Int4 pidToWaitFor, SAPDB_Int *pStatus, SAPDB_Int flags);

externC SAPDB_Int4     RTE_save_chmod(SAPDB_Char const *pathname, SAPDB_Int mode);

externC SAPDB_Int4     RTE_save_access(SAPDB_Char const *pathname, SAPDB_Int mode);

externC SAPDB_Int4     RTE_save_rename(SAPDB_Char const *oldPathname, SAPDB_Char const *newPathname);
  
externC SAPDB_Char *   RTE_save_getcwd(SAPDB_Char *pathBuffer, SAPDB_ULong bufferSize);

externC void *         RTE_save_malloc(SAPDB_ULong size);

externC void           RTE_save_free(void * pointer);

externC SAPDB_Int4     RTE_save_fork();

externC SAPDB_Int4     RTE_save_vfork();

externC SAPDB_Int4     RTE_save_dup2(SAPDB_Int fd, SAPDB_Int fdTarget);

externC SAPDB_Int4     RTE_save_pipe(SAPDB_Int fdPair[2]);

externC SAPDB_Int4     RTE_save_execvp(SAPDB_Char const * executable, SAPDB_Char * const argv[]);

externC SAPDB_Int4     RTE_save_execve(SAPDB_Char const * executable,
                                       SAPDB_Char * const argv[],
                                       SAPDB_Char * const envp[]);

externC void           RTE_save_exit(SAPDB_Int status);

externC void           RTE_save__exit(SAPDB_Int status);

externC SAPDB_Int4     RTE_save_chown(SAPDB_Char const *pathname, SAPDB_Int4 userId, SAPDB_Int4 groupId);

externC SAPDB_Int4     RTE_save_geteuid();

externC SAPDB_Int4     RTE_save_getuid();

externC SAPDB_Int4     RTE_save_getegid();

externC SAPDB_Int4     RTE_save_getgid();

externC SAPDB_Int4     RTE_save_setuid(SAPDB_Int4 userId);

externC SAPDB_Int4     RTE_save_setreuid(SAPDB_Int4 userId, SAPDB_Int4 effectivUserId);

externC SAPDB_Int4     RTE_save_setgid(SAPDB_Int4 groupId);

externC SAPDB_Int4     RTE_save_setregid(SAPDB_Int4 groupId, SAPDB_Int4 effectivGroupId);

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/

#endif /* UNIX only */
