/*
        ========== licence begin  GPL
        Copyright (c) 2004 SAP AG

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
        ========== licence end
 */
#ifndef RTE_IPC_MESSAGES_HPP
#define RTE_IPC_MESSAGES_HPP

// Generated Header file RTE_IPC_Messages.hpp.
// Generated by genmsg V2.2 DO NOT EDIT

#include "SAPDBCommon/ErrorsAndMessages/SAPDBErr_MessageList.hpp"

#define RTEERR_IPC_SHM_CLOSE                           SAPDBErr_MessageList::Error,16000,"Closing shared memory failed",0
#define RTEERR_IPC_SHM_CLOSE_ID 16000
#define RTEERR_IPC_SHM_OBJECT_ALREADY_OPEN             SAPDBErr_MessageList::Error,16001,"Shared memory object is already open",0
#define RTEERR_IPC_SHM_OBJECT_ALREADY_OPEN_ID 16001
#define RTEERR_IPC_SHM_UNNAMED                         SAPDBErr_MessageList::Error,16002,"Can not open unnamed shared memory",0
#define RTEERR_IPC_SHM_UNNAMED_ID 16002
#define RTEERR_IPC_SHM_MISSING_BASE_ADDRESS            SAPDBErr_MessageList::Error,16003,"Missing location for allocating shared memory",0
#define RTEERR_IPC_SHM_MISSING_BASE_ADDRESS_ID 16003
#define RTEERR_IPC_SHM_ADDRESS_ALIGNMENT               SAPDBErr_MessageList::Error,16004,"Given base address for shared memory is not alligned",0
#define RTEERR_IPC_SHM_ADDRESS_ALIGNMENT_ID 16004
#define RTEERR_IPC_SHM_ALLOCATE_NAME                   SAPDBErr_MessageList::Error,16005,"Allocation of %s bytes for shared memory name failed",1
#define RTEERR_IPC_SHM_ALLOCATE_NAME_ID 16005
#define RTEERR_IPC_SHM_MAPPING                         SAPDBErr_MessageList::Error,16006,"%s file mapping object for %s failed, rc: %s",3
#define RTEERR_IPC_SHM_MAPPING_ID 16006
#define RTEERR_IPC_SHM_MAPPING_EXIST                   SAPDBErr_MessageList::Error,16007,"File mapping object for %s already exists",1
#define RTEERR_IPC_SHM_MAPPING_EXIST_ID 16007
#define RTEERR_IPC_SHM_MAP_FIXED_ADDRESS               SAPDBErr_MessageList::Error,16008,"Mapping file for %s at fixed address %s failed, rc: %s",3
#define RTEERR_IPC_SHM_MAP_FIXED_ADDRESS_ID 16008
#define RTEERR_IPC_SHM_MAP                             SAPDBErr_MessageList::Error,16009,"Mapping file for %s failed, rc: %s",2
#define RTEERR_IPC_SHM_MAP_ID 16009
#define RTEERR_IPC_SHM_UNMAP                           SAPDBErr_MessageList::Error,16010,"Unmapping file for %s failed, rc: %s",2
#define RTEERR_IPC_SHM_UNMAP_ID 16010
#define RTEERR_IPC_SHM_CLOSE_HANDLE                    SAPDBErr_MessageList::Error,16011,"Closing shared memory handle of %s failed, rc: %s",2
#define RTEERR_IPC_SHM_CLOSE_HANDLE_ID 16011
#define RTEERR_IPC_SHM_SET_SECURITY                    SAPDBErr_MessageList::Error,16012,"Setting security desriptor for %s failed, rc: %s",2
#define RTEERR_IPC_SHM_SET_SECURITY_ID 16012
#define RTEERR_IPC_SHM_OBJECT                          SAPDBErr_MessageList::Error,16013,"%s shared memory object %s failed: rc: %s",3
#define RTEERR_IPC_SHM_OBJECT_ID 16013
#define RTEERR_IPC_SHM_FTRUNCATE                       SAPDBErr_MessageList::Error,16014,"Extending shared memory object %s to size %s failed: rc: %s",3
#define RTEERR_IPC_SHM_FTRUNCATE_ID 16014
#define RTEERR_IPC_SHM_UNLINK                          SAPDBErr_MessageList::Error,16015,"Unlink shared memory object %s failed: rc: %s",2
#define RTEERR_IPC_SHM_UNLINK_ID 16015
#define RTEERR_IPC_MAILSLOT_CLOSE                      SAPDBErr_MessageList::Error,16050,"Closing mailslot %s failed",1
#define RTEERR_IPC_MAILSLOT_CLOSE_ID 16050
#define RTEERR_IPC_MAILSLOT_OBJECT_ALREADY_OPEN        SAPDBErr_MessageList::Error,16051,"Mailslot %s is already open",1
#define RTEERR_IPC_MAILSLOT_OBJECT_ALREADY_OPEN_ID 16051
#define RTEERR_IPC_MAILSLOT_CREATE                     SAPDBErr_MessageList::Error,16052,"Creating mailslot %s failed, rc: %s",2
#define RTEERR_IPC_MAILSLOT_CREATE_ID 16052
#define RTEERR_IPC_MAILSLOT_MISSING                    SAPDBErr_MessageList::Error,16053,"Mailslot %s could not be found, rc: %s",2
#define RTEERR_IPC_MAILSLOT_MISSING_ID 16053
#define RTEERR_IPC_MAILSLOT_OPEN                       SAPDBErr_MessageList::Error,16054,"Opening mailslot %s failed, rc: %s",2
#define RTEERR_IPC_MAILSLOT_OPEN_ID 16054
#define RTEERR_IPC_MAILSLOT_CLOSE_HANDLE               SAPDBErr_MessageList::Error,16055,"Closing mailslot handle of %s failed, rc: %s",2
#define RTEERR_IPC_MAILSLOT_CLOSE_HANDLE_ID 16055
#define RTEERR_IPC_MAILSLOT_NOT_OPENED                 SAPDBErr_MessageList::Error,16056,"Mailslot %s was not opened",1
#define RTEERR_IPC_MAILSLOT_NOT_OPENED_ID 16056
#define RTEERR_IPC_MAILSLOT_MESSAGE_LEN                SAPDBErr_MessageList::Error,16057,"Maximum message length exceeded for mailslot %s: allowed %s, wanted %s",3
#define RTEERR_IPC_MAILSLOT_MESSAGE_LEN_ID 16057
#define RTEERR_IPC_MAILSLOT_WRITE                      SAPDBErr_MessageList::Error,16058,"Writing to mailslot %s failed, rc: %s",2
#define RTEERR_IPC_MAILSLOT_WRITE_ID 16058
#define RTEERR_IPC_MAILSLOT_BUF_SIZE                   SAPDBErr_MessageList::Error,16059,"Buffer is too small to read from mailslot %s, wanted bytes %s",2
#define RTEERR_IPC_MAILSLOT_BUF_SIZE_ID 16059
#define RTEERR_IPC_MAILSLOT_READ                       SAPDBErr_MessageList::Error,16060,"Read from mailslot %s failed, rc: %s",2
#define RTEERR_IPC_MAILSLOT_READ_ID 16060
#define RTEERR_IPC_MAILSLOT_WRITE_NOT_ALLOWED          SAPDBErr_MessageList::Error,16061,"Write on mailslot %s is not allowed for the creator",1
#define RTEERR_IPC_MAILSLOT_WRITE_NOT_ALLOWED_ID 16061
#define RTEERR_IPC_MAILSLOT_READ_NOT_ALLOWED           SAPDBErr_MessageList::Error,16062,"Read from mailslot %s only allowed for the creator",1
#define RTEERR_IPC_MAILSLOT_READ_NOT_ALLOWED_ID 16062
#define RTEERR_IPC_MAILSLOT_GET_PIPE_BUF               SAPDBErr_MessageList::Error,16063,"Get value of PIPE_BUF failed, rc: %s",1
#define RTEERR_IPC_MAILSLOT_GET_PIPE_BUF_ID 16063
#define RTEERR_IPC_MAILSLOT_ALLOC_BUFFER               SAPDBErr_MessageList::Error,16064,"Allocation of %s bytes for mailslot buffer failed",1
#define RTEERR_IPC_MAILSLOT_ALLOC_BUFFER_ID 16064
#define RTEERR_IPC_MAILSLOT_CHANGE_OWNER               SAPDBErr_MessageList::Error,16065,"Change owner of mailslot %s failed, rc: %s",2
#define RTEERR_IPC_MAILSLOT_CHANGE_OWNER_ID 16065
#define RTEERR_IPC_MAILSLOT_UNLINK                     SAPDBErr_MessageList::Error,16066,"Unlink mailslot %s failed, rc: %s",2
#define RTEERR_IPC_MAILSLOT_UNLINK_ID 16066
#define RTEERR_IPC_MAILSLOT_STAT                       SAPDBErr_MessageList::Error,16067,"Get status of mailslot %s failed, rc: %s",2
#define RTEERR_IPC_MAILSLOT_STAT_ID 16067
#define RTEERR_IPC_MAILSLOT_NO_FIFO                    SAPDBErr_MessageList::Error,16068,"File %s is no FIFO, mode of file: %s",2
#define RTEERR_IPC_MAILSLOT_NO_FIFO_ID 16068
#define RTEWARN_IPC_MAILSLOT_DIRTY_READ                SAPDBErr_MessageList::Warning,16800,"Missing start pattern while reading data from mailslot %s",1
#define RTEWARN_IPC_MAILSLOT_DIRTY_READ_ID 16800
#define RTEWARN_IPC_MAILSLOT_MESSAGE_TOO_LONG          SAPDBErr_MessageList::Warning,16801,"Data read from mailslot exceeds maximum allowed length %s",1
#define RTEWARN_IPC_MAILSLOT_MESSAGE_TOO_LONG_ID 16801
#define RTEWARN_IPC_MAILSLOT_MISSING_END_PATTERN       SAPDBErr_MessageList::Warning,16802,"Missing end pattern while reading data from mailslot %s",1
#define RTEWARN_IPC_MAILSLOT_MISSING_END_PATTERN_ID 16802
#define RTEWARN_IPC_MAILSLOT_PROTOCOL                  SAPDBErr_MessageList::Warning,16803,"Protocol error while reading from mailslot %s: 0xFD|0x00 must not followed by a value greater than 0x02",1
#define RTEWARN_IPC_MAILSLOT_PROTOCOL_ID 16803

#endif /* RTE_IPC_MESSAGES_HPP */
