#include "Oms/OMS_UnloadableVersionList.hpp"
#include "Oms/OMS_Session.hpp"

OMS_UnloadableVersionList::OMS_UnloadableVersionList()
  : m_first(NULL)
{
}

/*---------------------------------------------------------------------------*/

void OMS_UnloadableVersionList::InsertVersion(OMS_Context* pVersion, bool callFromDestructor)
{
  OMS_Context* curr = m_first;
  while (curr)
  {
    if (curr == pVersion)
    {
      DbpBase opMsg(OMS_Globals::GetCurrentLcSink());
      opMsg.dbpOpError("ignored duplicate insert into unloadable versions");
      char versionId[sizeof(OmsVersionId)+1];
      memcpy(&versionId[0], &pVersion->GetVersionId()[0], sizeof(OmsVersionId));
      versionId[sizeof(OmsVersionId)] = 0;
      opMsg.dbpOpError("%s", &versionId[0]);
      if (callFromDestructor)
      {
        opMsg.dbpOpError("call from ~OMS_Session");           
      }
      else
      {
        opMsg.dbpOpError("call from ClearTransVersion");
      }
      return;
    }
    curr = curr->GetNextUnloaded();
  }
  pVersion->SetNextUnloaded(m_first);
  m_first = pVersion;
}

/*---------------------------------------------------------------------------*/

OMS_Context* OMS_UnloadableVersionList::RemoveVersion(OMS_Context* pVersion)
{
  OMS_Context* prev = NULL;
  OMS_Context* curr = m_first;
  while (NULL != curr)
  {
    if ((curr == pVersion) ||
      ((NULL == pVersion) && (NULL == curr->GetNextUnloaded()))) // remove last
    {
      if (NULL == prev)
      {
        m_first = curr->GetNextUnloaded();
      }
      else
      {
        prev->SetNextUnloaded(curr->GetNextUnloaded());
      }
      return curr;
    }
    else
    {
      prev = curr;
      curr = curr->GetNextUnloaded();
    }
  }
  return NULL;
}

